/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.comment.formatter.JavadocCommentFormatter;
import ro.amiq.dvt.comment.formatter.MarkdownCommentFormatter;
import ro.amiq.dvt.comment.formatter.NaturalDocsCommentFormatter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DVTComment {
    INSTANCE;


    public static String toHTML(String comment, CommentFormat format) {
        return DVTComment.format(comment, format, true, false, null, null, null, null);
    }

    public static String toHTML(String comment, CommentFormat format, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor, boolean specialImages) {
        return DVTComment.format(comment, format, true, specialImages, project, linker, element, editor);
    }

    public static String toHTML(String comment, CommentFormat format, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor, boolean specialImages, List<String> functionsArguments) {
        return DVTComment.format(comment, format, true, specialImages, project, linker, element, editor, functionsArguments);
    }

    public static String toMarkdown(String comment, CommentFormat format) {
        return DVTComment.format(comment, format, false, false, null, null, null, null);
    }

    public static String toMarkdown(String comment, CommentFormat format, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor, boolean specialImages) {
        return DVTComment.format(comment, format, false, specialImages, project, linker, element, editor);
    }

    public static String toMarkdown(String comment, CommentFormat format, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor, boolean specialImages, List<String> functionsArguments) {
        return DVTComment.format(comment, format, false, specialImages, project, linker, element, editor, functionsArguments);
    }

    private static String format(String comment, CommentFormat format, boolean toHTML, boolean specialImages, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor) {
        return DVTComment.format(comment, format, toHTML, specialImages, project, linker, element, editor, Collections.emptyList());
    }

    private static String format(String comment, CommentFormat format, boolean toHTML, boolean specialImages, IProject project, ICommentLinkResolver linker, IRfNamedElement element, ITextEditor editor, List<String> functionsArguments) {
        try {
            switch (format) {
                case MARKDOWN: {
                    comment = MarkdownCommentFormatter.INSTANCE.parse(comment, toHTML, element, linker, editor, specialImages);
                    break;
                }
                case NATURAL_DOCS: {
                    comment = NaturalDocsCommentFormatter.INSTANCE.parse(comment, element, project, linker, toHTML, editor, specialImages);
                    break;
                }
                case JAVADOC: {
                    comment = JavadocCommentFormatter.INSTANCE.parse(comment, element, linker, toHTML, editor, specialImages, functionsArguments);
                    break;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return comment;
    }

    public static enum CommentFormat {
        MARKDOWN("Markdown", "markdown", "Markdown"),
        JAVADOC("JavaDoc", "javadoc", "Javadoc"),
        RST("reStructuredText", "rst", "reStructuredText"),
        NATURAL_DOCS("NaturalDocs", "naturaldocs", "Natural Docs"),
        AUTO("Automatically Detect", "auto", "Autodetect"),
        OLD_VERBATIM("None", "noformat", "Verbatim");

        private final String name;
        private final String specadorXMLPreferenceName;
        private final String dvtPreference;

        private CommentFormat(String name, String specadorText, String dvtPreference) {
            this.name = name;
            this.specadorXMLPreferenceName = specadorText;
            this.dvtPreference = dvtPreference;
        }

        public static CommentFormat parse(String value) {
            CommentFormat[] commentFormatArray = CommentFormat.values();
            int n = commentFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommentFormat e = commentFormatArray[n2];
                if (e.specadorXMLPreferenceName.equalsIgnoreCase(value)) {
                    return e;
                }
                ++n2;
            }
            return OLD_VERBATIM;
        }

        public String toNiceTitleCase() {
            return this.name;
        }

        public String getSpecadorXMLPreferenceName() {
            return this.specadorXMLPreferenceName;
        }

        public String getPreferenceName() {
            return this.dvtPreference;
        }

        public static CommentFormat parseDVTPreference(String preference) {
            CommentFormat[] commentFormatArray = CommentFormat.values();
            int n = commentFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommentFormat e = commentFormatArray[n2];
                if (e.dvtPreference.equalsIgnoreCase(preference)) {
                    return e;
                }
                ++n2;
            }
            return OLD_VERBATIM;
        }

        public String toString() {
            return this.dvtPreference;
        }
    }
}

