/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface ICommentLinkResolver {
    public LanguageKind getLanguageKind();

    default public String linkCreatorJavaDoc(IRfNamedElement element, String linkElementName, ITextEditor editor) {
        if (element == null || linkElementName == null || linkElementName.isEmpty()) {
            return "";
        }
        String label = linkElementName;
        String[] linkWithLabel = DVTStringUtil.split(DVTStringUtil.MULTIPLE_WS, linkElementName);
        if (linkWithLabel.length == 2) {
            label = linkWithLabel[1];
            linkElementName = linkWithLabel[0];
        }
        return this.linkInternalDocumentation(element, linkElementName, label, editor);
    }

    default public String seeCreatorJavaDoc(IRfNamedElement element, String linkElementName, ITextEditor editor, boolean toHTML) {
        if (element == null || linkElementName == null || linkElementName.isEmpty()) {
            return "";
        }
        Matcher matcher = CommentConstants.JAVADOC_LINK_PATTERN.matcher(linkElementName = linkElementName.trim());
        if (matcher.matches()) {
            int firstIndexOfGT = linkElementName.indexOf("&gt;");
            String label = linkElementName.substring(firstIndexOfGT + "&gt;".length(), linkElementName.indexOf("&lt;", firstIndexOfGT));
            String protocol = matcher.group(2);
            String url = matcher.group(1);
            if (label == null || label.isEmpty()) {
                label = url;
            }
            if (protocol.isEmpty() || protocol.equals("file://")) {
                return this.linkExternalFile(element, url, label, toHTML);
            }
            return CommentUtils.getInstance().wrapIntoA(url, label, toHTML);
        }
        String label = linkElementName;
        String[] linkWithLabel = DVTStringUtil.split(DVTStringUtil.MULTIPLE_WS, linkElementName);
        if (linkWithLabel.length == 2) {
            label = linkWithLabel[1];
            linkElementName = linkWithLabel[0];
        }
        return this.linkInternalDocumentation(element, linkElementName, label, editor);
    }

    default public String linkCreatorNaturalDocs(IRfNamedElement element, String linkElementName, ITextEditor editor) {
        if (element == null || linkElementName == null || linkElementName.isEmpty()) {
            return "";
        }
        String label = linkElementName;
        String[] linkWithLabel = DVTStringUtil.split(CommentConstants.NATURALDOCS_LINK_PATTERN, linkElementName);
        if (linkWithLabel.length == 2) {
            label = linkWithLabel[0];
            linkElementName = linkWithLabel[1];
        }
        if (linkElementName.contains("http://") || linkElementName.contains("https://")) {
            return CommentUtils.getInstance().wrapIntoA(linkElementName, label, false);
        }
        if (linkElementName.contains("file://")) {
            return this.linkExternalFile(element, linkElementName, label, false);
        }
        if (DVTStringUtil.matches(CommentConstants.EMAIL_PATTERN, linkElementName)) {
            return CommentUtils.getInstance().wrapIntoMail(linkElementName, label);
        }
        String internalLink = this.linkInternalDocumentation(element, linkElementName, label, editor);
        if (!internalLink.isEmpty()) {
            return internalLink;
        }
        return this.linkExternalFile(element, linkElementName, label, false);
    }

    default public String linkInternalDocumentation(IRfNamedElement element, String linkElementName, String label, ITextEditor editor) {
        Collection<IRfNamedElement> candidates;
        Object[] parsedLink;
        boolean isAbsolutePath = false;
        String packageName = "";
        String originalLinkElementName = label;
        int indexOfPackageDelimiter = linkElementName.indexOf("::");
        if (indexOfPackageDelimiter > 0 && !(packageName = linkElementName.substring(0, indexOfPackageDelimiter)).isEmpty() && !packageName.contains(".")) {
            linkElementName = linkElementName.substring(indexOfPackageDelimiter + 2);
            isAbsolutePath = true;
        }
        if (CommentUtils.getInstance().containsUnpermittedPatterns(linkElementName)) {
            return "";
        }
        boolean startsLikeAMacro = linkElementName.contains("`");
        if (startsLikeAMacro) {
            linkElementName = linkElementName.substring(1);
        }
        if ((parsedLink = DVTStringUtil.split(CommentConstants.LINK_SPLIT_PATTERN, DVTStringUtil.unescapeXMLString(linkElementName, true))).length == 0 || startsLikeAMacro && parsedLink.length > 1) {
            return "";
        }
        parsedLink = CommentUtils.getInstance().cleanArray((String[])parsedLink);
        if (element.getRfProject() == null) {
            return "";
        }
        IProject project = element.getRfProject().getProject();
        if (project == null || project.getLocation() == null) {
            return "";
        }
        Collection<IRfNamedElement> collection = candidates = isAbsolutePath ? this.getPackageCandidates(packageName, project) : this.getInitialCandidates(element, editor);
        if ((candidates == null || candidates.isEmpty()) && isAbsolutePath) {
            candidates = this.getInitialCandidates(element, editor);
            parsedLink = (String[])ArrayUtils.add((Object[])parsedLink, (int)0, (Object)packageName);
            isAbsolutePath = false;
        }
        if (candidates == null) {
            candidates = new ArrayList();
        }
        if (!isAbsolutePath) {
            candidates.add(element);
        }
        try {
            IRfNamedElement foundElement = this.solveHyperlinkForAllCandidates(element, candidates, (String[])parsedLink, System.currentTimeMillis() + 500L);
            if (foundElement != null) {
                return this.createLinkToElement(foundElement, originalLinkElementName);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (linkElementName.endsWith("s")) {
            return this.linkInternalDocumentation(element, linkElementName.substring(0, linkElementName.length() - 1), originalLinkElementName, editor);
        }
        return "";
    }

    default public String linkExternalFile(IRfNamedElement element, String linkElementName, String label, boolean toHTML) {
        File file;
        String fileName = linkElementName;
        String anchor = "";
        if (fileName.contains("file://")) {
            fileName = linkElementName.substring("file://".length());
        }
        if (fileName.contains("#")) {
            anchor = fileName.substring(fileName.indexOf(35));
            fileName = fileName.substring(0, fileName.indexOf(35));
        }
        if ((file = new File(fileName)).exists()) {
            return CommentUtils.getInstance().wrapIntoA(String.valueOf(linkElementName) + anchor, label, toHTML);
        }
        if (element.getRfProject() == null) {
            return "";
        }
        IProject project = element.getRfProject().getProject();
        if (project == null || project.getLocation() == null) {
            return "";
        }
        file = new File(project.getLocation().toFile(), fileName);
        if (file.exists()) {
            return CommentUtils.getInstance().wrapIntoA(String.valueOf(file.toString()) + anchor, label, toHTML);
        }
        Set<String> paths = BuildConfigManager.getDocumentationResourceLocations(project);
        for (String path : paths) {
            file = new File(path, fileName);
            if (!file.exists()) continue;
            return CommentUtils.getInstance().wrapIntoA(String.valueOf(file.toString()) + anchor, label, toHTML);
        }
        return "";
    }

    public DVTTooltipContent getCommentFromLink(String var1);

    public void goToDeclarationOfElementFromLink(String var1);

    public IFile getFile(IRfNamedElement var1, IProject var2);

    public IFile getIFileFromElement(IRfNamedElement var1);

    public List<IRfNamedElement> getPackageCandidates(String var1, IProject var2);

    public IRfNamedElement getNamedElementFromPath(String var1, IProject var2);

    public String createLinkToElement(IRfNamedElement var1, String var2);

    public Collection<IRfNamedElement> getInitialCandidates(IRfNamedElement var1, ITextEditor var2);

    public IRfNamedElement recursiveFindElement(IRfNamedElement var1, String[] var2, int var3, long var4) throws Exception;

    public IRfNamedElement solveHyperlinkForAllCandidates(IRfNamedElement var1, Collection<IRfNamedElement> var2, String[] var3, long var4);
}

