/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum JavadocCommentFormatter {
    INSTANCE;

    private static final Pattern JAVADOC_AT_SEE_PATTERN;
    private static final Pattern JAVADOC_AT_SINCE_PATTERN;
    private static final Pattern JAVADOC_AT_VERSION_PATTERN;
    private static final Pattern JAVADOC_AT_AUTHOR_PATTERN;
    private static final Pattern JAVADOC_AT_LINK_PATTERN;
    private static final Pattern JAVADOC_AT_LITERAL_PATTERN;
    private static final Pattern JAVADOC_AT_CODE_PATTERN;
    private static final Pattern JAVADOC_AT_PARAM_PATTERN;
    private static final Pattern JAVADOC_AT_RETURN_PATTERN;
    private static final Pattern JAVADOC_AT_DEPRECATED_PATTERN;
    public static final String IGNORE_JAVADOC_LITERAL_START = "```LITERAL_START```";
    public static final String IGNORE_JAVADOC_LITERAL_END = "```LITERAL_END```";
    public static final String IGNORE_JAVADOC_CODE_START = "```CODE_START```";
    public static final String IGNORE_JAVADOC_CODE_END = "```CODE_END```";
    public static final Pattern[] SPECIAL_TAGS;

    static {
        JAVADOC_AT_SEE_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[sS][eE][eE][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_SINCE_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[sS][iI][nN][cC][eE][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_VERSION_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[vV][eE][rR][sS][iI][oO][nN][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_AUTHOR_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[aA][uU][tT][hH][oO][rR][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_LINK_PATTERN = Pattern.compile("(\\{@[lL][iI][nN][kK]\\s+([^\\n\\}]+)\\})");
        JAVADOC_AT_LITERAL_PATTERN = Pattern.compile("(\\{@[lL][iI][tT][eE][rR][aA][lL](.*?)\\})");
        JAVADOC_AT_CODE_PATTERN = Pattern.compile("(\\{@[cC][oO][dD][eE](.*?)\\})");
        JAVADOC_AT_PARAM_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[pP][aA][rR][aA][mM][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_RETURN_PATTERN = Pattern.compile("(?ms)((?:^|\\n)[ \\t]*@[rR][eE][tT][uU][rR][nN][ \\t]+(((?!\\n\\s*@).)*))");
        JAVADOC_AT_DEPRECATED_PATTERN = Pattern.compile("(?m)((?:^|\\n)[ \\t]*@[dD][eE][pP][rR][eE][cC][aA][tT][eE][dD][ \\t]+([^\\n\\r]*))");
        SPECIAL_TAGS = new Pattern[]{JAVADOC_AT_AUTHOR_PATTERN, JAVADOC_AT_LINK_PATTERN, JAVADOC_AT_LITERAL_PATTERN, JAVADOC_AT_CODE_PATTERN, JAVADOC_AT_PARAM_PATTERN, JAVADOC_AT_RETURN_PATTERN, JAVADOC_AT_SEE_PATTERN, JAVADOC_AT_SINCE_PATTERN, JAVADOC_AT_VERSION_PATTERN, JAVADOC_AT_DEPRECATED_PATTERN};
    }

    public String parse(String comment, IRfNamedElement element, ICommentLinkResolver linker, boolean toHTML, ITextEditor editor, boolean specialImages, List<String> arguments) {
        comment = DVTStringUtil.replaceAll(CommentConstants.DELIMITER_LINE_STRING, comment, "\n\n");
        comment = comment.concat("\n");
        Pattern[] patterns = new Pattern[]{JAVADOC_AT_PARAM_PATTERN, JAVADOC_AT_RETURN_PATTERN, JAVADOC_AT_SINCE_PATTERN, JAVADOC_AT_VERSION_PATTERN, JAVADOC_AT_SEE_PATTERN, JAVADOC_AT_AUTHOR_PATTERN, JAVADOC_AT_LINK_PATTERN};
        StringBuilder commentFooter = new StringBuilder();
        StringBuilder commentHeader = new StringBuilder();
        LinkedList<String> ignoreLiteralSyntax = new LinkedList<String>();
        LinkedList<String> ignoreCodeSyntax = new LinkedList<String>();
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        String temp = null;
        temp = JavadocCommentFormatter.applyJavadocLiteralPattern(comment, ignoreLiteralSyntax);
        if (temp != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = JavadocCommentFormatter.applyJavadocCodePattern(comment, ignoreCodeSyntax, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            LinkedList<String> params = new LinkedList<String>();
            Matcher matcher = pattern.matcher(comment);
            sb.setLength(0);
            lastMatchIndex = 0;
            while (matcher.find()) {
                if (matcher.groupCount() < 2) continue;
                String elemRegex = matcher.group(1);
                String elemText = matcher.group(2).trim();
                if (elemRegex == null || elemRegex.isEmpty()) continue;
                if (JAVADOC_AT_LINK_PATTERN.pattern().equals(pattern.pattern())) {
                    link = linker.linkCreatorJavaDoc(element, elemText, editor);
                    if (link != null && !link.isEmpty()) {
                        sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
                        sb.append(link);
                        lastMatchIndex = matcher.end(1);
                    }
                    elemText = null;
                } else if (JAVADOC_AT_SEE_PATTERN.pattern().equals(pattern.pattern())) {
                    link = linker.seeCreatorJavaDoc(element, elemText, editor, toHTML);
                    if (link != null && !link.isEmpty()) {
                        elemText = link;
                    }
                } else if (JAVADOC_AT_PARAM_PATTERN.pattern().equals(pattern.pattern())) {
                    String[] text = DVTStringUtil.split(DVTStringUtil.MULTIPLE_WS, elemText);
                    String argumentName = text[0];
                    if (arguments.stream().anyMatch(argument -> argument.equals(argumentName))) {
                        sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
                        lastMatchIndex = matcher.end(1);
                        continue;
                    }
                }
                if (elemText == null) continue;
                params.add(elemText);
                sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
                lastMatchIndex = matcher.end(1);
            }
            if (lastMatchIndex > 0) {
                sb.append(comment.substring(lastMatchIndex));
                comment = sb.toString();
            }
            if (!params.isEmpty()) {
                if (JAVADOC_AT_PARAM_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append((CharSequence)JavadocCommentFormatter.buildJavadocFooter(params, "Arguments:", toHTML));
                } else if (JAVADOC_AT_SEE_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append(JavadocCommentFormatter.buildJavadocFooter(params, "See Also:", toHTML).toString());
                } else if (JAVADOC_AT_SINCE_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append((CharSequence)JavadocCommentFormatter.buildJavadocFooter(params, "Since:", toHTML));
                } else if (JAVADOC_AT_VERSION_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append((CharSequence)JavadocCommentFormatter.buildJavadocFooter(params, "Version:", toHTML));
                } else if (JAVADOC_AT_RETURN_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append((CharSequence)JavadocCommentFormatter.buildJavadocFooter(params, "Returns:", toHTML));
                } else if (JAVADOC_AT_AUTHOR_PATTERN.pattern().equals(pattern.pattern())) {
                    commentFooter = commentFooter.append((CharSequence)JavadocCommentFormatter.buildJavadocFooter(params, "Author" + (params.size() > 1 ? "s:" : ":"), toHTML));
                }
            }
            ++n2;
        }
        temp = this.applyJavadocDeprecatedPattern(comment, commentHeader, toHTML);
        if (temp != null && !temp.isEmpty()) {
            comment = temp;
        }
        comment = comment.trim();
        comment = CommentUtils.getInstance().replaceHtmlTagSymbols(comment, toHTML);
        comment = CommentUtils.getInstance().splitTextIntoBlockElements(comment, toHTML);
        String commentHeaderString = CommentUtils.getInstance().replaceHtmlTagSymbols(CommentUtils.getInstance().wrapIntoParagraph(commentHeader.toString(), toHTML), toHTML);
        String commentFooterString = CommentUtils.getInstance().replaceHtmlTagSymbols(CommentUtils.getInstance().wrapIntoParagraph(commentFooter.toString(), toHTML), toHTML);
        String result = String.valueOf(commentHeaderString) + comment + commentFooterString;
        result = CommentUtils.getInstance().replaceUnicodeCharacters(result);
        result = JavadocCommentFormatter.replaceNumberedMarkers(result, ignoreLiteralSyntax, ignoreCodeSyntax);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static String replaceNumberedMarkers(String comment, List<String> ignoreLiteralSyntax, List<String> ignoreCodeSyntax) {
        tmp = new StringBuilder();
        shouldReiterate = false;
        firstStartIndex = -1;
        secondStartIndex = -1;
        commentIndex = 0;
        if (comment.indexOf("```", commentIndex) != -1) ** GOTO lbl33
        return comment;
        while ((secondStartIndex = comment.indexOf("```", firstStartIndex + "```".length())) != -1) {
            tag = comment.substring(firstStartIndex, secondStartIndex + "```".length());
            if (tag.equals("```LITERAL_START```")) {
                secondTagIndex = comment.indexOf("```LITERAL_END```", firstStartIndex + "```LITERAL_START```".length());
                if (secondTagIndex != 1 && (number = Integer.valueOf(numberString = comment.substring(firstStartIndex + "```LITERAL_START```".length(), secondTagIndex)).intValue()) <= ignoreLiteralSyntax.size() - 1) {
                    tmp.append(comment.subSequence(commentIndex, firstStartIndex));
                    tmp.append(ignoreLiteralSyntax.get(number));
                    commentIndex = secondTagIndex + "```LITERAL_END```".length();
                    shouldReiterate = true;
                }
            } else if (tag.equals("```CODE_START```")) {
                secondTagIndex = comment.indexOf("```CODE_END```", firstStartIndex + "```CODE_START```".length());
                if (secondTagIndex != 1 && (number = Integer.valueOf(numberString = comment.substring(firstStartIndex + "```CODE_START```".length(), secondTagIndex)).intValue()) <= ignoreCodeSyntax.size() - 1) {
                    tmp.append(comment.subSequence(commentIndex, firstStartIndex));
                    tmp.append(ignoreCodeSyntax.get(number));
                    commentIndex = secondTagIndex + "```CODE_END```".length();
                    shouldReiterate = true;
                }
            } else {
                tmp.append(comment.substring(commentIndex, firstStartIndex + 1));
                commentIndex = firstStartIndex + 1;
            }
lbl33:
            // 4 sources

            if ((firstStartIndex = comment.indexOf("```", commentIndex)) != -1) continue;
        }
        tmp.append(comment.subSequence(commentIndex, comment.length()));
        if (shouldReiterate) {
            return JavadocCommentFormatter.replaceNumberedMarkers(tmp.toString(), ignoreLiteralSyntax, ignoreCodeSyntax);
        }
        return tmp.toString();
    }

    protected String applyJavadocDeprecatedPattern(String comment, StringBuilder commentHeader, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = JAVADOC_AT_DEPRECATED_PATTERN.matcher(comment);
        if (matcher.find()) {
            String elemText = matcher.group(2);
            commentHeader = commentHeader.append(String.valueOf(CommentUtils.getInstance().wrapIntoBold("DEPRECATED:", toHTML)) + " ");
            if (elemText != null) {
                sb.append(comment.substring(lastMatchIndex, matcher.start(0)));
                lastMatchIndex = matcher.end(0);
                commentHeader = commentHeader.append(elemText);
            }
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private static String applyJavadocLiteralPattern(String comment, List<String> ignoreLiteralSyntax) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        int counter = 0;
        Matcher matcher = JAVADOC_AT_LITERAL_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty()) continue;
            ignoreLiteralSyntax.add(elemText);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(IGNORE_JAVADOC_LITERAL_START).append(counter++).append(IGNORE_JAVADOC_LITERAL_END);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private static String applyJavadocCodePattern(String comment, List<String> ignoreCodeSyntax, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        int counter = 0;
        Matcher matcher = JAVADOC_AT_CODE_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty()) continue;
            ignoreCodeSyntax.add(CommentUtils.getInstance().wrapIntoCode(elemText, false, toHTML));
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(IGNORE_JAVADOC_CODE_START).append(counter++).append(IGNORE_JAVADOC_CODE_END);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private static StringBuilder buildJavadocFooter(List<String> params, String sectionName, boolean toHTML) {
        StringBuilder commentFooter = new StringBuilder();
        StringBuilder sections = new StringBuilder();
        commentFooter.append(CommentUtils.getInstance().wrapIntoDefinitionName(sectionName, true, toHTML));
        for (String param : params) {
            sections.append(CommentUtils.getInstance().wrapIntoParagraph(param, toHTML));
        }
        commentFooter = commentFooter.append(CommentUtils.getInstance().wrapIntoDefinitionDescription(sections.toString(), toHTML));
        commentFooter = new StringBuilder(CommentUtils.getInstance().wrapIntoDefintionList(commentFooter.toString(), toHTML));
        return commentFooter;
    }
}

