/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;

public final class MarkdownCommentFormatter
extends Enum<MarkdownCommentFormatter> {
    public static final /* enum */ MarkdownCommentFormatter INSTANCE;
    protected static final Invocable MARKED;
    public static final String SOURCE_FILE = "/resources/marked/marked.dvt.rhino.js";
    private static final String ADMONITION_TAG = "!!!";
    private static final Pattern SINGLE_LINE_LINK_PATTERN;
    private static final Pattern REFERENCE_STYLE_LINK_PATTERN;
    private static final String REFERENCE_LINK_PATTERN = "(\\[%s\\]\\:\\s*#)([^\\s]+)";
    private static final Pattern SINGLE_LINE_IMAGE_PATTERN;
    private static final Pattern REFERENCE_STYLE_IMAGE_PATTERN;
    private static final String REFERENCE_IMAGE_PATTERN = "(\\[%s\\]\\:\\s*)([^\\s]+)";
    private static final Pattern MARKDOWN_CODE_BLOCK;
    private static final /* synthetic */ MarkdownCommentFormatter[] ENUM$VALUES;

    static {
        block15: {
            Invocable js;
            block13: {
                INSTANCE = new MarkdownCommentFormatter();
                ENUM$VALUES = new MarkdownCommentFormatter[]{INSTANCE};
                js = null;
                try {
                    try {
                        ScriptEngine scriptEngine = null;
                        scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
                        if (scriptEngine == null) break block13;
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStream stream = JarUtils.getFileStream(SOURCE_FILE, MarkdownCommentFormatter.class);){
                            scriptEngine.eval(DVTStringUtil.streamToString(stream));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        js = (Invocable)((Object)scriptEngine);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        MARKED = js;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    MARKED = js;
                    throw throwable;
                }
            }
            MARKED = js;
        }
        SINGLE_LINE_LINK_PATTERN = Pattern.compile("((?<!!)\\[([^\\[\\]\\n\\r]+)\\]\\(\\#)([^\\s\\)]+)(([^\\S\\n\\r]+[^\\)]*)?\\))");
        REFERENCE_STYLE_LINK_PATTERN = Pattern.compile("(?<!!)(\\[([^\\[\\]]+)\\]) ?\\[([^\\]]+)\\]");
        SINGLE_LINE_IMAGE_PATTERN = Pattern.compile("(\\!\\[[^\\[\\]\\n\\r]+\\]\\()([^\\s\\)]+)(([^\\S\\n\\r]+[^\\)]*)?\\))");
        REFERENCE_STYLE_IMAGE_PATTERN = Pattern.compile("\\!(\\[[^\\[\\]]+\\]) ?\\[([^\\]]+)\\]");
        MARKDOWN_CODE_BLOCK = Pattern.compile("(?s)(```)((?:(?!```).)*)(```)");
    }

    protected void checkMarked() {
        if (MARKED == null) {
            throw new IllegalStateException("Marked Engine has encountered an error during initialization!");
        }
    }

    public synchronized String parse(String comment, boolean toHTML, IRfNamedElement element, ICommentLinkResolver linker, ITextEditor editor, boolean specialImages) {
        try {
            comment = this.cleanComment(comment);
            comment = DVTStringUtil.unindentLinesToLevel(comment, System.lineSeparator());
            comment = this.preProcessImages(comment, element, specialImages);
            comment = this.preProcessLinks(comment, element, linker, editor);
            if (!toHTML) {
                return comment;
            }
            this.checkMarked();
            return (String)MARKED.invokeMethod(((ScriptEngine)((Object)MARKED)).get("dvt"), "parse", comment, comment.contains(ADMONITION_TAG));
        }
        catch (NoSuchMethodException | ScriptException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return comment;
        }
    }

    private String cleanComment(String comment) {
        comment = DVTStringUtil.replaceAll(CommentConstants.LT_PATTERN, comment, "<");
        comment = DVTStringUtil.replaceAll(CommentConstants.GT_PATTERN, comment, ">");
        return comment;
    }

    private String preProcessLinks(String comment, IRfNamedElement element, ICommentLinkResolver linker, ITextEditor editor) {
        if (element == null) {
            return comment;
        }
        comment = this.preProcessSingleLineLinks(comment, element, linker, editor);
        comment = this.preProcessReferenceStyleLinks(comment, element, linker, editor);
        return comment;
    }

    private String preProcessSingleLineLinks(String comment, IRfNamedElement element, ICommentLinkResolver linker, ITextEditor editor) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = SINGLE_LINE_LINK_PATTERN.matcher(comment);
        while (matcher.find()) {
            String link;
            if (matcher.groupCount() < 3) continue;
            String label = matcher.group(2);
            String elementName = matcher.group(3);
            if (elementName == null || elementName.isEmpty() || label == null || label.isEmpty() || (link = linker.linkInternalDocumentation(element, elementName, label, editor)) == null || link.isEmpty()) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(link);
            lastMatchIndex = matcher.end();
        }
        sb.append(comment.substring(lastMatchIndex));
        return sb.toString();
    }

    private String preProcessReferenceStyleLinks(String comment, IRfNamedElement element, ICommentLinkResolver linker, ITextEditor editor) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = REFERENCE_STYLE_LINK_PATTERN.matcher(comment);
        while (matcher.find()) {
            if (matcher.groupCount() < 2) continue;
            String label = matcher.group(2);
            String imageTag = matcher.group(3);
            if (imageTag == null || imageTag.isEmpty() || label == null || label.isEmpty()) continue;
            String link = "";
            Pattern pattern = Pattern.compile(String.format(REFERENCE_LINK_PATTERN, imageTag));
            Matcher matcher2 = pattern.matcher(comment);
            if (matcher2.find()) {
                if (matcher2.groupCount() < 2) continue;
                String elementName = matcher2.group(2);
                link = linker.linkInternalDocumentation(element, elementName, label, editor);
            }
            if (link == null || link.isEmpty()) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(link);
            lastMatchIndex = matcher.end();
        }
        sb.append(comment.substring(lastMatchIndex));
        return sb.toString();
    }

    private String preProcessImages(String comment, IRfNamedElement element, boolean specialImages) {
        if (element == null) {
            return comment;
        }
        comment = this.preProcessSingleLineImages(comment, element, specialImages);
        Matcher matcher = REFERENCE_STYLE_IMAGE_PATTERN.matcher(comment);
        while (matcher.find()) {
            String imageTag = matcher.group(2);
            comment = this.preProcessReferenceStyleImages(comment, element, imageTag, specialImages);
        }
        return comment;
    }

    private String preProcessReferenceStyleImages(String comment, IRfNamedElement element, String imageTag, boolean specialImages) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Pattern pattern = Pattern.compile(String.format(REFERENCE_IMAGE_PATTERN, imageTag));
        Matcher matcher = pattern.matcher(comment);
        while (matcher.find()) {
            String path;
            String imagePath;
            if (matcher.groupCount() < 2 || (imagePath = matcher.group(2)) == null || imagePath.isEmpty() || (path = this.resolvePath(imagePath, element, specialImages)) == null || path.isEmpty()) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(2)));
            sb.append(path);
            lastMatchIndex = matcher.end();
        }
        sb.append(comment.substring(lastMatchIndex));
        return sb.toString();
    }

    private String preProcessSingleLineImages(String comment, IRfNamedElement element, boolean specialImages) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = SINGLE_LINE_IMAGE_PATTERN.matcher(comment);
        while (matcher.find()) {
            String path;
            String imagePath;
            if (matcher.groupCount() < 2 || (imagePath = matcher.group(2)) == null || imagePath.isEmpty() || (path = this.resolvePath(imagePath, element, specialImages)) == null || path.isEmpty()) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(2)));
            sb.append(path);
            sb.append(comment.substring(matcher.end(2), matcher.end()));
            lastMatchIndex = matcher.end();
        }
        sb.append(comment.substring(lastMatchIndex));
        return sb.toString();
    }

    private String resolvePath(String imagePath, IRfNamedElement element, boolean copyImage) {
        File image = this.getImage(imagePath, element);
        if (image == null) {
            return imagePath;
        }
        if (!copyImage) {
            return image.getAbsolutePath();
        }
        this.copyImageToDocumentation(imagePath, element, image);
        return imagePath;
    }

    private File getImage(String imagePath, IRfNamedElement element) {
        File image = new File(imagePath);
        if (image.isAbsolute() && image.exists()) {
            return image;
        }
        String elementLocation = CommentUtils.getInstance().getElementLocation(element);
        if (elementLocation != null) {
            image = Paths.get(elementLocation, new String[0]).resolve(imagePath).toFile();
        }
        if (image.exists()) {
            return image;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return null;
        }
        for (String location : BuildConfigManager.getDocumentationResourceLocations(project)) {
            image = Paths.get(location, new String[0]).resolve(imagePath).toFile();
            if (!image.exists()) continue;
            return image;
        }
        return null;
    }

    private void copyImageToDocumentation(String imagePath, IRfNamedElement element, File image) {
        String elementFullPath = LanguageContributor.get(element.getLanguageKind()).getFullPath(element);
        if (elementFullPath == null || elementFullPath.isEmpty()) {
            return;
        }
        File sourceDirectory = new File(LanguageContributor.get(element.getLanguageKind()).getOutputLocation());
        Path relativize = sourceDirectory.toPath().relativize(Paths.get(elementFullPath, new String[0]).getParent());
        StringBuilder location = new StringBuilder(sourceDirectory.getAbsolutePath());
        location.append(File.separator).append("extern");
        location.append(File.separator).append(relativize.toString());
        location.append(File.separator).append(imagePath);
        File destination = new File(location.toString());
        File parentLocation = new File(destination.getParent());
        try {
            parentLocation.mkdirs();
            Files.copy((File)image, (File)destination);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean hasCodeBlock(String comment) {
        Matcher matcher = MARKDOWN_CODE_BLOCK.matcher(comment);
        return matcher.find();
    }

    public static MarkdownCommentFormatter[] values() {
        MarkdownCommentFormatter[] markdownCommentFormatterArray = ENUM$VALUES;
        int n = markdownCommentFormatterArray.length;
        MarkdownCommentFormatter[] markdownCommentFormatterArray2 = new MarkdownCommentFormatter[n];
        System.arraycopy(ENUM$VALUES, 0, markdownCommentFormatterArray2, 0, n);
        return markdownCommentFormatterArray2;
    }

    public static MarkdownCommentFormatter valueOf(String string) {
        return Enum.valueOf(MarkdownCommentFormatter.class, string);
    }
}

