/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.comment.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.comment.formatter.MarkdownCommentFormatter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum NaturalDocsCommentFormatter {
    INSTANCE;

    public static final String IGNORE_NATURAL_DOCS_PRE = "```HTML_IGNORE_PRE_MARK```";
    public static final String IGNORE_NATURAL_DOCS_CODE = "```HTML_IGNORE_CODE_MARK```";
    public static final Pattern NATURALDOCS_DEFINITION_LIST;
    public static final Pattern NATURALDOCS_HEADING;
    protected static final Pattern NATURALDOCS_LINK_PATTERN;
    protected static final Pattern NATURALDOCS_ITALLIC_FONT_PATTERN;
    protected static final Pattern NATURALDOCS_BOLD_FONT_PATTERN;
    protected static final Pattern NATURALDOCS_ITALLIC_BOLD_FONT_PATTERN;
    protected static final Pattern NATURALDOCS_UNDERLINE_FONT_PATTERN;
    protected static final Pattern NATURALDOCS_BULLET_LIST;
    protected static final Pattern NATURALDOCS_BULLET_LIST_LINE;
    protected static final Pattern NATURALDOCS_START_CODE;
    protected static final Pattern NATURALDOCS_IMAGE;
    protected static final Pattern NATURALDOCS_TOPIC_LINE;
    protected static final Pattern NATURALDOCS_HTML_PRE_PATTERN;
    public static final Pattern[] SPECIAL_TAGS;
    private static final Pattern[] NATURALDOCS_TAGS;
    private static final Pattern MARKDOWN_REFERENCE_STYLE_LINK;

    static {
        NATURALDOCS_DEFINITION_LIST = Pattern.compile("(^[\\+\\-\\* ]*((?:[^\\-\\+\\n\\*])*[^\\t\\v\\f ]+[\\t\\f ]+)\\-([\\t\\v\\f ].*\\n(?:(?:[^\\n](?![\\t\\v\\f ]\\-[\\t\\v\\f ]))+\\n)*))", 8);
        NATURALDOCS_HEADING = Pattern.compile("(?:\\n[ \\t]*\\n)(([^:\\n\\|]*[^:\\n\\| ]+[^:\\n\\|]*):[ \\t]*(\\n[ \\t]*\\n?(?:[\\p{Alnum}<>\\-o\\+\\*\\_].*)(?:\\n.*\\p{Alnum}.*)*))", 8);
        NATURALDOCS_LINK_PATTERN = Pattern.compile("(?m)(&lt;((?:(?!&gt;|&lt;).)+)&gt;)");
        NATURALDOCS_ITALLIC_FONT_PATTERN = Pattern.compile("(?m)(?:^| |\\W|_)(~((?:(?!~).)+)~)(?=$| |\\W|_)");
        NATURALDOCS_BOLD_FONT_PATTERN = Pattern.compile("(?m)(?:^| |\\W|_)(\\*((?:(?!\\*).)+)\\*)(?=$| |\\W|_)");
        NATURALDOCS_ITALLIC_BOLD_FONT_PATTERN = Pattern.compile("(?m)(?:^| |\\W|_)((~\\*|\\*~)((?:(?!~).)+)(~\\*|\\*~))(?=$| |\\W|_)");
        NATURALDOCS_UNDERLINE_FONT_PATTERN = Pattern.compile("(?m)(?:^| |\\W|_)(_((?:.)+?)_)(?=$| |\\W|_)");
        NATURALDOCS_BULLET_LIST = Pattern.compile("(?s)(?m)(^[ \\t]*[\\-o\\+\\*][ \\t]+(?:.(?!\\n\\s*\\n\\s*|^[ \\t]*[\\-o\\+\\*][^ \\t]+))*.)", 8);
        NATURALDOCS_BULLET_LIST_LINE = Pattern.compile("(?s)(?m)(^[ \\t]*[\\-o\\+\\*][ \\t]+((?:.(?!(\\n\\s*\\n\\s*|^[ \\t]*[\\-o\\+\\*][ \\t]*)))*.))");
        NATURALDOCS_START_CODE = Pattern.compile("(?m)[ \\t]*(\\(start\\s+code\\)\\n*((?:(.|\\n)(?!\\(end\\)))*(.|\\n))(\\s\\(end\\)))", 8);
        NATURALDOCS_IMAGE = Pattern.compile("(?m)(\\(see[ \\t]+((.*?)\\.[A-Za-z0-9]+)[ \\t]*\\))");
        NATURALDOCS_TOPIC_LINE = Pattern.compile("(^|^\\n|\\n[ \\t]*\\n)(([^\\n\\|:\\-\\+]+):([^\\S\\r\\n]+.+))");
        NATURALDOCS_HTML_PRE_PATTERN = Pattern.compile("(?m)^[\\t ]*(:|>|&gt;|\\|).+(?:\\n[\\t ]*(:|>|&gt;|\\|).*)*");
        SPECIAL_TAGS = new Pattern[]{NATURALDOCS_START_CODE};
        NATURALDOCS_TAGS = new Pattern[]{NATURALDOCS_DEFINITION_LIST, NATURALDOCS_HEADING, NATURALDOCS_IMAGE, NATURALDOCS_LINK_PATTERN, NATURALDOCS_TOPIC_LINE};
        MARKDOWN_REFERENCE_STYLE_LINK = Pattern.compile("\\[.*\\]");
    }

    public String parse(String comment, IRfNamedElement element, IProject project, ICommentLinkResolver linker, boolean toHTML, ITextEditor editor, boolean specialImages) {
        comment = comment.replace("<", "&lt;").replace(">", "&gt;");
        comment = DVTStringUtil.replaceAll(CommentConstants.DELIMITER_LINE_STRING, comment, "\n\n");
        comment = "\n".concat(comment).concat("\n");
        ArrayList<String> ignoredPreSyntax = new ArrayList<String>();
        ArrayList<String> ignoredCodeSyntax = new ArrayList<String>();
        String temp = null;
        temp = this.applyNaturalDocsPrePattern(comment, ignoredPreSyntax, toHTML);
        if (temp != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsCodePattern(comment, ignoredCodeSyntax, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsUnderlinePattern(comment = comment.replace("#", "&num;"), toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsItalicBoldPattern(comment)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsBoldPattern(comment)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsItalicPattern(comment)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsLinkPattern(comment, element, linker, editor)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if (comment.contains("DEPRECATED")) {
            comment = comment.replace("DEPRECATED", CommentUtils.getInstance().wrapIntoBold("DEPRECATED"));
        }
        if ((temp = this.applyNaturalDocsHeadingPattern(comment, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsTopicPattern(comment, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsDefinitionListPattern(comment, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsBulletListPattern(comment, toHTML)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        if ((temp = this.applyNaturalDocsImagePattern(comment, element, project, specialImages)) != null && !temp.isEmpty()) {
            comment = temp;
        }
        comment = CommentUtils.getInstance().replaceHtmlTagSymbols(comment, toHTML);
        comment = this.trimText(comment);
        comment = CommentUtils.getInstance().splitTextIntoBlockElements(comment);
        comment = this.replaceMarkers(comment, ignoredCodeSyntax, IGNORE_NATURAL_DOCS_CODE, ignoredPreSyntax, IGNORE_NATURAL_DOCS_PRE);
        comment = MarkdownCommentFormatter.INSTANCE.parse(comment, toHTML, element, linker, editor, specialImages);
        comment = comment.replace("&num;", "#");
        return comment;
    }

    private String applyNaturalDocsPrePattern(String comment, List<String> ignoredSyntax, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_HTML_PRE_PATTERN.matcher(comment);
        while (matcher.find()) {
            String tmp;
            String elemRegex = matcher.group(0);
            if (elemRegex == null || elemRegex.isEmpty() || (tmp = elemRegex.replaceAll("(?m)^\\s*(:|>|&gt;|\\|)", "")).trim().isEmpty()) continue;
            ignoredSyntax.add(CommentUtils.getInstance().wrapIntoPre(tmp, toHTML));
            sb.append(comment.substring(lastMatchIndex, matcher.start()));
            sb.append(IGNORE_NATURAL_DOCS_PRE);
            lastMatchIndex = matcher.end();
            if (!comment.startsWith("\n", matcher.end())) continue;
            lastMatchIndex += "\n".length();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsCodePattern(String comment, List<String> ignoredSyntax, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_START_CODE.matcher(comment);
        while (matcher.find()) {
            String code;
            if (matcher.groupCount() < 2 || (code = matcher.group(2)) == null || code.isEmpty()) continue;
            String elemText = CommentUtils.getInstance().wrapIntoPre(code, toHTML);
            ignoredSyntax.add(elemText);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(IGNORE_NATURAL_DOCS_CODE);
            lastMatchIndex = matcher.end();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsLinkPattern(String comment, IRfNamedElement element, ICommentLinkResolver linker, ITextEditor editor) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_LINK_PATTERN.matcher(comment);
        while (matcher.find()) {
            String link;
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty() || (link = linker.linkCreatorNaturalDocs(element, elemText, editor)) == null || link.isEmpty()) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(link);
            lastMatchIndex = matcher.end();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsItalicPattern(String comment) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_ITALLIC_FONT_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty()) continue;
            elemText = CommentUtils.getInstance().wrapIntoItalic(elemText);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(elemText);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsBoldPattern(String comment) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_BOLD_FONT_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty()) continue;
            elemText = CommentUtils.getInstance().wrapIntoBold(elemText);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(elemText);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsUnderlinePattern(String comment, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_UNDERLINE_FONT_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 2 || (elemText = matcher.group(2)) == null || elemText.isEmpty()) continue;
            elemText = CommentUtils.getInstance().wrapIntoUnderline(elemText, toHTML);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(elemText);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsHeadingPattern(String comment, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_HEADING.matcher("\n\n" + comment);
        while (matcher.find()) {
            if (matcher.groupCount() < 3) continue;
            String heading = matcher.group(2);
            String heading_content = matcher.group(3);
            if (heading == null || heading_content == null || heading.isEmpty() || heading_content.isEmpty()) continue;
            heading = CommentUtils.getInstance().wrapIntoDiv(heading.trim(), "heading_title", toHTML);
            heading_content = heading_content.trim();
            matcher.group(0);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1) - 2));
            sb.append(String.valueOf(heading) + heading_content);
            lastMatchIndex = matcher.end(1) - 2;
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsTopicPattern(String comment, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_TOPIC_LINE.matcher(comment);
        while (matcher.find()) {
            String wholeElemRegex;
            if (matcher.groupCount() < 4 || (wholeElemRegex = matcher.group(0)) == null || wholeElemRegex.isEmpty()) continue;
            String topic = matcher.group(3);
            String name = matcher.group(4);
            if (topic == null || topic.trim().isEmpty() || name == null || name.trim().isEmpty()) continue;
            StringBuilder tmp = new StringBuilder();
            tmp.append(CommentUtils.getInstance().wrapIntoDiv(topic.trim(), "topic_title", toHTML)).append(CommentUtils.getInstance().wrapIntoDiv(name.trim(), "topic_content", toHTML));
            sb.append(comment.substring(lastMatchIndex, matcher.start(2)));
            sb.append((CharSequence)tmp);
            lastMatchIndex = matcher.end();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsBulletListPattern(String comment, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_BULLET_LIST.matcher(comment);
        while (matcher.find()) {
            String elemRegex;
            if (matcher.groupCount() < 1 || (elemRegex = matcher.group(1)) == null || elemRegex.isEmpty()) continue;
            Matcher matcher2 = NATURALDOCS_BULLET_LIST_LINE.matcher(elemRegex);
            StringBuilder newText = new StringBuilder();
            while (matcher2.find() && matcher2.groupCount() >= 2) {
                String bulletContent = matcher2.group(2);
                if (bulletContent == null || bulletContent.isEmpty()) continue;
                newText.append(CommentUtils.getInstance().wrapIntoListItem(bulletContent.trim(), toHTML));
            }
            if (newText.length() <= 0) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(String.valueOf(CommentUtils.getInstance().wrapIntoUnorderedList(newText.toString(), toHTML)) + "\n");
            lastMatchIndex = matcher.end();
            if (!comment.startsWith("\n", matcher.end())) continue;
            lastMatchIndex += "\n".length();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsDefinitionListPattern(String comment, boolean toHTML) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_DEFINITION_LIST.matcher(comment);
        boolean start = true;
        while (matcher.find()) {
            if (matcher.groupCount() < 3) continue;
            String elemName = matcher.group(2);
            String elemDefinition = matcher.group(3);
            if (elemName == null || elemDefinition == null || elemName.isEmpty() || elemDefinition.isEmpty()) continue;
            elemName = CommentUtils.getInstance().wrapIntoDefinitionName(elemName, true, toHTML);
            elemDefinition = CommentUtils.getInstance().wrapIntoDefinitionDescription(elemDefinition, toHTML);
            StringBuilder tmp = new StringBuilder();
            tmp.append(elemName).append(elemDefinition);
            if (start) {
                sb.append(comment.substring(lastMatchIndex, matcher.start()));
                start = false;
            } else {
                sb.append(comment.substring(lastMatchIndex, matcher.start()).trim());
            }
            lastMatchIndex = matcher.end();
            sb.append(CommentUtils.getInstance().wrapIntoDefintionList(CommentUtils.getInstance().wrapIntoDiv(tmp.toString(), "def_list_wrapper", toHTML), toHTML));
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    private String applyNaturalDocsImagePattern(String comment, Object element, IProject project, boolean specialImages) {
        IRfNamedElement namedElement;
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_IMAGE.matcher(comment);
        IRfNamedElement iRfNamedElement = namedElement = element instanceof IRfNamedElement ? (IRfNamedElement)element : null;
        if (namedElement == null) {
            return "";
        }
        String elementLocationDirectoryPath = CommentUtils.getInstance().getElementLocation(namedElement);
        while (matcher.find()) {
            if (matcher.groupCount() < 3) continue;
            String fullName = matcher.group(2);
            String fileName = matcher.group(3);
            if (fullName == null || fileName == null || fullName.isEmpty() || fileName.isEmpty()) continue;
            String fullPath = "";
            File imageFile = new File(fullName);
            if (imageFile.isAbsolute() && imageFile.exists()) {
                fullPath = imageFile.getAbsolutePath();
            }
            if (fullPath == null || fullPath.isEmpty()) {
                for (String location : BuildConfigManager.getNaturalDocsImagesLocations(project)) {
                    imageFile = new File(String.valueOf(location) + File.separator + fullName);
                    if (!imageFile.exists()) continue;
                    fullPath = imageFile.getAbsolutePath();
                    break;
                }
                for (String location : BuildConfigManager.getDocumentationResourceLocations(project)) {
                    imageFile = new File(String.valueOf(location) + File.separator + fullName);
                    if (!imageFile.exists()) continue;
                    fullPath = imageFile.getAbsolutePath();
                    break;
                }
            }
            if ((fullPath == null || fullPath.isEmpty()) && (imageFile = new File(String.valueOf(elementLocationDirectoryPath) + File.separator + fullName)).exists()) {
                fullPath = imageFile.getAbsolutePath();
            }
            if (fullPath == null || fullPath.isEmpty()) continue;
            fileName = new File(fileName).getName();
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(CommentUtils.getInstance().wrapIntoImg(fullPath, fileName, !specialImages));
            lastMatchIndex = matcher.end();
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    protected String applyNaturalDocsItalicBoldPattern(String comment) {
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        Matcher matcher = NATURALDOCS_ITALLIC_BOLD_FONT_PATTERN.matcher(comment);
        while (matcher.find()) {
            String elemText;
            if (matcher.groupCount() < 4 || (elemText = matcher.group(3)) == null || elemText.isEmpty()) continue;
            elemText = CommentUtils.getInstance().wrapIntoItalicBold(elemText);
            sb.append(comment.substring(lastMatchIndex, matcher.start(1)));
            sb.append(elemText);
            lastMatchIndex = matcher.end(1);
        }
        if (lastMatchIndex > 0) {
            sb.append(comment.substring(lastMatchIndex));
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String trimText(String comment) {
        startIndex = 0;
        endIndex = comment.length() - 1;
        shouldStop = true;
        if (startIndex != endIndex) ** GOTO lbl14
        return comment;
lbl-1000:
        // 1 sources

        {
            shouldStop = true;
            if (comment.charAt(startIndex) == '\n') {
                ++startIndex;
                shouldStop = false;
            }
            if (comment.charAt(endIndex) == '\n') {
                --endIndex;
                shouldStop = false;
            }
            if (shouldStop) break;
lbl14:
            // 2 sources

            ** while (startIndex < endIndex)
        }
lbl15:
        // 2 sources

        if (startIndex == endIndex && comment.charAt(startIndex) == '\n') {
            return "";
        }
        return comment.substring(startIndex, endIndex + 1);
    }

    /*
     * Unable to fully structure code
     */
    private String replaceMarkers(String comment, List<String> markersList1, String marker1, List<String> markersList2, String marker2) {
        tmp = new StringBuilder();
        commentIndex = 0;
        startMarkerIndex1 = -1;
        startMarkerIndex2 = -1;
        listIndex1 = 0;
        listIndex2 = 0;
        startMarkerIndex1 = comment.indexOf(marker1, commentIndex);
        startMarkerIndex2 = comment.indexOf(marker2, commentIndex);
        if (startMarkerIndex1 != -1 || startMarkerIndex2 != -1) ** GOTO lbl26
        return comment;
lbl-1000:
        // 1 sources

        {
            if (listIndex1 <= markersList1.size() - 1 && (startMarkerIndex1 > -1 && startMarkerIndex1 <= startMarkerIndex2 || startMarkerIndex2 == -1)) {
                tmp.append(this.getSubsequence(comment, commentIndex, startMarkerIndex1));
                tmp.append(markersList1.get(listIndex1++));
                commentIndex = startMarkerIndex1 + marker1.length();
                startMarkerIndex1 = comment.indexOf(marker1, commentIndex);
                continue;
            }
            if (listIndex2 > markersList2.size() - 1 || (startMarkerIndex2 <= -1 || startMarkerIndex2 > startMarkerIndex1) && startMarkerIndex1 != -1) continue;
            tmp.append(this.getSubsequence(comment, commentIndex, startMarkerIndex2));
            tmp.append(markersList2.get(listIndex2++));
            commentIndex = startMarkerIndex2 + marker2.length();
            startMarkerIndex2 = comment.indexOf(marker2, commentIndex);
lbl26:
            // 4 sources

            ** while (startMarkerIndex1 != -1 || startMarkerIndex2 != -1)
        }
lbl27:
        // 1 sources

        tmp.append(comment.subSequence(commentIndex, comment.length()));
        return this.replaceMarker(tmp.toString(), markersList2, marker2, listIndex2).toString();
    }

    private StringBuilder replaceMarker(String comment, List<String> markersList, String marker, int listIndex) {
        StringBuilder tmp = new StringBuilder();
        int commentIndex = 0;
        int startMarkerIndex = -1;
        while ((startMarkerIndex = comment.indexOf(marker, commentIndex)) != -1) {
            tmp.append(comment.subSequence(commentIndex, startMarkerIndex));
            tmp.append(markersList.get(listIndex++));
            commentIndex = startMarkerIndex + marker.length();
        }
        tmp.append(comment.subSequence(commentIndex, comment.length()));
        return tmp;
    }

    protected CharSequence getSubsequence(String comment, int commentIndex, int startMarkerIndex) {
        return comment.subSequence(commentIndex, startMarkerIndex);
    }

    public boolean isValid(String comment) {
        comment = DVTStringUtil.replaceAll(CommentConstants.DELIMITER_LINE_STRING, comment, "\n\n").replace("<", "&lt;").replace(">", "&gt;");
        Matcher matcher = null;
        Pattern[] patternArray = NATURALDOCS_TAGS;
        int n = NATURALDOCS_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern naturalDocPattern = patternArray[n2];
            matcher = naturalDocPattern.matcher("\n\n" + comment);
            while (matcher.find()) {
                String topic;
                String tag;
                if (naturalDocPattern.pattern().equals(NATURALDOCS_LINK_PATTERN.pattern()) && matcher.groupCount() >= 2 && CommentConstants.HTML_TAGS.contains(tag = matcher.group(2)) || naturalDocPattern.pattern().equals(NATURALDOCS_TOPIC_LINE.pattern()) && matcher.groupCount() >= 4 && DVTStringUtil.matches(MARKDOWN_REFERENCE_STYLE_LINK, (topic = matcher.group(3)).trim())) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }
}

