/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigBuilder;
import ro.amiq.dvt.core.DVTNatureCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTNature
extends DVTNatureCommon {
    public void configure() throws CoreException {
        IProject project = this.getProject();
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(projectDescription.getBuildSpec()));
        for (ICommand command : commands) {
            if (!command.getBuilderName().equals("ro.amiq.dvt.MixedLangBuilder")) continue;
            return;
        }
        ICommand builderCommand = projectDescription.newCommand();
        builderCommand.setBuilderName("ro.amiq.dvt.MixedLangBuilder");
        commands.add(builderCommand);
        projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        this.getProject().setDescription(projectDescription, null);
        BuildConfigBuilder.deleteMarkersAndProperties(project);
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(projectDescription.getBuildSpec()));
        if (!(projectDescription.hasNature("ro.amiq.edt.enature") || projectDescription.hasNature("ro.amiq.slndt.slnnature") || projectDescription.hasNature("ro.amiq.msdldt.msdlnature") || projectDescription.hasNature("ro.amiq.pssdt.pssnature") || projectDescription.hasNature("ro.amiq.vlogdt.VlogNature") || projectDescription.hasNature("ro.amiq.vhdldt.VhdlNature") || projectDescription.hasNature("ro.amiq.dvt.pfnature") || projectDescription.hasNature("ro.amiq.dvt.cdt.cppnature") || projectDescription.hasNature("ro.amiq.dvt.cdt.cppextnature"))) {
            Iterator iterator = commands.iterator();
            while (iterator.hasNext()) {
                if (!((ICommand)iterator.next()).getBuilderName().equals("ro.amiq.dvt.MixedLangBuilder")) continue;
                iterator.remove();
            }
            projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            this.getProject().setDescription(projectDescription, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnyDVTNature(IProjectDescription projectDescription) {
        try {
            String nature;
            Iterator iterator = fAvailableNatures.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!projectDescription.hasNature(nature = (String)iterator.next()));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static boolean projectHasNature(IProject project, String nature) {
        try {
            return project != null && project.isNatureEnabled(nature);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static void addNature(IProject project, String natureID, IProgressMonitor monitor) {
        block16: {
            if (project != null) {
                try {
                    boolean hasTclPluginInstalled;
                    if (project.hasNature(natureID)) break block16;
                    IProjectDescription projectDescription = project.getDescription();
                    ArrayList<String> natures = new ArrayList<String>(Arrays.asList(projectDescription.getNatureIds()));
                    natures.add(0, natureID);
                    boolean addTclNatureByHand = false;
                    boolean bl = hasTclPluginInstalled = Platform.getBundle((String)"org.eclipse.dltk.tcl.core") != null;
                    if ("ro.amiq.dvt.pfnature".equals(natureID)) {
                        if (hasTclPluginInstalled) {
                            natures.add(0, "org.eclipse.dltk.tcl.core.nature");
                        } else {
                            addTclNatureByHand = true;
                        }
                    }
                    natures.remove("ro.amiq.dvt.dvtnature");
                    int mixed = 0;
                    int i = 0;
                    while (i < natures.size()) {
                        if (project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.slndt.slnnature") || project.hasNature("ro.amiq.msdldt.msdlnature") || project.hasNature("ro.amiq.pssdt.pssnature") || project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.vhdldt.VhdlNature") || project.hasNature("ro.amiq.dvt.pfnature") || project.hasNature("ro.amiq.dvt.cdt.cppnature") || project.hasNature("ro.amiq.dvt.cdt.cppextnature")) {
                            ++mixed;
                        }
                        ++i;
                    }
                    if (mixed > 1 && !natures.contains("ro.amiq.dvt.dvtnature")) {
                        natures.add(0, "ro.amiq.dvt.dvtnature");
                    }
                    projectDescription.setNatureIds(natures.toArray(new String[natures.size()]));
                    project.setDescription(projectDescription, monitor);
                    if (!addTclNatureByHand) break block16;
                    String path = String.valueOf(project.getLocation().toOSString()) + "/.project";
                    BufferedReader reader = null;
                    BufferedWriter writer = null;
                    ArrayList<String> lines = new ArrayList<String>();
                    try {
                        try {
                            reader = new BufferedReader(new FileReader(path));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                if (line.contains("</natures>")) {
                                    lines.add("\t\t<nature>org.eclipse.dltk.tcl.core.nature</nature>");
                                }
                                lines.add(line);
                            }
                            DVTUtilsCommon.INSTANCE.closeClosable(reader);
                            writer = new BufferedWriter(new FileWriter(path));
                            for (String l : lines) {
                                writer.write(l);
                                writer.newLine();
                            }
                            DVTUtilsCommon.INSTANCE.closeClosable(writer);
                        }
                        catch (IOException iOException) {
                            DVTUtilsCommon.INSTANCE.closeClosable(reader);
                            DVTUtilsCommon.INSTANCE.closeClosable(writer);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        DVTUtilsCommon.INSTANCE.closeClosable(reader);
                        DVTUtilsCommon.INSTANCE.closeClosable(writer);
                        throw throwable;
                    }
                    DVTUtilsCommon.INSTANCE.closeClosable(reader);
                    DVTUtilsCommon.INSTANCE.closeClosable(writer);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    public static void removeNature(IProject project, String natureID, IProgressMonitor monitor) {
        if (project != null) {
            try {
                if (project.hasNature(natureID)) {
                    IProjectDescription projectDescription = project.getDescription();
                    ArrayList<String> natures = new ArrayList<String>(Arrays.asList(projectDescription.getNatureIds()));
                    natures.remove(natureID);
                    if ("ro.amiq.dvt.pfnature".equals(natureID)) {
                        natures.remove("org.eclipse.dltk.tcl.core.nature");
                    }
                    int mixed = 0;
                    for (String nature : natures) {
                        if (!nature.equals("ro.amiq.edt.enature") && !nature.equals("ro.amiq.slndt.slnnature") && !nature.equals("ro.amiq.msdldt.msdlnature") && !nature.equals("ro.amiq.pssdt.pssnature") && !nature.equals("ro.amiq.vlogdt.VlogNature") && !nature.equals("ro.amiq.vhdldt.VhdlNature") && !nature.equals("ro.amiq.dvt.pfnature") && !nature.equals("ro.amiq.dvt.cdt.cppnature") && !nature.equals("ro.amiq.dvt.cdt.cppextnature")) continue;
                        ++mixed;
                    }
                    if (mixed <= 1) {
                        natures.remove("ro.amiq.dvt.dvtnature");
                    }
                    projectDescription.setNatureIds(natures.toArray(new String[natures.size()]));
                    project.setDescription(projectDescription, monitor);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateDeprecatedProject(IProject project) {
        try {
            if (project == null || !project.isAccessible()) {
                return false;
            }
            IProjectDescription projectDescription = project.getDescription();
            List<ICommand> buildSpec = Arrays.asList(projectDescription.getBuildSpec());
            ArrayList<ICommand> commands = new ArrayList<ICommand>(buildSpec);
            if (!(project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.vhdldt.VhdlNature"))) {
                return true;
            }
            for (ICommand command : commands) {
                if (!command.getBuilderName().equals("ro.amiq.dvt.MixedLangBuilder")) continue;
                return true;
            }
            ICommand builderCommand = projectDescription.newCommand();
            builderCommand.setBuilderName("ro.amiq.dvt.MixedLangBuilder");
            commands.add(builderCommand);
            projectDescription.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            IFile projectFile = project.getFile(".project");
            projectFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
            while (readOnly) {
                MessageDialog ms = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "", null, "The project description file must be updated in order to restore the project.Rebuild the project after removing the write access restrictions on: \n" + projectFile.getLocation().toOSString(), 1, new String[]{IDialogConstants.ABORT_LABEL, IDialogConstants.RETRY_LABEL}, 0);
                int option = ms.open();
                if (option == 0) {
                    return false;
                }
                if (option != 1) continue;
                projectFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                readOnly = projectFile.getResourceAttributes().isReadOnly();
            }
            project.setDescription(projectDescription, (IProgressMonitor)new NullProgressMonitor());
            projectFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

