/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.core;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class DVTNatureCommon
implements IProjectNature {
    public static final String NATURE_ID = "ro.amiq.dvt.dvtnature";
    protected static final Map<String, String> fAvailableNatures = new ImmutableMap.Builder().put((Object)"e Language", (Object)"ro.amiq.edt.enature").put((Object)"SLN Language", (Object)"ro.amiq.slndt.slnnature").put((Object)"M-SDL Language", (Object)"ro.amiq.msdldt.msdlnature").put((Object)"PSS Language", (Object)"ro.amiq.pssdt.pssnature").put((Object)"Verilog/SystemVerilog Language", (Object)"ro.amiq.vlogdt.VlogNature").put((Object)"VHDL Language", (Object)"ro.amiq.vhdldt.VhdlNature").put((Object)"Power Format Language", (Object)"ro.amiq.dvt.pfnature").put((Object)"CPP Langauge", (Object)"ro.amiq.dvt.cdt.cppnature").build();
    protected IProject fProject;

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public static boolean hasNature(IProject project, String natureID) {
        boolean hasNature;
        block2: {
            hasNature = false;
            try {
                hasNature = project.hasNature(natureID);
            }
            catch (Exception e) {
                if (e.getClass().getName().endsWith("ResourceException")) break block2;
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return hasNature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnyDVTNatureEnabled(IProject project) {
        try {
            String nature;
            Iterator<String> iterator = fAvailableNatures.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!DVTNature.projectHasNature(project, nature = iterator.next()));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static List<String> getProjectNatures(IProject project) {
        ArrayList<String> natures = new ArrayList<String>();
        try {
            for (Map.Entry<String, String> nature : fAvailableNatures.entrySet()) {
                if (!DVTNature.projectHasNature(project, nature.getValue())) continue;
                natures.add(nature.getKey());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return natures;
    }
}

