/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXArrayValues;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XMapValues;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;

public class DVTDebugTooltipUtil {
    static IELParamValue getHierarchicalVariableValue(String name, IRfNamedElementAndScope namedElementAndScope, IHidEvaluator hidEvaluator, IIntrpEvaluator intrpEvaluator, Map<String, IRfNamedElementAndScope> indexElementMap) {
        if (namedElementAndScope == null || hidEvaluator == null) {
            return null;
        }
        IRfNamedElement element = namedElementAndScope.getIRfNamedElement();
        ArrayDeque<? extends IRfNamedElementAndScope> scopestack = new ArrayDeque<IRfNamedElementAndScope>(namedElementAndScope.getElementAndScopeStack());
        if (element == null || scopestack == null) {
            return null;
        }
        IRfNamedElementAndScope ancestorScope = (IRfNamedElementAndScope)scopestack.poll();
        IRfNamedElement ancestorNamedElement = ancestorScope.getIRfNamedElement();
        if (ancestorNamedElement == null) {
            return null;
        }
        String[] variables = DVTStringUtil.splitHierarhicalString(name);
        int i = 0;
        String currentName = variables[i];
        IELParamValue value = DVTDebugTooltipUtil.debuggerGetVariable(hidEvaluator, currentName, ancestorNamedElement, intrpEvaluator, indexElementMap);
        while (!scopestack.isEmpty() && value != null) {
            ancestorScope = (IRfNamedElementAndScope)scopestack.poll();
            ancestorNamedElement = ancestorScope.getIRfNamedElement();
            if (ancestorNamedElement == null) {
                return null;
            }
            currentName = variables[++i];
            value = DVTDebugTooltipUtil.debuggerGetVariable(value, currentName, ancestorNamedElement, intrpEvaluator, indexElementMap);
        }
        if (value != null) {
            currentName = variables[++i];
            value = DVTDebugTooltipUtil.debuggerGetVariable(value, currentName, element, intrpEvaluator, indexElementMap);
        }
        return value;
    }

    static boolean isHierarchicalVariable(IRfNamedElementAndScope elementScope) {
        if (elementScope == null) {
            return false;
        }
        Deque<? extends IRfNamedElementAndScope> elementAndScopeStack = elementScope.getElementAndScopeStack();
        if (elementAndScopeStack == null || elementAndScopeStack.isEmpty()) {
            return false;
        }
        ArrayDeque<? extends IRfNamedElementAndScope> scopestack = new ArrayDeque<IRfNamedElementAndScope>(elementAndScopeStack);
        if (scopestack == null || scopestack.isEmpty()) {
            return false;
        }
        IRfNamedElement parentElement = ((IRfNamedElementAndScope)scopestack.pop()).getIRfNamedElement();
        IRfNamedElement element = scopestack.isEmpty() ? elementScope.getIRfNamedElement() : ((IRfNamedElementAndScope)scopestack.pop()).getIRfNamedElement();
        Collection<? extends IRfNamedElement> members = null;
        if (parentElement instanceof IRfClockingBlockElement) {
            members = parentElement.getMembers(true, false);
        }
        if (parentElement instanceof IRfFieldElement) {
            IRfNamedElement associatedType = ((IRfFieldElement)parentElement).getAssociatedType();
            if (associatedType == null) {
                return false;
            }
            if (associatedType instanceof IRfListType) {
                associatedType = ((IRfListType)associatedType).getAssociatedType();
            }
            if (associatedType instanceof IRfSpecializedTypeElement) {
                return true;
            }
            members = associatedType.getMembers(true, false);
        }
        if (members == null || members.isEmpty()) {
            return false;
        }
        return members.contains(element);
    }

    public static IELParamValue debuggerGetVariable(IHidEvaluator hidEvaluator, String variableName, IRfNamedElement element, IIntrpEvaluator intrpEvaluator, Map<String, IRfNamedElementAndScope> indexElementMap) {
        XThread activeThread = ((XValueHolder)hidEvaluator).getFactory().getActiveThread();
        IXThreadImpl threadImpl = activeThread.getXThreadDefinition().getXThreadImpl();
        if (!(threadImpl instanceof IntrpDebugThread)) {
            return null;
        }
        IntrpDebugThread debugThread = (IntrpDebugThread)threadImpl;
        boolean oldEvaluatingDebugExpression = debugThread.isEvaluatingDebugExpression();
        debugThread.setEvaluatingDebugExpression(true);
        try {
            if (variableName == null || variableName.startsWith("$")) {
                return null;
            }
            String[] variables = DVTStringUtil.splitHierarhicalString(variableName);
            if (!(hidEvaluator instanceof IELParamValue)) {
                return null;
            }
            IELParamValue variableScope = (IELParamValue)hidEvaluator;
            int i = 0;
            while (i < variables.length) {
                String variable = variables[i];
                if (variableScope instanceof ELParamValues.ParamValueNumber) {
                    variableScope = DVTDebugTooltipUtil.getStructValue(variableScope, variable);
                } else {
                    if (!(variableScope instanceof XValueHolder)) {
                        return null;
                    }
                    List<String> indices = DVTStringUtil.extractArrayIndices(variable);
                    if (indices == null) {
                        value = ((XValueHolder)variableScope).getValueImpl(variable, i == variables.length - 1 ? element : null, false, false, false, null);
                        if (ELUtils.isUnsuccessfulEval(value)) {
                            return null;
                        }
                        XValueHolder refValueHolder = ((XValueHolder)variableScope).getRefValueHolder();
                        if (refValueHolder != null) {
                            variableScope = refValueHolder;
                        }
                        variableScope = XUtils.getValue(value);
                    } else {
                        value = ((XValueHolder)variableScope).getValueImpl(variable = variable.substring(0, variable.indexOf("[")), i == variables.length - 1 ? element : null, false, false, false, null);
                        if (ELUtils.isUnsuccessfulEval(value)) {
                            return null;
                        }
                        variableScope = XUtils.getValue(value);
                        if ((variableScope = DVTDebugTooltipUtil.getValueAtIndices(hidEvaluator, intrpEvaluator, indexElementMap, variableScope, indices)) == null) {
                            return null;
                        }
                    }
                }
                ++i;
            }
            if (variableScope.getElement() instanceof IRfMethodElement) {
                return null;
            }
            IELParamValue iELParamValue = variableScope;
            return iELParamValue;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        finally {
            debugThread.setEvaluatingDebugExpression(oldEvaluatingDebugExpression);
        }
    }

    private static IELParamValue getStructValue(IELParamValue variableScope, String variable) {
        DVTXVariableInfo key;
        ELParamValues.ParamValueNumber valueNumber = (ELParamValues.ParamValueNumber)variableScope;
        Map<DVTXVariableInfo, IELParamValue> structValues = valueNumber.debuggerGetVariables(false);
        IELParamValue value = structValues.get(key = new DVTXVariableInfo(variable, DVTXVariableType.NO_TYPE));
        if (value == null) {
            return variableScope;
        }
        return value;
    }

    private static IELParamValue getValueAtIndices(IHidEvaluator hidEvaluator, IIntrpEvaluator intrpEvaluator, Map<String, IRfNamedElementAndScope> indexElementMap, IELParamValue variableScope, List<String> indices) throws DebugException {
        for (String index : indices) {
            IXArrayValues arrayValues;
            if (!(variableScope instanceof XArrayValueHolder)) {
                return null;
            }
            VlogBitVector convertedNumber = ELUtils.parseIntegerNumberVLOG(index, null, null);
            if (convertedNumber != null) {
                int arrayIndex = ((DVTNumber)convertedNumber).intValue();
                if ((variableScope = DVTDebugTooltipUtil.getArrayItemScope(variableScope, arrayIndex)) != null) continue;
                return null;
            }
            IRfNamedElementAndScope namedElementScope = indexElementMap.get(index);
            IELParamValue indexValue = null;
            indexValue = DVTDebugTooltipUtil.isHierarchicalVariable(namedElementScope) ? DVTDebugTooltipUtil.getHierarchicalVariableValue(index, namedElementScope, hidEvaluator, intrpEvaluator, indexElementMap) : DVTDebugTooltipUtil.debuggerGetVariable(hidEvaluator, index, null, intrpEvaluator, indexElementMap);
            if (indexValue == null) {
                return null;
            }
            IValue iValue = ((IntrpVariable)intrpEvaluator.getVariable(hidEvaluator, index, indexValue, DVTXVariableType.NO_TYPE)).getValue();
            convertedNumber = ELUtils.parseIntegerNumberVLOG(iValue.getValueString(), null, null);
            if (convertedNumber != null) {
                int arrayIndex = ((DVTNumber)convertedNumber).intValue();
                if ((variableScope = DVTDebugTooltipUtil.getArrayItemScope(variableScope, arrayIndex)) != null) continue;
                return null;
            }
            if (!(variableScope instanceof XArrayValueHolder) || !((arrayValues = ((XArrayValueHolder)variableScope).getArrayValues()) instanceof XMapValues)) continue;
            variableScope = ((XMapValues)arrayValues).get(indexValue, hidEvaluator.getCachedSimGuardian(true));
        }
        return variableScope;
    }

    public static IELParamValue getArrayItemScope(IELParamValue variableScope, int index) {
        if (!(variableScope instanceof XArrayValueHolder)) {
            return variableScope;
        }
        Map<DVTXVariableInfo, IELParamValue> arrayValues = variableScope.debuggerGetVariables(false);
        ArrayList<Map.Entry<DVTXVariableInfo, IELParamValue>> entryList = new ArrayList<Map.Entry<DVTXVariableInfo, IELParamValue>>(arrayValues.entrySet());
        if (((Map.Entry)entryList.get(0)).getValue() instanceof ELParamValues.ParamValueNumber.ArraySliceHolder) {
            for (Map.Entry entry : entryList) {
                ELParamValues.ParamValueNumber.ArraySliceHolder sliceHolder = (ELParamValues.ParamValueNumber.ArraySliceHolder)entry.getValue();
                if (index < sliceHolder.getLowerBound() || index >= sliceHolder.getUpperBound()) continue;
                Map<DVTXVariableInfo, IELParamValue> sliceItems = sliceHolder.debuggerGetVariables(false);
                return new ArrayList<Map.Entry<DVTXVariableInfo, IELParamValue>>(sliceItems.entrySet()).get(index -= sliceHolder.getLowerBound()).getValue();
            }
            return null;
        }
        if (arrayValues == null || arrayValues.isEmpty() || index > arrayValues.size()) {
            return null;
        }
        if (index == arrayValues.size()) {
            return variableScope;
        }
        variableScope = (IELParamValue)((Map.Entry)entryList.get(index)).getValue();
        if (!(variableScope instanceof XValueHolder)) {
            return variableScope;
        }
        XValueHolder xValueHolder = ((XValueHolder)variableScope).getRefValueHolder();
        if (xValueHolder != null) {
            variableScope = xValueHolder;
        }
        return variableScope;
    }
}

