/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTargetCommon;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;

public class IntrpDebugTarget
extends IntrpDebugTargetCommon {
    private ILaunch launch;
    private List<IReflectionContributor> reflectionContributors;

    public static IntrpDebugTarget create(IProject project, ILaunch launch, String name, String testName, IIntrpEvaluator intrpEvaluator, IXThreadScheduler xThreadScheduler) {
        IntrpDebugTarget debugTarget = new IntrpDebugTarget(project, launch, name, testName, intrpEvaluator, xThreadScheduler);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)debugTarget);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)debugTarget);
        return debugTarget;
    }

    private IntrpDebugTarget(IProject project, ILaunch launch, String name, String testName, IIntrpEvaluator intrpEvaluator, IXThreadScheduler xThreadScheduler) {
        super(project, name, testName, intrpEvaluator, xThreadScheduler);
        this.launch = launch;
        this.reflectionContributors = RfMixedLangManager.getInstance().getEnabledContributors(project);
    }

    @Override
    public void openHotSwapFailedDialog() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Utils.asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Hot Code Replace Failed!", null, "Some code changes could not be hot swapped. Do you want to terminate the current debug session?", 2, new String[]{"Cancel", "Terminate"}, 0);
            int optionId = dialog.open();
            if (optionId == 0) {
                return;
            }
            this.terminate();
        });
    }

    @Override
    protected void getEditorModifiedElements(Map<IRfNamedElement, Boolean> allChanged) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(() -> {
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IEditorReference[] openEditorsReference = activePage.getEditorReferences();
            if (openEditorsReference == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = openEditorsReference;
            int n = openEditorsReference.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                IEditorPart editor = editorReference.getEditor(false);
                if (editor instanceof DVTEditor) {
                    DVTEditor dvtEditor = (DVTEditor)editor;
                    this.getAllChangesForEditor(allChanged, dvtEditor);
                }
                ++n2;
            }
        });
    }

    @Override
    protected void handleTerminate() {
        this.launch.removeDebugTarget((IDebugTarget)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
        SourceLookupFacility.shutdown();
        this.removeDecorations();
    }

    public void removeDecorations() {
        DecorationManager.removeDecorations((IDebugTarget)this);
        InstructionPointerManager.getDefault().removeAnnotations((IDebugTarget)this);
    }

    @Override
    protected void removeBreakpointManager() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Method enableTriggerPointsM = breakpointManager.getClass().getMethod("enableTriggerPoints", IBreakpoint[].class, Boolean.TYPE);
            enableTriggerPointsM.invoke((Object)breakpointManager, null, true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {}
        try {
            IBreakpoint[] iBreakpointArray = breakpointManager.getBreakpoints();
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof BaseBreakpoint) {
                    ((BaseBreakpoint)breakpoint).restoreHitCount();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        breakpointManager.removeBreakpointListener((IBreakpointListener)this);
        breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    @Override
    protected IBreakpoint[] getBreakpoints() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return null;
        }
        IBreakpoint[] allBreakpoints = breakpointManager.getBreakpoints();
        ArrayList<IBreakpoint> currentBreakpoints = new ArrayList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray = allBreakpoints;
        int n = allBreakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint.getMarker().getResource().getProject() == this.getProject()) {
                currentBreakpoints.add(breakpoint);
            }
            ++n2;
        }
        if (!currentBreakpoints.isEmpty()) {
            this.hasBreakpoints = true;
        }
        return currentBreakpoints.toArray(new IBreakpoint[0]);
    }

    @Override
    protected int getBreakpointLine(LineBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        IResource resource = marker.getResource();
        if (resource == null) {
            return -1;
        }
        return marker.getAttribute("lineNumber", -1);
    }

    @Override
    protected IPath getBreakpointPath(LineBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        IResource resource = marker.getResource();
        if (resource == null) {
            return null;
        }
        return resource.getLocation();
    }

    public boolean isDebugMode() {
        return this.launch == null || !"run".equals(this.launch.getLaunchMode());
    }

    public List<IReflectionContributor> getReflectionContributors() {
        return this.reflectionContributors;
    }
}

