/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import antlr.collections.impl.BitSet;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpDebugListener;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThreadKindGroup;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.interpreter.DVTRunLaunchCache;
import ro.amiq.dvt.interpreter.IXTerminateListener;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XViewsThreadCache;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaListener;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class IntrpDebugTargetCommon
extends IntrpDebugElement
implements IBreakpointManagerListener,
IDebugTarget,
IIntrpLabelProvider,
IIncrementalDeltaListener {
    protected static final BitSet NO_LINES = new BitSet();
    protected static final String HOTSWAP_FAILED_MESSAGE = "Some code changes could not be hot swapped. Do you want to terminate the current debug session?";
    public static final String HOTSWAP_FAILED_TITLE = "Hot Code Replace Failed!";
    private LastExecutedStatementInfo lastExecutedStatement;
    private IProject project;
    private String name;
    private String testName;
    private IIntrpEvaluator intrpEvaluator;
    protected IXThreadScheduler xThreadScheduler;
    private IXTerminateListener xTerminateListener;
    private boolean isTerminated;
    private boolean isSuspended;
    private boolean isEnabled;
    private boolean isDebugging;
    private boolean isStepIntoInitEnable;
    private boolean isStepIntoNewThreads;
    private boolean isStepIntoAssignEnable;
    private boolean isShowOnlyCurrentThread;
    private boolean isLogStatementEnable;
    private boolean isAutobreak;
    private Writer logStatementWritter;
    private int statementCounter;
    public XThread currentStackThread;
    public boolean initPreviously;
    private IntrpDebugThread.State globalInitLastRequestedState;
    protected Map<String, BitSet> breakpointsMap;
    protected Map<String, Watchpoint> watchpointsMap;
    protected boolean hasBreakpoints;
    private ListenerList fIntrpDebugListeners = new ListenerList();

    protected IntrpDebugTargetCommon(IProject project, String name, String testName, IIntrpEvaluator intrpEvaluator, IXThreadScheduler xThreadScheduler) {
        super(null);
        this.project = project;
        this.name = name;
        this.testName = testName;
        this.intrpEvaluator = intrpEvaluator;
        this.xThreadScheduler = xThreadScheduler;
        this.breakpointsMap = new HashMap<String, BitSet>();
        this.watchpointsMap = new HashMap<String, Watchpoint>();
        this.isStepIntoInitEnable = BuildConfigManager.getXStepIntoInitialization(project);
        this.isStepIntoNewThreads = BuildConfigManager.getXStepIntoNewThreads(project);
        this.isLogStatementEnable = BuildConfigManager.getXLogExecutedStatement(project);
        this.isStepIntoAssignEnable = BuildConfigManager.getXStepIntoAssigns(project);
        this.isShowOnlyCurrentThread = BuildConfigManager.getXShowOnlyCurrentThread(project);
        this.isAutobreak = BuildConfigManager.getXBreakLastExecutedStatement(project);
        this.createLogStatementWriter(project);
        this.collectBreakpoints();
    }

    public boolean isStepIntoAssignEnable() {
        return this.isStepIntoAssignEnable;
    }

    public boolean isAutobreakEnable() {
        return this.isAutobreak;
    }

    private void createLogStatementWriter(IProject project) {
        try {
            if (!this.isLogStatementEnable) {
                return;
            }
            this.logStatementWritter = new BufferedWriter(new FileWriter(project.getLocation().append("statements.log").toFile()));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setTerminateListener(IXTerminateListener xTerminateListener) {
        this.xTerminateListener = xTerminateListener;
    }

    public IXThreadImpl createXThreadImpl(boolean disableStepIntoNewThread) {
        return new IntrpDebugThread((IntrpDebugTarget)this, this.intrpEvaluator, this.isStepIntoInitEnable, !disableStepIntoNewThread && this.isStepIntoNewThreads);
    }

    public IProject getProject() {
        return this.project;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getModelIdentifier() {
        return "ro.amiq.dvt.debug";
    }

    public boolean canTerminate() {
        if (this.isTerminated) {
            return false;
        }
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.isTerminated || this.xThreadScheduler.isTerminated();
    }

    public void terminate() {
        if (this.isTerminated) {
            return;
        }
        try {
            try {
                this.isTerminated = true;
                this.removeBreakpointManager();
                this.breakpointsMap.clear();
                if (this.xTerminateListener != null) {
                    this.xTerminateListener.terminate();
                }
                this.fireTerminateEvent();
                this.xTerminateListener = null;
                this.currentStackThread = null;
                this.project = null;
                this.intrpEvaluator = null;
                if (this.logStatementWritter != null) {
                    this.logStatementWritter.close();
                }
            }
            catch (BuildCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.isDebugging = false;
                MemoryMonitor.getInstance().stopMemoryMonitor();
                VHBreadcrumbViewer.setReadOnly(false);
                this.handleTerminate();
                XViewsThreadCache.getInstance().clear();
                DVTRunLaunchCache.getInstance().clear();
                DVTRfUtils.clearHotSwapDesignElementsHidsCache();
                ObjectionManager.getInstance().clear(Objection.RUNTIME_ELAB_DONE);
                XUtils.setVerbosityChanged(false);
            }
        }
        finally {
            this.isDebugging = false;
            MemoryMonitor.getInstance().stopMemoryMonitor();
            VHBreadcrumbViewer.setReadOnly(false);
            this.handleTerminate();
            XViewsThreadCache.getInstance().clear();
            DVTRunLaunchCache.getInstance().clear();
            DVTRfUtils.clearHotSwapDesignElementsHidsCache();
            ObjectionManager.getInstance().clear(Objection.RUNTIME_ELAB_DONE);
            XUtils.setVerbosityChanged(false);
        }
    }

    public boolean canResume() {
        if (this.isTerminated) {
            return false;
        }
        IntrpDebugThread activeThread = (IntrpDebugThread)this.xThreadScheduler.getActiveThreadImpl();
        return activeThread != null && activeThread.canResume();
    }

    public boolean canSuspend() {
        if (this.isTerminated) {
            return false;
        }
        IntrpDebugThread activeThread = (IntrpDebugThread)this.xThreadScheduler.getActiveThreadImpl();
        return activeThread != null && activeThread.canSuspend();
    }

    public boolean isSuspended() {
        return !this.isTerminated() && this.isSuspended;
    }

    public void resume() {
        IntrpDebugThread activeThread = (IntrpDebugThread)this.xThreadScheduler.getActiveThreadImpl();
        if (activeThread != null) {
            activeThread.resume();
        }
    }

    public void suspend() {
        IntrpDebugThread activeThread = (IntrpDebugThread)this.xThreadScheduler.getActiveThreadImpl();
        if (activeThread != null) {
            activeThread.suspend();
        }
    }

    public IntrpDebugThread getActiveThread() {
        return (IntrpDebugThread)this.xThreadScheduler.getActiveThreadImpl();
    }

    public void setLastExecutedStatement(LastExecutedStatementInfo lastExecutedStatement) {
        this.lastExecutedStatement = lastExecutedStatement;
    }

    public LastExecutedStatementInfo getLastExecutedStatement() {
        return this.lastExecutedStatement;
    }

    public void suspendExecution(int detail) {
        this.xThreadScheduler.suspendExecution();
        this.isSuspended = true;
        this.fireSuspendEvent(detail);
    }

    public void resumeExecution(int detail) {
        this.xThreadScheduler.resumeExecution();
        if (this.intrpEvaluator != null) {
            this.intrpEvaluator.callbackResetChangedValues();
        }
        this.isSuspended = false;
        this.fireResumeEvent(detail);
    }

    public void fireSuspendEventOnActiveThread(int detail) {
        IXThreadImpl activeThreadImpl = this.xThreadScheduler.getActiveThreadImpl();
        if (activeThreadImpl != null) {
            ((IntrpDebugThread)activeThreadImpl).fireSuspendEvent(detail);
        }
        this.fireSuspendEvent(detail);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.collectBreakpoints();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof Watchpoint) {
            this.watchpointsMap.remove(((Watchpoint)breakpoint).getFieldIdentifier());
        }
        this.collectBreakpoints();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.collectBreakpoints();
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() {
        if (this.isTerminated() || !this.isSuspended()) {
            return new IThread[0];
        }
        Collection<XThread> xThreads = this.xThreadScheduler.getThreads();
        if (xThreads == null || xThreads.isEmpty()) {
            return new IThread[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedHashMap<XThreadDefinition.ThreadKind, IntrpDebugThreadKindGroup> threadsByKind = new LinkedHashMap<XThreadDefinition.ThreadKind, IntrpDebugThreadKindGroup>();
        for (XThread xThread : xThreads) {
            IThread thread;
            XThreadDefinition xThreadDefinition = xThread.getXThreadDefinition();
            if (xThreadDefinition.getFirstStatementParserPath() == HidEvalCenter.EC_NBA_ASSIGN_PARSER_PATH || !(thread = (IThread)xThreadDefinition.getXThreadImpl()).isSuspended() && this.isShowOnlyCurrentThread) continue;
            if (thread.isSuspended()) {
                result.add(thread);
                continue;
            }
            XThreadDefinition.ThreadKind threadKind = xThreadDefinition.getThreadKind();
            IntrpDebugThreadKindGroup threadGroup = (IntrpDebugThreadKindGroup)threadsByKind.get((Object)threadKind);
            if (threadGroup == null) {
                threadGroup = new IntrpDebugThreadKindGroup(this, threadKind, xThread.getId());
                threadsByKind.put(threadKind, threadGroup);
            }
            threadGroup.addThread(thread);
        }
        result.addAll(threadsByKind.values());
        return result.toArray(new IThread[result.size()]);
    }

    public List<XThread> getThreadsDuringTerminate() {
        if (this.xThreadScheduler == null) {
            return Collections.emptyList();
        }
        Collection<XThread> threads = this.xThreadScheduler.getThreads();
        if (threads == null || threads.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<XThread>(threads);
    }

    public boolean hasThreads() {
        return !this.isTerminated();
    }

    public String getName() {
        return this.name;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DEBUG_TARGET);
    }

    @Override
    public String getText() {
        return this.getName();
    }

    public static boolean isSameScope(IRfNamedElement rfElement1, IRfNamedElement rfElement2) {
        IRfScopeElement enclosing2;
        if (rfElement1 == rfElement2) {
            return true;
        }
        if (rfElement1 == null || rfElement2 == null) {
            return false;
        }
        String element1Name = rfElement1.getName();
        if (element1Name == null) {
            return false;
        }
        String element2Name = rfElement2.getName();
        if (element2Name == null) {
            return false;
        }
        if (!element1Name.equals(element2Name)) {
            return false;
        }
        IRfScopeElement enclosing1 = rfElement1.getEnclosingScope();
        if (enclosing1 instanceof IRfClassElement) {
            enclosing1 = ((IRfClassElement)enclosing1).getGenericClass();
        }
        if ((enclosing2 = rfElement2.getEnclosingScope()) instanceof IRfClassElement) {
            enclosing2 = ((IRfClassElement)enclosing2).getGenericClass();
        }
        return enclosing1 == enclosing2;
    }

    public IWatchExpressionResult getWatchExpressionResult(String expression, IRfNamedElementAndScope namedElementAndScope, IRfScopeElement cursorScope, IStackFrame[] stackFrames, Map<String, IRfNamedElementAndScope> indexElementMap) {
        return this.intrpEvaluator.getWatchExpressionResult(expression, namedElementAndScope, cursorScope, stackFrames, indexElementMap);
    }

    public boolean isLogStatementEnable() {
        return this.isLogStatementEnable;
    }

    public void logStatement(String statement) {
        try {
            ++this.statementCounter;
            this.logStatementWritter.write(DVTStringUtil.appendString("[", this.statementCounter, "] ", statement, "\n"));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IntrpDebugThread.State getGlobalInitLastRequestedState() {
        return this.globalInitLastRequestedState;
    }

    public void setGlobalInitLastRequestedState(IntrpDebugThread.State globalInitLastRequestedState) {
        this.globalInitLastRequestedState = globalInitLastRequestedState;
    }

    public BigDecimal getCurrSimTime() {
        return this.xThreadScheduler.getCurrSimTime();
    }

    protected final void collectBreakpoints() {
        try {
            ArrayList<IBreakpoint> unsupportedBreakpoints = new ArrayList<IBreakpoint>();
            IBreakpoint[] breakpoints = this.getBreakpoints();
            if (breakpoints == null) {
                return;
            }
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof Watchpoint) {
                    this.addWatchpointInfo((Watchpoint)breakpoint);
                } else if (breakpoint instanceof LineBreakpoint) {
                    int line = this.getBreakpointLine((LineBreakpoint)breakpoint);
                    IPath resourcePath = this.getBreakpointPath((LineBreakpoint)breakpoint);
                    if (resourcePath != null) {
                        String pathString = resourcePath.toOSString();
                        IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(resourcePath);
                        if (fileInfo.getAttribute(32)) {
                            pathString = fileInfo.getStringAttribute(64);
                        }
                        this.addBreakpointInfo(breakpoint, line, pathString);
                    }
                } else {
                    unsupportedBreakpoints.add(breakpoint);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addWatchpointInfo(Watchpoint watchpoint) {
        this.watchpointsMap.put(watchpoint.getFieldIdentifier(), watchpoint);
    }

    public boolean hasWatchpoints() {
        return !this.watchpointsMap.isEmpty();
    }

    public Watchpoint getWatchpoint(String fieldIdentifier) {
        return this.watchpointsMap.get(fieldIdentifier);
    }

    public void addWatchpoint(String fieldIdentifier, Watchpoint watchpoint) {
        this.watchpointsMap.put(fieldIdentifier, watchpoint);
    }

    protected final LineBreakpoint getLineBreakpoint(int lineNumber, ParserPath parserPath) {
        IBreakpoint[] breakpoints;
        String pathString;
        block11: {
            if (parserPath == null || lineNumber < 0) {
                return null;
            }
            pathString = parserPath.path;
            BitSet lines = this.breakpointsMap.get(pathString);
            if (lines == NO_LINES) {
                return null;
            }
            if (lines == null) {
                IPath resourcePath = Path.fromOSString((String)pathString);
                IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(resourcePath);
                if (fileInfo.getAttribute(32)) {
                    pathString = fileInfo.getStringAttribute(64);
                    lines = this.breakpointsMap.get(pathString);
                }
                if (lines == null) {
                    this.breakpointsMap.put(pathString, NO_LINES);
                    return null;
                }
            }
            if (!lines.member(lineNumber)) {
                return null;
            }
            breakpoints = this.getBreakpoints();
            if (breakpoints != null) break block11;
            return null;
        }
        try {
            IBreakpoint[] iBreakpointArray = breakpoints;
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo fileInfo;
                IResource resource;
                String candidatePathString;
                LineBreakpoint lineBreakpoint;
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof LineBreakpoint && breakpoint.isEnabled() && (lineBreakpoint = (LineBreakpoint)breakpoint).getLineNumber() == lineNumber && (pathString.equals(candidatePathString = (resource = lineBreakpoint.getMarker().getResource()).getLocation().toOSString()) || (fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(resource.getLocation())).getAttribute(32) && pathString.equals(candidatePathString = fileInfo.getStringAttribute(64)))) {
                    return lineBreakpoint;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private void addBreakpointInfo(IBreakpoint breakpoint, int line, String pathString) throws CoreException {
        BitSet lines = this.breakpointsMap.get(pathString);
        if (lines == null || lines == NO_LINES) {
            lines = new BitSet();
            this.breakpointsMap.put(pathString, lines);
        }
        if (breakpoint.isEnabled()) {
            lines.add(line);
        } else if (lines.member(line)) {
            lines.remove(line);
        }
    }

    public abstract void openHotSwapFailedDialog();

    @Override
    public void changedElements(Collection<? extends IRfNamedElement> added, Collection<? extends IRfNamedElement> removed, Collection<? extends IRfNamedElement> modified, Collection<ParserPath> changedFiles) {
        if (this.isTerminated()) {
            return;
        }
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.openHotSwapFailedDialog();
        }
        HashMap<IRfNamedElement, Boolean> allChanged = new HashMap<IRfNamedElement, Boolean>();
        for (IRfNamedElement iRfNamedElement : added) {
            allChanged.put(iRfNamedElement, false);
        }
        for (IRfNamedElement iRfNamedElement : modified) {
            allChanged.put(iRfNamedElement, false);
        }
        this.setLastExecutedStatement(null);
        if (allChanged.isEmpty()) {
            this.getEditorModifiedElements(allChanged);
        }
        if (allChanged.isEmpty()) {
            return;
        }
        HashMap<IRfNamedElement, Boolean> hashMap = new HashMap<IRfNamedElement, Boolean>();
        for (Map.Entry changedElement : allChanged.entrySet()) {
            IRfNamedElement scope = (IRfNamedElement)changedElement.getKey();
            while (!(scope instanceof IRfMethodElement || scope instanceof IRfActionBlockElement && (((IRfActionBlockElement)scope).isInitial() || ((IRfActionBlockElement)scope).isFinal() || ((IRfActionBlockElement)scope).isAlways()) || scope instanceof IRfActionBlockElement && (((IRfActionBlockElement)scope).isIf() || ((IRfActionBlockElement)scope).isElsIf()))) {
                if (scope instanceof IRfActionBlockElement || scope instanceof IRfBlockElement) {
                    scope = (IRfNamedElement)scope.getEnclosingScope();
                    break;
                }
                if ((scope = (IRfNamedElement)scope.getEnclosingScope()) != null) continue;
            }
            if (scope == null) continue;
            hashMap.put(scope, (Boolean)changedElement.getValue());
        }
        if (hashMap.isEmpty()) {
            return;
        }
        ArrayList<XThread> threads = new ArrayList<XThread>(this.xThreadScheduler.getThreads());
        for (XThread activeThread : threads) {
            IStackFrame[] stackFrames = activeThread.getStackFrames();
            if (stackFrames == null || stackFrames.length == 0) {
                return;
            }
            activeThread.computeHotSwapElement(hashMap, changedFiles);
        }
    }

    protected void getAllChangesForEditor(Map<IRfNamedElement, Boolean> allChanged, DVTEditor dvtEditor) {
        List<DocumentEvent> currentEditEvents = dvtEditor.getCurrentEditEvents();
        if (currentEditEvents == null) {
            return;
        }
        currentEditEvents.forEach(event -> {
            IRfNamedElement scope;
            IRfNamedElementAndScope element = dvtEditor.getCursorElementNonUi(event.getOffset());
            if (element != null && element.getScope() instanceof IRfDefElement && (scope = ((IRfDefElement)((Object)element.getScope())).getNamedElement()) != null) {
                allChanged.put(scope, true);
            }
        });
    }

    public void addIntrpDebugListeners(IIntrpDebugListener listener) {
        this.fIntrpDebugListeners.add((Object)listener);
    }

    public void removeIntrpDebugListeners(IIntrpDebugListener listener) {
        this.fIntrpDebugListeners.remove((Object)listener);
    }

    public void notifyStopInBreakpoint() {
        this.isDebugging = true;
        Object[] objectArray = this.fIntrpDebugListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IIntrpDebugListener)listener).notifyStopInBreakpoint();
            ++n2;
        }
    }

    public boolean hasBreakpoints() {
        return this.hasBreakpoints;
    }

    public void setHasBreakpoints(boolean hasBreakpoints) {
        this.hasBreakpoints = hasBreakpoints;
    }

    protected abstract void getEditorModifiedElements(Map<IRfNamedElement, Boolean> var1);

    protected abstract IBreakpoint[] getBreakpoints();

    protected abstract void removeBreakpointManager();

    protected abstract void handleTerminate();

    protected abstract int getBreakpointLine(LineBreakpoint var1);

    protected abstract IPath getBreakpointPath(LineBreakpoint var1);

    public boolean isDebugging() {
        return this.isDebugging;
    }

    public void setHasActiveTriggerPoints(boolean hasActiveTriggerPoints) {
    }

    public void disableAllTriggerPoints() {
    }

    public boolean hasActiveTriggerPoints() {
        return false;
    }
}

