/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.ConditionalBreakpointHandler;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.XConditionalEvalScope;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XGlobalCache;

public class IntrpDebugThread
extends IntrpDebugElement
implements IThread,
IXThreadImpl,
IIntrpLabelProvider {
    private IntrpDebugTarget debugTarget;
    private IIntrpEvaluator intrpEvaluator;
    private XThread xThread;
    private IBreakpoint breakpoint;
    private String watchpointField;
    private String watchpointSuspendType;
    private String watchpointEnclosingScope;
    private int duringInitVars;
    private StepOverDetails stepOverDetails;
    private IHidObject lastExecuteStatement;
    private IHidObject prevLastExecuteStatement;
    private boolean isHotSwapPending;
    private State requestedState;
    private State state;
    private boolean isStepIntoInitVars;
    private boolean isStepIntoNewThreads;
    private boolean isReturnFromMainFunction;
    private boolean isEvaluatingDebugExpression;
    private ArrayDeque<MacroCallInfo> macroCallStackScope;
    private YieldingStates yieldingState;

    public IntrpDebugThread(IntrpDebugTarget debugTarget, IIntrpEvaluator intrpEvaluator, boolean isStepIntoInitVars, boolean isStepIntoNewThreads) {
        super(debugTarget);
        this.debugTarget = debugTarget;
        this.intrpEvaluator = intrpEvaluator;
        this.isStepIntoInitVars = isStepIntoInitVars;
        this.isStepIntoNewThreads = isStepIntoNewThreads;
        this.macroCallStackScope = new ArrayDeque();
        this.yieldingState = null;
        if (isStepIntoNewThreads) {
            this.requestedState = State.STEPPING_INTO;
            this.state = State.STEPPING_INTO;
        } else {
            this.requestedState = State.RUNNING;
            this.state = State.RUNNING;
        }
    }

    @Override
    public void setXThread(XThread xThread, boolean isStepInto) {
        this.xThread = xThread;
        this.xThread.setDebugThread(this);
        if (isStepInto) {
            this.requestedState = State.STEPPING_INTO;
            this.state = State.STEPPING_INTO;
        }
    }

    @Override
    public XThread getXThread() {
        return this.xThread;
    }

    public int getId() {
        if (this.xThread != null) {
            return this.xThread.getId();
        }
        return -2147483647;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public void resume() {
        this.resume(State.RUNNING);
    }

    private void resume(State newState) {
        this.requestedState = newState;
        if (this.xThread.isYielding()) {
            this.state = newState;
            this.fireResumeEvent(32);
            this.debugTarget.fireSuspendEventOnActiveThread(32);
        } else {
            int resumeExecutionDetail;
            switch (this.state) {
                case STEPPING_INTO: {
                    resumeExecutionDetail = 1;
                    break;
                }
                case STEPPING_OVER: {
                    resumeExecutionDetail = 2;
                    break;
                }
                case STEPPING_RETURN: {
                    resumeExecutionDetail = 4;
                    break;
                }
                default: {
                    int resumeExecutionDetail2 = 32;
                    return;
                }
            }
            this.resumeExecution(resumeExecutionDetail);
        }
    }

    public void resumeExecution(int detail) {
        boolean isSimulatorMode;
        this.fireResumeEvent(detail);
        this.debugTarget.removeDecorations();
        this.debugTarget.resumeExecution(detail);
        IProject project = this.intrpEvaluator.getRfProject().getProject();
        if (project == null) {
            return;
        }
        IXSim xSim = XGlobalCache.INSTANCE.getXSim(project);
        boolean bl = isSimulatorMode = xSim.simulatorMode() == IXSim.XSimMode.SIMULATOR || xSim.simulatorMode() == IXSim.XSimMode.STANDALONE_FUNCTION;
        if (!isSimulatorMode) {
            IXConfigDBContributor xconfigDBContributor;
            IXVHContributor xvhContributor = XViewsUtils.getXVHContributor();
            if (xvhContributor != null) {
                xvhContributor.resetViewContent();
            }
            if ((xconfigDBContributor = XViewsUtils.getXConfigDBViewContributor()) != null) {
                xconfigDBContributor.deepClean();
            }
            ViewsUtils.notifySimAppsViews(BuildEvents.PRE_INTERPRETER_MODE);
        }
    }

    public void fireResumeEvent(int detail) {
        super.fireResumeEvent(detail);
    }

    public boolean isRunning() {
        if (this.xThread.isTerminated()) {
            return false;
        }
        return this.state == State.RUNNING;
    }

    public boolean isSuspended() {
        if (this.xThread.isTerminated()) {
            return false;
        }
        return this.state == State.SUSPENDED || this.xThread.isYielding() && this.requestedState == State.SUSPENDED;
    }

    public boolean canSuspend() {
        return !this.xThread.isTerminated() && !this.isSuspended();
    }

    public void suspend() {
        this.requestedState = State.SUSPENDED;
        this.fireSuspendEvent(32);
    }

    public void suspendExecution(int detail) {
        this.suspend();
        this.debugTarget.suspendExecution(detail);
    }

    public boolean isStepping() {
        if (this.xThread.isTerminated() || this.xThread.isYielding()) {
            return false;
        }
        return this.state == State.STEPPING_INTO || this.state == State.STEPPING_OVER || this.state == State.STEPPING_RETURN;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public void stepInto() {
        this.resume(State.STEPPING_INTO);
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public void stepOver() {
        this.resume(State.STEPPING_OVER);
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public void stepReturn() {
        this.resume(State.STEPPING_RETURN);
    }

    public boolean canDropToFrame() {
        return this.isSuspended();
    }

    public void dropToFrame(IntrpStackFrame stackFrame) {
        this.xThread.dropToFrame(stackFrame);
    }

    @Override
    public boolean isTerminated() {
        return this.xThread.isTerminated();
    }

    public boolean canTerminate() {
        return !this.xThread.isTerminated();
    }

    public void terminate() {
        this.debugTarget.terminate();
    }

    @Override
    public void localTerminate() {
        this.fireTerminateEvent();
    }

    public boolean hasStackFrames() {
        return this.isSuspended() && this.xThread.hasStackFrames();
    }

    public IStackFrame[] getStackFrames() {
        return this.isSuspended() ? this.xThread.getStackFrames() : new IStackFrame[]{};
    }

    public IStackFrame getTopStackFrame() {
        return this.isSuspended() ? this.xThread.getTopStackFrame() : null;
    }

    private IStackFrame peekStackFrame() {
        return this.xThread.getTopStackFrame();
    }

    public int getPriority() {
        return 0;
    }

    public String getName() {
        try {
            StringBuilder result = new StringBuilder();
            result.append(this.xThread.getXThreadDefinition().getName()).append(" [").append(this.xThread.getId()).append(this.xThread.getSpawnedById() != -1 ? "<" + this.xThread.getSpawnedById() : "").append("]");
            if (this.xThread.isTerminated()) {
                result.append(" (terminated)");
                return result.toString();
            }
            if (this.xThread.isYielding()) {
                result.append(" (yielding)");
                if (this.requestedState == State.SUSPENDED) {
                    result.append(" (next: suspend)");
                } else {
                    switch (this.state) {
                        case STEPPING_INTO: {
                            result.append(" (next: step into)");
                            break;
                        }
                        case STEPPING_OVER: {
                            result.append(" (next: step over)");
                            break;
                        }
                        case STEPPING_RETURN: {
                            result.append(" (next: step return)");
                            break;
                        }
                        case RUNNING: {
                            result.append(" (next: resume)");
                            break;
                        }
                        default: {
                            result.append(" (???)");
                        }
                    }
                }
                return result.toString();
            }
            switch (this.state) {
                case SUSPENDED: {
                    if (this.breakpoint instanceof Watchpoint) {
                        return result.append(" (suspended - ").append(this.watchpointSuspendType).append(" of field '").append(this.watchpointField).append("' from '").append(this.watchpointEnclosingScope).append("')").toString();
                    }
                    if (this.breakpoint instanceof LineBreakpoint) {
                        int line = this.breakpoint.getMarker().getAttribute("lineNumber", -1);
                        String location = this.breakpoint.getMarker().getResource().getName();
                        return result.append(" (suspended at line ").append(line).append(" in file '").append(location).append("')").toString();
                    }
                    return result.append(" (suspended)").toString();
                }
            }
            return result.append(" (running)").toString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "[exception]";
        }
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoint != null) {
            return new IBreakpoint[]{this.breakpoint};
        }
        return new IBreakpoint[0];
    }

    @Override
    public Image getImage() {
        if (this.isSuspended()) {
            return DVTImages.imageCache.getImage(DVTImages.THREAD_SUSPENDED);
        }
        return DVTImages.imageCache.getImage(DVTImages.THREAD_RUNNING);
    }

    @Override
    public String getText() {
        return this.getName();
    }

    public boolean enableStepIntoInitVars(boolean onlyStaticMembers) {
        return this.isStepIntoInitVars;
    }

    public boolean enableStepIntoNewThreads() {
        return this.isStepIntoNewThreads;
    }

    public void callbackStartInitVars(boolean onlyStaticMembers) {
        if (!this.enableStepIntoInitVars(onlyStaticMembers)) {
            ++this.duringInitVars;
        }
    }

    public void callbackEndInitVars(boolean onlyStaticMembers) {
        if (!this.enableStepIntoInitVars(onlyStaticMembers)) {
            --this.duringInitVars;
        }
    }

    private boolean skipInitVars() {
        return this.duringInitVars > 0;
    }

    @Override
    public void startBlock(XEvalScope xEvalScope) {
        IntrpStackFrame stackFrame = (IntrpStackFrame)this.peekStackFrame();
        if (stackFrame == null) {
            return;
        }
        stackFrame.stackValues.push(xEvalScope.getEvaluator());
    }

    @Override
    public void endBlock(XEvalScope xEvalScope) {
        IntrpStackFrame stackFrame = (IntrpStackFrame)this.peekStackFrame();
        if (stackFrame == null) {
            return;
        }
        if (!stackFrame.stackValues.isEmpty()) {
            stackFrame.stackValues.pop();
        }
        stackFrame.currStatement = null;
    }

    @Override
    public void startFrame(XEvalScope xEvalScope) {
        XFrameBlockEvalScope xFrameEvalScope = (XFrameBlockEvalScope)xEvalScope;
        ParserPath parserPath = xFrameEvalScope.getParserPath();
        if (parserPath == null) {
            return;
        }
        if (IDVTConstants.PRESERVE_PATH == parserPath) {
            XEvalScope parentXEvalScope = this.xThread.getParentScope(true);
            if (parentXEvalScope instanceof XFrameBlockEvalScope) {
                parserPath = ((XFrameBlockEvalScope)parentXEvalScope).getParserPath();
            } else if (parentXEvalScope instanceof XMethodBlockEvalScope) {
                parserPath = ((XMethodBlockEvalScope)parentXEvalScope).getParserPath();
            }
        }
        if (parserPath == null) {
            return;
        }
        IntrpStackFrame stackFrame = IntrpStackFrame.create(this.debugTarget, this, xFrameEvalScope, parserPath, this.intrpEvaluator, true);
        xEvalScope.setStackFrame(stackFrame);
    }

    @Override
    public void startMethod(XEvalScope xEvalScope) {
        XMethodBlockEvalScope xMethodEvalScope = (XMethodBlockEvalScope)xEvalScope;
        ParserPath parserPath = xMethodEvalScope.getParserPath();
        if (parserPath == null) {
            return;
        }
        IntrpStackFrame stackFrame = IntrpStackFrame.create(this.debugTarget, this, xEvalScope, parserPath, this.intrpEvaluator, false);
        xEvalScope.setStackFrame(stackFrame);
    }

    @Override
    public void preEndMethod(XEvalScope xEvalScope) {
        XEvalScope lastMacroCallScope;
        XMethodBlockEvalScope xMethodEvalScope = (XMethodBlockEvalScope)xEvalScope;
        ParserPath parserPath = xMethodEvalScope.getParserPath();
        if (parserPath == null) {
            return;
        }
        XEvalScope parentXEvalScope = this.xThread.getParentScope(true);
        if (parentXEvalScope == null) {
            return;
        }
        IntrpStackFrame parentStackFrame = (IntrpStackFrame)parentXEvalScope.getStackFrame();
        if (parentStackFrame == null) {
            return;
        }
        IntrpStackFrame methodStackFrame = (IntrpStackFrame)xMethodEvalScope.getStackFrame();
        MacroCallInfo lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope xEvalScope2 = lastMacroCallScope = lastMacroCallScopeInfo == null ? null : lastMacroCallScopeInfo.macroCallScope;
        if (lastMacroCallScopeInfo != null) {
            if (lastMacroCallScope != null && lastMacroCallScope == xEvalScope) {
                this.reExecuteMacroStatementOnEndMethod(parentXEvalScope, parentStackFrame, methodStackFrame, lastMacroCallScopeInfo);
            } else if (lastMacroCallScopeInfo.macroState != MacroSteppingStates.INSIDE_MACRO) {
                this.handleEndMethodAsMacroArgument(lastMacroCallScopeInfo);
            }
        }
    }

    @Override
    public void endMethod(XEvalScope xEvalScope) {
        XMethodBlockEvalScope xMethodEvalScope = (XMethodBlockEvalScope)xEvalScope;
        ParserPath parserPath = xMethodEvalScope.getParserPath();
        if (parserPath == null) {
            return;
        }
        XEvalScope parentXEvalScope = this.xThread.getParentScope(false);
        if (parentXEvalScope == null) {
            return;
        }
        IntrpStackFrame parentStackFrame = (IntrpStackFrame)parentXEvalScope.getStackFrame();
        if (parentStackFrame == null) {
            return;
        }
        IntrpStackFrame methodStackFrame = (IntrpStackFrame)xMethodEvalScope.getStackFrame();
        if (this.xThread.isYielding()) {
            return;
        }
        if (this.state == State.STEPPING_RETURN && this.stepOverDetails != null && parentStackFrame.currStatement == this.stepOverDetails.stepOverStatement && parentXEvalScope == this.stepOverDetails.stepOverScope) {
            this.stepOverDetails = null;
            this.yieldingState = null;
            if (!this.hasVirtualOffset(parentStackFrame.currStatement)) {
                this.executeStatement(parentStackFrame.currStatement, true, false, true);
            }
            if (this.state != State.STEPPING_RETURN && !this.isMethodCallAsArg(xEvalScope, parentStackFrame.currStatement, true) && !this.isMethodInConditionComplexOperator(xEvalScope)) {
                this.stepOverDetails = null;
            }
            return;
        }
        if ((this.state == State.STEPPING_OVER || this.state == State.STEPPING_INTO) && methodStackFrame.isSkippedStatement) {
            if (this.yieldingState == YieldingStates.PREVIOUSLY_YIELDED) {
                this.yieldingState = null;
                this.stepOverDetails = null;
            }
            if (!this.hasVirtualOffset(parentStackFrame.currStatement)) {
                this.executeStatement(parentStackFrame.currStatement, true, false, true);
            }
            if (this.state != State.STEPPING_RETURN && !this.isMethodCallAsArg(xEvalScope, parentStackFrame.currStatement, true) && !this.isMethodInConditionComplexOperator(xEvalScope)) {
                this.stepOverDetails = null;
            }
            return;
        }
        if (this.yieldingState == YieldingStates.YIELDED && this.stepOverDetails != null && parentStackFrame.currStatement == this.stepOverDetails.stepOverStatement && parentXEvalScope == this.stepOverDetails.stepOverScope) {
            this.yieldingState = null;
            this.stepOverDetails = null;
        }
    }

    private void reExecuteMacroStatementOnEndMethod(XEvalScope parentXEvalScope, IntrpStackFrame parentStackFrame, IntrpStackFrame methodStackFrame, MacroCallInfo lastMacroCallScopeInfo) {
        MacroCallInfo newLastMacroCallScopeInfo;
        if (lastMacroCallScopeInfo.reExecuteFirstStatement && this.state != State.RUNNING) {
            IHidObject parentStackFrameCurrentStatement = parentStackFrame.currStatement;
            int parentStackFrameCurrentLine = parentStackFrame.currLine;
            int parentStackFramePrevLine = parentStackFrame.prevLine;
            IBreakpoint currentBreakpoint = this.breakpoint;
            if (this.state == State.STEPPING_RETURN && this.stepOverDetails != null && this.stepOverDetails.stepOverScope == parentXEvalScope && this.stepOverDetails.stepOverStatement == parentStackFrame.currStatement) {
                this.stepOverDetails = null;
            }
            IHidObject currentLastExecuteStatement = this.lastExecuteStatement;
            this.executeStatement(lastMacroCallScopeInfo.firstStatement, true, true, true);
            parentStackFrame.currStatement = parentStackFrameCurrentStatement;
            parentStackFrame.currLine = parentStackFrameCurrentLine;
            parentStackFrame.prevLine = parentStackFramePrevLine;
            this.breakpoint = currentBreakpoint;
            this.lastExecuteStatement = currentLastExecuteStatement;
            if (this.state == State.STEPPING_OVER || this.state == State.STEPPING_INTO) {
                methodStackFrame.isSkippedStatement = true;
                this.stepOverDetails = null;
            }
            if (this.state == State.STEPPING_RETURN) {
                this.stepOverDetails = new StepOverDetails(parentStackFrame.currStatement, parentXEvalScope);
            }
        }
        this.resetDebuggingMacroInConditionFlag(lastMacroCallScopeInfo);
        this.macroCallStackScope.pop();
        MacroCallInfo macroCallInfo = newLastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        if (lastMacroCallScopeInfo.macroState == MacroSteppingStates.HIT_BP_IN_MACRO_CALL && newLastMacroCallScopeInfo != null) {
            newLastMacroCallScopeInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
            newLastMacroCallScopeInfo.reExecuteFirstStatement = true;
        }
    }

    private void handleEndMethodAsMacroArgument(MacroCallInfo lastMacroCallInfo) {
        XConditionalEvalScope xConditionalEvalScope = lastMacroCallInfo.xConditionalEvalScope;
        if (xConditionalEvalScope == null) {
            return;
        }
        if (!xConditionalEvalScope.isDebuggingMacroInCondition()) {
            return;
        }
        XEvalScope secondEnclosingEvalScope = this.xThread.getEnclosingScope(true);
        if (xConditionalEvalScope == secondEnclosingEvalScope) {
            lastMacroCallInfo.macroState = MacroSteppingStates.INSIDE_MACRO;
        }
    }

    private boolean isMethodInConditionComplexOperator(XEvalScope xEvalScope) {
        if (this.stepOverDetails == null) {
            return false;
        }
        IHidEvaluator evaluator = ((XMethodBlockEvalScope)xEvalScope).getEvaluator();
        if (evaluator == null) {
            return false;
        }
        IRfNamedElement evalScopeMethodNamedElement = evaluator.getNamedElement();
        if (evalScopeMethodNamedElement == null) {
            return false;
        }
        IHidObject stepOverStatement = this.stepOverDetails.stepOverStatement;
        if (!(stepOverStatement instanceof IHidOperator)) {
            return false;
        }
        XEvalScope firstEnclosingScope = this.xThread.getFirstEvalScope();
        if (!(firstEnclosingScope instanceof XConditionalEvalScope)) {
            return false;
        }
        XConditionalEvalScope firstEncCondEvalScope = (XConditionalEvalScope)firstEnclosingScope;
        IHidObject condition = firstEncCondEvalScope.getCondition();
        if (condition == null || !condition.equals(stepOverStatement)) {
            return false;
        }
        EnumSet<HidFlatteningOption> flatteningOptions = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS);
        Set<IHid> rhHids = ((IHidOperator)stepOverStatement).getRHHids(flatteningOptions);
        if (this.isMethodPartOfComplexOperator(evalScopeMethodNamedElement, rhHids)) {
            return true;
        }
        Set<IHid> lhHids = ((IHidOperator)stepOverStatement).getLHHids(flatteningOptions);
        return this.isMethodPartOfComplexOperator(evalScopeMethodNamedElement, lhHids);
    }

    private boolean isMethodPartOfComplexOperator(IRfNamedElement evalScopeMethodNamedElement, Set<IHid> complexOperatorHids) {
        if (complexOperatorHids == null || complexOperatorHids.isEmpty()) {
            return false;
        }
        for (IHid hid : complexOperatorHids) {
            IRfNamedElement hidNamedElement = hid.getElement();
            if (hidNamedElement == null || hidNamedElement != evalScopeMethodNamedElement) continue;
            return true;
        }
        return false;
    }

    private boolean isRecursiveMethodCall(XEvalScope xEvalScope) {
        if (!(xEvalScope instanceof XMethodBlockEvalScope)) {
            return false;
        }
        IHidEvaluator xMethodEvaluator = ((XMethodBlockEvalScope)xEvalScope).getEvaluator();
        if (xMethodEvaluator == null) {
            return false;
        }
        IRfNamedElement methodNamedElement = xMethodEvaluator.getNamedElement();
        if (methodNamedElement == null) {
            return false;
        }
        XSeqBlockEvalScope enclosingXEvalScope = this.xThread.getEnclosingSeqEvalScope();
        if (!(enclosingXEvalScope instanceof XMethodBlockEvalScope)) {
            return false;
        }
        IHidEvaluator enclosingXMethodEvaluator = ((XMethodBlockEvalScope)enclosingXEvalScope).getEvaluator();
        if (enclosingXMethodEvaluator == null) {
            return false;
        }
        IRfNamedElement enclosingMethodNamedElement = enclosingXMethodEvaluator.getNamedElement();
        return methodNamedElement.equals(enclosingMethodNamedElement);
    }

    private boolean isMethodCallAsArg(XEvalScope xEvalScope, IHidObject statement, boolean isCheckIfContainsArguments) {
        if (!(xEvalScope instanceof XMethodBlockEvalScope)) {
            return false;
        }
        if (this.isRecursiveMethodCall(xEvalScope)) {
            return false;
        }
        IHidObject currStatement = statement;
        IHidEvaluator xMethodEvaluator = ((XMethodBlockEvalScope)xEvalScope).getEvaluator();
        if (xMethodEvaluator == null) {
            return false;
        }
        IRfNamedElement methodNamedElement = xMethodEvaluator.getNamedElement();
        if (methodNamedElement == null) {
            return false;
        }
        if (currStatement instanceof IHidOperator && ((IHidOperator)currStatement).isVLOGConcatenation(false)) {
            return true;
        }
        if (currStatement instanceof HidEvalCenter.MethodCallPlaceholder) {
            currStatement = ((HidEvalCenter.MethodCallPlaceholder)currStatement).getHidOrAccess();
        }
        if (currStatement instanceof IHidOperator) {
            EnumSet<HidFlatteningOption> flattenOptions = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS);
            Set<IHid> set = ((IHidOperator)currStatement).getRHHids(flattenOptions);
            if (this.isMethodInsideComplexOperator(isCheckIfContainsArguments, methodNamedElement, set)) {
                return true;
            }
            Set<IHid> lhHids = ((IHidOperator)currStatement).getLHHids(flattenOptions);
            if (lhHids == null || lhHids.isEmpty()) {
                return false;
            }
            if (this.isMethodInsideComplexOperator(isCheckIfContainsArguments, methodNamedElement, lhHids)) {
                return true;
            }
        } else if (currStatement instanceof IHidAccessArgs) {
            List<? extends IHidObject> argumentValues = ((IHidAccessArgs)((Object)currStatement)).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return false;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (!this.isMethodCallAsArg(xEvalScope, iHidObject, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMethodInsideComplexOperator(boolean isCheckIfContainsArguments, IRfNamedElement methodNamedElement, Set<IHid> complexOperatorHids) {
        int methodsCount = 0;
        boolean sameNamedElement = false;
        if (complexOperatorHids == null || complexOperatorHids.isEmpty()) {
            return false;
        }
        for (IHid hid : complexOperatorHids) {
            IRfNamedElement hidNamedElement = hid.getElement();
            if (hidNamedElement == null) continue;
            if (hidNamedElement instanceof IRfMethodElement) {
                ++methodsCount;
            }
            if (hidNamedElement != methodNamedElement || sameNamedElement) continue;
            sameNamedElement = true;
        }
        if (isCheckIfContainsArguments && methodsCount < 2) {
            return false;
        }
        return sameNamedElement;
    }

    @Override
    public void preEndFrame(XEvalScope xEvalScope) {
        if (this.macroCallStackScope.isEmpty()) {
            return;
        }
        MacroCallInfo lastMacroCallInfo = this.macroCallStackScope.peek();
        if (xEvalScope.equals(lastMacroCallInfo.macroCallScope)) {
            this.macroCallStackScope.pop();
        }
    }

    public void callbackStartHotSwap() {
        this.isHotSwapPending = false;
        this.requestedState = State.STEPPING_INTO;
        this.state = State.STEPPING_INTO;
        this.stepOverDetails = null;
    }

    public void callbackStartStatement(IHidObject statement, IHidEvaluator evaluator) {
        HidEvalCenter.IInitialValueDeclarationStatement initialValueDeclarationStatement;
        IRfFieldElement initialDeclField;
        IRfScopeElement initialDeclFieldEnclosingScope;
        if (this.state == State.SUSPENDED) {
            return;
        }
        if (statement instanceof IHidOperator && IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id == ((IHidOperator)statement).getOperatorType()) {
            return;
        }
        if (statement instanceof IHidOperator && IHidOperatorConstants.OperatorType.DECLARATION_STATEMENT.id == ((IHidOperator)statement).getOperatorType() && IHidOperatorConstants.OperatorKind.UNARY_OPERATOR == ((IHidOperator)statement).getOperatorKind()) {
            return;
        }
        if (statement instanceof HidEvalCenter.IInitialValueDeclarationStatement && (initialDeclFieldEnclosingScope = (initialDeclField = (initialValueDeclarationStatement = (HidEvalCenter.IInitialValueDeclarationStatement)statement).getField()).getEnclosingScope()) instanceof IRfMethodElement && initialDeclField.isArgument()) {
            return;
        }
        if (this.debugTarget.isLogStatementEnable()) {
            ParserPath parserPath = null;
            IntrpStackFrame stackFrame = (IntrpStackFrame)this.peekStackFrame();
            if (stackFrame != null) {
                parserPath = stackFrame.getParserPath();
            }
            int lineNumber = -1;
            if (statement instanceof IHidOperator) {
                HidOperatorOccurrence occurrence = ((IHidOperator)statement).getOccurrence();
                lineNumber = occurrence == null ? -1 : occurrence.getLine();
            } else if (statement instanceof IHid) {
                HidOccurrence occurrence = ((IHid)statement).getOccurrence();
                lineNumber = occurrence == null ? -1 : occurrence.getLine();
            }
            this.debugTarget.logStatement(DVTStringUtil.appendString(statement, " ", lineNumber, "@", parserPath));
        }
        this.executeStatement(statement, false, false, false);
    }

    private boolean hasVirtualOffset(IHidObject statement) {
        if (!(statement instanceof IHidOperator) || this.lastExecuteStatement != null && !(this.lastExecuteStatement instanceof IHidOperator)) {
            return false;
        }
        int virtualOffset = ((IHidOperator)statement).getVirtualOffset();
        return virtualOffset >= 0;
    }

    public void callbackEndStatement(IHidObject statement) {
        if (this.state == State.SUSPENDED) {
            return;
        }
        IntrpStackFrame stackFrame = (IntrpStackFrame)this.peekStackFrame();
        if (stackFrame == null) {
            return;
        }
        if (this.xThread.isYielding()) {
            if (this.stepOverDetails == null || this.stepOverDetails != null && this.stepOverDetails.stepOverScope == this.xThread.getParentScope(false)) {
                this.yieldingState = YieldingStates.PREVIOUSLY_YIELDED;
                return;
            }
            this.yieldingState = YieldingStates.YIELDED;
        }
        if (this.state == State.STEPPING_OVER && this.stepOverDetails != null && stackFrame.currStatement == this.stepOverDetails.stepOverStatement && this.stepOverDetails.stepOverScope == this.xThread.getParentScope(false)) {
            this.stepOverDetails = null;
        }
        stackFrame.currStatement = statement;
    }

    private boolean isGlobalInit() {
        return this.xThread.isGlobalInit();
    }

    private IHidObject getStepReturnStatement() {
        XEvalScope parentXEvalScope = this.xThread.getParentScope(true);
        if (parentXEvalScope == null) {
            return null;
        }
        IntrpStackFrame stackFrame = (IntrpStackFrame)parentXEvalScope.getStackFrame();
        if (stackFrame == null) {
            return null;
        }
        return stackFrame.currStatement;
    }

    public IHidObject getLastExecuteStatement() {
        return this.lastExecuteStatement;
    }

    private void executeStatement(IHidObject statement, boolean isDisableBreakpoint, boolean isReExecuteMacroStatement, boolean isEndMethod) {
        IBreakpointManager breakpointManager;
        if (this.debugTarget.isTerminated()) {
            return;
        }
        if (this.isEvaluatingDebugExpression) {
            return;
        }
        if (statement == null) {
            return;
        }
        if (this.isHotSwapPending) {
            return;
        }
        XEvalScope xParentEvalScope = this.xThread.getParentScope(false);
        if (xParentEvalScope == null) {
            return;
        }
        IntrpStackFrame stackFrame = (IntrpStackFrame)xParentEvalScope.getStackFrame();
        if (stackFrame == null) {
            return;
        }
        this.prevLastExecuteStatement = this.lastExecuteStatement;
        this.lastExecuteStatement = statement;
        stackFrame.currStatement = statement;
        if (!(statement instanceof HidOperator)) {
            return;
        }
        int lineNumber = ((HidOperator)statement).getLine();
        if (lineNumber < 0) {
            return;
        }
        ParserPath includedFileParserPath = null;
        for (IReflectionContributor reflectionContributor : this.debugTarget.getReflectionContributors()) {
            includedFileParserPath = reflectionContributor.getRfHidParserPath(statement);
            if (includedFileParserPath != null) break;
        }
        stackFrame.setParserPath(includedFileParserPath);
        ParserPath parserPath = stackFrame.getParserPath();
        stackFrame.prevLine = stackFrame.currLine;
        stackFrame.currLine = lineNumber;
        IBreakpointManager iBreakpointManager = breakpointManager = DebugPlugin.getDefault() != null ? DebugPlugin.getDefault().getBreakpointManager() : null;
        if (!this.debugTarget.hasBreakpoints() || breakpointManager != null && !breakpointManager.isEnabled()) {
            this.handleStatementsInsideMacros(isReExecuteMacroStatement, statement, stackFrame, isEndMethod);
            return;
        }
        try {
            int resumeExecutionDetail;
            int suspendExecutionDetail = 32;
            if (this.isGlobalInit()) {
                this.debugTarget.initPreviously = true;
            }
            int lastStatementLine = -1;
            int currStatementLine = -1;
            if (this.prevLastExecuteStatement != null) {
                lastStatementLine = this.prevLastExecuteStatement.xGetLine();
                currStatementLine = statement.xGetLine();
            }
            if (this.requestedState == State.SUSPENDED) {
                suspendExecutionDetail = 32;
            } else {
                boolean isGlobalInitDone;
                LastExecutedStatementInfo lastExecStmtInfo = this.debugTarget.getLastExecutedStatement();
                boolean isLastExecStmt = false;
                if (this.debugTarget.isAutobreakEnable() && lastExecStmtInfo != null && !(isLastExecStmt = this.isLastExecutedStatement(lastExecStmtInfo, parserPath, currStatementLine))) {
                    return;
                }
                Method hasActiveTriggerPointsM = null;
                if (breakpointManager != null) {
                    try {
                        hasActiveTriggerPointsM = breakpointManager.getClass().getMethod("hasActiveTriggerPoints", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                this.breakpoint = isDisableBreakpoint ? null : this.getActiveBreakpoint(statement, lineNumber, parserPath, breakpointManager, xParentEvalScope, hasActiveTriggerPointsM);
                boolean bl = isGlobalInitDone = this.debugTarget.initPreviously && !this.isGlobalInit();
                if (isGlobalInitDone) {
                    this.debugTarget.initPreviously = false;
                }
                if (this.breakpoint == null && !isLastExecStmt) {
                    if (isGlobalInitDone) {
                        this.debugTarget.currentStackThread = this.xThread;
                        State globalInitLastRequestedState = this.debugTarget.getGlobalInitLastRequestedState();
                        if (globalInitLastRequestedState != null) {
                            this.state = globalInitLastRequestedState;
                        }
                    }
                    if (this.debugTarget.currentStackThread == null) {
                        this.debugTarget.currentStackThread = this.xThread;
                    }
                    if (this.handleStatementsInsideMacros(isReExecuteMacroStatement, statement, stackFrame, isEndMethod)) {
                        return;
                    }
                    if (this.isReturnFromMainFunction) {
                        return;
                    }
                    if (this.handleYieldedPreviously(statement, xParentEvalScope, stackFrame, lastStatementLine, currStatementLine)) {
                        return;
                    }
                    if (this.yieldingState == YieldingStates.PREVIOUSLY_YIELDED && lastStatementLine != currStatementLine) {
                        this.stepOverDetails = null;
                        this.yieldingState = null;
                    }
                    if (this.debugTarget.currentStackThread != this.xThread) {
                        return;
                    }
                    if (this.stepOverDetails != null && !isGlobalInitDone) {
                        return;
                    }
                } else {
                    boolean shouldSuspend = this.prepareSuspendForBreakpoint(breakpointManager, stackFrame, xParentEvalScope, lastStatementLine, currStatementLine, hasActiveTriggerPointsM, false);
                    if (!shouldSuspend) {
                        return;
                    }
                }
                if (this.breakpoint != null || isLastExecStmt) {
                    suspendExecutionDetail = 16;
                } else {
                    switch (this.state) {
                        case STEPPING_INTO: {
                            suspendExecutionDetail = 1;
                            break;
                        }
                        case STEPPING_OVER: {
                            suspendExecutionDetail = 2;
                            break;
                        }
                        case STEPPING_RETURN: {
                            suspendExecutionDetail = 4;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
            IHidEvaluationGuardian guardian = xParentEvalScope.getGuardian();
            if (guardian != null && guardian.getFactory() != null) {
                guardian.getFactory().flushWriterVCD();
            }
            if ((resumeExecutionDetail = this.handleSuspendStatement(suspendExecutionDetail, xParentEvalScope, stackFrame)) == -1) {
                return;
            }
            this.requestedState = this.state;
            this.resumeExecution(resumeExecutionDetail);
        }
        catch (HidEvalJumpStatementException.HidEvalHotSwapRerunException e) {
            throw e;
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean handleStatementsInsideMacros(boolean isReExecuteMacroStatement, IHidObject statement, IntrpStackFrame stackFrame, boolean isEndMethod) {
        if (isReExecuteMacroStatement) {
            return false;
        }
        this.handleMacroSteppingInComplexCondition(false);
        boolean isFirstMacroStatement = false;
        if (this.hasVirtualOffset(statement)) {
            MacroCallInfo prevMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
            isFirstMacroStatement = this.handleStatementInsideMacros(statement, false, this.prevLastExecuteStatement, stackFrame);
            if (prevMacroCallScopeInfo != null && prevMacroCallScopeInfo.macroState == MacroSteppingStates.INSIDE_MACRO && !isFirstMacroStatement) {
                return true;
            }
        } else {
            MacroCallInfo lastMacroCallScopeInfo;
            this.handlePossibleStatementFromMacroCallStack(statement, stackFrame, isEndMethod);
            MacroCallInfo macroCallInfo = lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
            if (lastMacroCallScopeInfo != null && lastMacroCallScopeInfo.macroState == MacroSteppingStates.INSIDE_MACRO) {
                return true;
            }
        }
        return false;
    }

    private boolean prepareSuspendForBreakpoint(IBreakpointManager breakpointManager, IntrpStackFrame stackFrame, XEvalScope xParentEvalScope, int lastStatementLine, int currStatementLine, Method hasActiveTriggerPointsM, boolean isWatchpoint) {
        MacroCallInfo lastMacroCallScopeInfo;
        this.disableAllTriggerPoints(breakpointManager, hasActiveTriggerPointsM);
        this.handleMacroSteppingInComplexCondition(true);
        if (this.hasVirtualOffset(this.lastExecuteStatement)) {
            boolean isFirstMacroStatement = this.handleStatementInsideMacros(this.lastExecuteStatement, true, this.prevLastExecuteStatement, stackFrame);
            if (!isFirstMacroStatement && !isWatchpoint) {
                return false;
            }
        } else {
            this.handlePossibleStatementFromMacroCallStackWithBp(this.lastExecuteStatement, stackFrame);
        }
        MacroCallInfo macroCallInfo = lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        if (this.hasVirtualOffset(this.lastExecuteStatement) && lastMacroCallScopeInfo != null && this.lastExecuteStatement != lastMacroCallScopeInfo.firstStatement && !isWatchpoint) {
            return false;
        }
        if (this.handleYieldedPreviously(this.lastExecuteStatement, xParentEvalScope, stackFrame, lastStatementLine, currStatementLine)) {
            return false;
        }
        IProject project = this.intrpEvaluator.getRfProject().getProject();
        if (project != null) {
            boolean isSimulatorMode;
            IXSim xSim = XGlobalCache.INSTANCE.getXSim(project);
            boolean bl = isSimulatorMode = xSim.simulatorMode() == IXSim.XSimMode.SIMULATOR || xSim.simulatorMode() == IXSim.XSimMode.STANDALONE_FUNCTION;
            if (!isSimulatorMode) {
                this.debugTarget.notifyStopInBreakpoint();
            }
        }
        this.debugTarget.currentStackThread = this.xThread;
        this.isReturnFromMainFunction = false;
        this.stepOverDetails = null;
        this.yieldingState = null;
        return true;
    }

    private int handleSuspendStatement(int suspendExecutionDetail, XEvalScope xParentEvalScope, IntrpStackFrame stackFrame) {
        this.setState(State.SUSPENDED);
        this.suspendExecution(suspendExecutionDetail);
        this.requestedState = State.SUSPENDED;
        while (this.requestedState == State.SUSPENDED) {
            if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().isClosing()) {
                this.terminate();
                throw new TerminateException();
            }
            try {
                if (this.xThread.isHotSwap() || this.isTerminated()) break;
                Thread.sleep(100L);
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
        if (this.xThread.isHotSwap()) {
            this.isHotSwapPending = true;
        }
        stackFrame.isSkippedStatement = false;
        this.breakpoint = null;
        if (this.debugTarget.isTerminated()) {
            return -1;
        }
        int resumeExecutionDetail = 32;
        switch (this.requestedState) {
            case STEPPING_INTO: {
                resumeExecutionDetail = this.caseSteppingInto(stackFrame);
                break;
            }
            case STEPPING_OVER: {
                resumeExecutionDetail = this.caseSteppingOver(stackFrame.currStatement, xParentEvalScope, stackFrame);
                break;
            }
            case STEPPING_RETURN: {
                resumeExecutionDetail = this.caseSteppingReturn(stackFrame.currStatement, stackFrame);
                break;
            }
            case RUNNING: {
                this.caseRunning();
                break;
            }
        }
        if (this.isGlobalInit()) {
            this.debugTarget.setGlobalInitLastRequestedState(this.requestedState);
        }
        return resumeExecutionDetail;
    }

    private void disableAllTriggerPoints(IBreakpointManager breakpointManager, Method hasActiveTriggerPointsM) {
        if (breakpointManager != null) {
            try {
                if (hasActiveTriggerPointsM != null && ((Boolean)hasActiveTriggerPointsM.invoke((Object)breakpointManager, new Object[0])).booleanValue()) {
                    Method enableTriggerPointsM = breakpointManager.getClass().getMethod("enableTriggerPoints", IBreakpoint[].class, Boolean.TYPE);
                    enableTriggerPointsM.invoke((Object)breakpointManager, null, false);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        } else if (this.debugTarget.hasActiveTriggerPoints()) {
            this.debugTarget.disableAllTriggerPoints();
        }
    }

    private LineBreakpoint getActiveBreakpoint(IHidObject statement, int lineNumber, ParserPath parserPath, IBreakpointManager breakpointManager, XEvalScope xParentEvalScope, Method hasActiveTriggerPointsM) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, CoreException {
        LineBreakpoint currentBreakpoint = this.debugTarget.getLineBreakpoint(lineNumber, parserPath);
        if (currentBreakpoint == null) {
            return null;
        }
        if (!this.shouldBreakpointHit(statement, currentBreakpoint, breakpointManager, hasActiveTriggerPointsM, xParentEvalScope)) {
            return null;
        }
        return currentBreakpoint;
    }

    private boolean shouldBreakpointHit(IHidObject statement, LineBreakpoint bp, IBreakpointManager breakpointManager, Method hasActiveTriggerPointsM, XEvalScope xParentEvalScope) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, CoreException {
        block11: {
            block12: {
                if (bp.isTriggerPoint()) break block11;
                if (hasActiveTriggerPointsM == null || !((Boolean)hasActiveTriggerPointsM.invoke((Object)breakpointManager, new Object[0])).booleanValue()) break block12;
                return false;
            }
            try {
                if (breakpointManager == null && this.debugTarget.hasActiveTriggerPoints()) {
                    return false;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (breakpointManager == null && bp.isTriggerPoint() && !this.debugTarget.hasActiveTriggerPoints()) {
            return false;
        }
        boolean isHitCountNotReached = bp.handleHitCount();
        if (isHitCountNotReached) {
            return false;
        }
        IntrpStackFrame stackFrame = (IntrpStackFrame)xParentEvalScope.getStackFrame();
        IHidEvaluationGuardian guardian = null;
        String traceText = bp.getTrace();
        if (traceText != null && !traceText.isEmpty()) {
            if (!traceText.trim().startsWith("$display")) {
                traceText = BreakpointsUtils.computeExpressionFromLogMessage(traceText);
            }
            if (statement != null && !this.handleStatementInsideMacros(statement, false, this.prevLastExecuteStatement, stackFrame) && this.hasVirtualOffset(statement)) {
                return false;
            }
            IDebugTarget debugTarget = this.getDebugTarget();
            guardian = xParentEvalScope.getGuardian().copy();
            BreakpointsUtils.evaluateExpression(traceText, (IntrpDebugTarget)debugTarget, this, guardian);
        }
        if (!bp.hasCondition()) {
            return guardian == null;
        }
        if (statement != null && !this.handleStatementInsideMacros(statement, false, this.prevLastExecuteStatement, stackFrame) && this.hasVirtualOffset(statement)) {
            return false;
        }
        ConditionalBreakpointHandler handler = new ConditionalBreakpointHandler();
        int newThreadState = handler.computNewThreadStateOnConditionHit(this, bp, xParentEvalScope, guardian != null ? guardian : xParentEvalScope.getGuardian().copy());
        return newThreadState != 2;
    }

    private boolean shouldWatchpointHit(Watchpoint watchpoint, boolean isFieldModification) throws CoreException {
        boolean isAccess = watchpoint.isAccess();
        boolean isModification = watchpoint.isModification();
        if (!isModification && !isAccess) {
            return false;
        }
        if (isModification && isAccess) {
            return true;
        }
        return isModification == isFieldModification || isAccess == !isFieldModification;
    }

    private boolean isLastExecutedStatement(LastExecutedStatementInfo lastExecStmtInfo, ParserPath parserPath, int currLine) {
        if (!lastExecStmtInfo.getParserPath().equals(parserPath.path)) {
            return false;
        }
        if (Integer.valueOf(lastExecStmtInfo.getLine()) != currLine) {
            return false;
        }
        this.debugTarget.setLastExecutedStatement(null);
        return true;
    }

    private void handlePossibleStatementFromMacroCallStack(IHidObject statement, IntrpStackFrame stackFrame, boolean isEndMethod) {
        MacroCallInfo lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope lastMacroCallScope = lastMacroCallScopeInfo == null ? null : lastMacroCallScopeInfo.macroCallScope;
        XEvalScope statementParentScope = this.xThread.getParentScope(false);
        if (lastMacroCallScopeInfo != null && lastMacroCallScope != null && lastMacroCallScope == statementParentScope) {
            MacroCallInfo newLastMacroCallScopeInfo;
            if (lastMacroCallScopeInfo.reExecuteFirstStatement && this.state != State.RUNNING && !isEndMethod) {
                int currentLine = stackFrame.currLine;
                int prevLine = stackFrame.prevLine;
                IBreakpoint currentBreakpoint = this.breakpoint;
                IHidObject currentLastExecuteStatement = this.lastExecuteStatement;
                this.executeStatement(lastMacroCallScopeInfo.firstStatement, true, true, false);
                stackFrame.currLine = currentLine;
                stackFrame.prevLine = prevLine;
                stackFrame.currStatement = statement;
                this.lastExecuteStatement = currentLastExecuteStatement;
                if (this.state != State.STEPPING_RETURN) {
                    this.stepOverDetails = null;
                }
                this.breakpoint = currentBreakpoint;
            }
            this.resetDebuggingMacroInConditionFlag(lastMacroCallScopeInfo);
            this.macroCallStackScope.pop();
            MacroCallInfo macroCallInfo = newLastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
            if (lastMacroCallScopeInfo.macroState == MacroSteppingStates.HIT_BP_IN_MACRO_CALL && newLastMacroCallScopeInfo != null && statementParentScope != newLastMacroCallScopeInfo.macroCallScope) {
                newLastMacroCallScopeInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
                newLastMacroCallScopeInfo.reExecuteFirstStatement = true;
            }
        }
    }

    private void handlePossibleStatementFromMacroCallStackWithBp(IHidObject statement, IntrpStackFrame stackFrame) {
        MacroCallInfo lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope lastMacroCallScope = lastMacroCallScopeInfo == null ? null : lastMacroCallScopeInfo.macroCallScope;
        XEvalScope statementParentScope = this.xThread.getParentScope(false);
        if (lastMacroCallScopeInfo != null) {
            if (lastMacroCallScope != null && lastMacroCallScope == statementParentScope) {
                MacroCallInfo newLastMacroCallScopeInfo;
                if (lastMacroCallScopeInfo.reExecuteFirstStatement && this.state != State.RUNNING) {
                    int currentLine = stackFrame.currLine;
                    int prevLine = stackFrame.prevLine;
                    IBreakpoint currentBreakpoint = this.breakpoint;
                    IHidObject currentLastExecuteStatement = this.lastExecuteStatement;
                    this.executeStatement(lastMacroCallScopeInfo.firstStatement, true, true, false);
                    stackFrame.currLine = currentLine;
                    stackFrame.prevLine = prevLine;
                    stackFrame.currStatement = statement;
                    this.lastExecuteStatement = currentLastExecuteStatement;
                    this.stepOverDetails = null;
                    this.breakpoint = currentBreakpoint;
                }
                this.resetDebuggingMacroInConditionFlag(lastMacroCallScopeInfo);
                this.macroCallStackScope.pop();
                MacroCallInfo macroCallInfo = newLastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
                if (newLastMacroCallScopeInfo != null && statementParentScope != newLastMacroCallScopeInfo.macroCallScope) {
                    newLastMacroCallScopeInfo.reExecuteFirstStatement = true;
                    newLastMacroCallScopeInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
                }
            } else {
                lastMacroCallScopeInfo.reExecuteFirstStatement = true;
                lastMacroCallScopeInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
            }
        }
    }

    private boolean handleStatementInsideMacros(IHidObject statement, boolean bpFound, IHidObject lastExecuteStatementDummy, IntrpStackFrame stackFrame) {
        MacroCallInfo lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope lastMacroCallScope = lastMacroCallScopeInfo == null ? null : lastMacroCallScopeInfo.macroCallScope;
        XEvalScope statementParentScope = this.xThread.getParentScope(false);
        int currStatementLine = stackFrame.currLine;
        int lastStatementLine = stackFrame.prevLine;
        boolean poppedConsecutiveMacro = false;
        if (lastMacroCallScopeInfo != null && lastMacroCallScope != null && lastMacroCallScope == statementParentScope) {
            if (this.hasVirtualOffset(lastExecuteStatementDummy) && currStatementLine == lastStatementLine) {
                return false;
            }
            IHidObject firstStatementInMacro = lastMacroCallScopeInfo.firstStatement;
            int firstStatementLine = firstStatementInMacro.xGetLine();
            if (!this.hasVirtualOffset(lastExecuteStatementDummy) && currStatementLine == firstStatementLine) {
                lastMacroCallScopeInfo.macroState = MacroSteppingStates.INSIDE_MACRO;
                return false;
            }
            if (lastMacroCallScopeInfo.reExecuteFirstStatement && this.state != State.RUNNING) {
                IBreakpoint currentBreakpoint = this.breakpoint;
                IHidObject currentLastExecuteStatement = this.lastExecuteStatement;
                this.executeStatement(lastMacroCallScopeInfo.firstStatement, true, true, false);
                stackFrame.currLine = currStatementLine;
                stackFrame.prevLine = lastStatementLine;
                stackFrame.currStatement = statement;
                this.lastExecuteStatement = currentLastExecuteStatement;
                this.stepOverDetails = null;
                this.breakpoint = currentBreakpoint;
            }
            this.resetDebuggingMacroInConditionFlag(lastMacroCallScopeInfo);
            this.macroCallStackScope.pop();
            poppedConsecutiveMacro = true;
        }
        lastMacroCallScopeInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope xEvalScope = lastMacroCallScope = lastMacroCallScopeInfo == null ? null : lastMacroCallScopeInfo.macroCallScope;
        if (lastMacroCallScopeInfo == null || lastMacroCallScope == statementParentScope && currStatementLine != lastStatementLine || statementParentScope != null && lastMacroCallScope != statementParentScope) {
            MacroCallInfo macroCallInfo = new MacroCallInfo(statement, statementParentScope, false, null);
            this.macroCallStackScope.push(macroCallInfo);
            if (lastMacroCallScopeInfo != null && bpFound) {
                lastMacroCallScopeInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
                lastMacroCallScopeInfo.reExecuteFirstStatement = true;
            }
            return lastMacroCallScopeInfo == null || this.macroCallStackScope.size() == 1 && poppedConsecutiveMacro || lastMacroCallScopeInfo != null && lastMacroCallScopeInfo.macroState == MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
        }
        if (lastMacroCallScopeInfo.macroState == MacroSteppingStates.HIT_BP_IN_MACRO_CALL && lastMacroCallScope == statementParentScope) {
            lastMacroCallScopeInfo.macroState = MacroSteppingStates.INSIDE_MACRO;
        }
        return false;
    }

    private boolean handleYieldedPreviously(IHidObject statement, XEvalScope xParentEvalScope, IntrpStackFrame stackFrame, int lastStatementLine, int currStatementLine) {
        if (this.yieldingState == YieldingStates.PREVIOUSLY_YIELDED && lastStatementLine != -1 && lastStatementLine == currStatementLine) {
            if (this.stepOverDetails != null && this.stepOverDetails.stepOverScope == xParentEvalScope) {
                if (this.state == State.STEPPING_OVER) {
                    this.caseSteppingOver(statement, xParentEvalScope, stackFrame);
                }
                if (this.state == State.STEPPING_RETURN) {
                    this.caseSteppingReturn(statement, stackFrame);
                }
                this.yieldingState = YieldingStates.HAS_YIELDED;
                return true;
            }
            if (this.state == State.STEPPING_INTO) {
                this.caseSteppingInto(stackFrame);
            }
            if (this.state == State.RUNNING) {
                this.caseRunning();
            }
            this.yieldingState = null;
            return true;
        }
        return false;
    }

    private void handleMacroSteppingInComplexCondition(boolean lineHasBreakpoint) {
        XEvalScope secondEncolsingEvalScope = this.xThread.getEnclosingScope(true);
        if (!(secondEncolsingEvalScope instanceof XConditionalEvalScope)) {
            return;
        }
        XEvalScope enclosigEvalScope = this.xThread.getEnclosingScope(false);
        if (!(enclosigEvalScope instanceof XSeqBlockEvalScope)) {
            return;
        }
        XConditionalEvalScope conditionalEvalScope = (XConditionalEvalScope)secondEncolsingEvalScope;
        XSeqBlockEvalScope enclosingSeqEvalScope = (XSeqBlockEvalScope)enclosigEvalScope;
        IHidOperator possibleMacroStatement = enclosingSeqEvalScope.getParentOperator();
        if (possibleMacroStatement == null || possibleMacroStatement instanceof HidEvalCenter.BlockStatement) {
            return;
        }
        if (!conditionalEvalScope.isDebuggingMacroInCondition() && this.handleEnteredMacroCallInComplexCondition(possibleMacroStatement, conditionalEvalScope, lineHasBreakpoint)) {
            return;
        }
        this.handleExitedMacroCallInComplexCondition(conditionalEvalScope, enclosingSeqEvalScope, possibleMacroStatement);
    }

    private void handleExitedMacroCallInComplexCondition(XConditionalEvalScope conditionalEvalScope, XSeqBlockEvalScope enclosigSeqEvalScope, IHidOperator possibleMacroStatement) {
        MacroCallInfo lastMacroCallInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope conditionalScopeParent = this.xThread.getParentScope(true);
        if (lastMacroCallInfo == null || conditionalScopeParent == null || conditionalScopeParent != lastMacroCallInfo.macroCallScope || this.hasVirtualOffset(possibleMacroStatement)) {
            return;
        }
        IHidObject condition = conditionalEvalScope.getCondition();
        if (!(condition instanceof IHidOperator)) {
            return;
        }
        IHidEvaluator enclosigSeqEvalScopeEvaluator = enclosigSeqEvalScope.getEvaluator();
        if (enclosigSeqEvalScopeEvaluator == null) {
            return;
        }
        IRfNamedElement enclosingEvaluatorNamedElement = enclosigSeqEvalScopeEvaluator.getNamedElement();
        if (enclosingEvaluatorNamedElement == null) {
            return;
        }
        EnumSet<HidFlatteningOption> flatteningOptions = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS);
        Set<IHid> rhHids = ((IHidOperator)condition).getRHHids(flatteningOptions);
        if (this.isMethodPartOfComplexOperator(enclosingEvaluatorNamedElement, rhHids)) {
            this.popMacroCallInComplexCondition(lastMacroCallInfo);
            return;
        }
        Set<IHid> lhHids = ((IHidOperator)condition).getLHHids(flatteningOptions);
        if (this.isMethodPartOfComplexOperator(enclosingEvaluatorNamedElement, lhHids)) {
            this.popMacroCallInComplexCondition(lastMacroCallInfo);
            return;
        }
    }

    private void popMacroCallInComplexCondition(MacroCallInfo lastMacroCallInfo) {
        MacroCallInfo newLastMacroCallInfo;
        this.resetDebuggingMacroInConditionFlag(lastMacroCallInfo);
        this.macroCallStackScope.pop();
        MacroCallInfo macroCallInfo = newLastMacroCallInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        if (newLastMacroCallInfo == null) {
            return;
        }
        if (lastMacroCallInfo.macroState == MacroSteppingStates.HIT_BP_IN_MACRO_CALL && lastMacroCallInfo.reExecuteFirstStatement) {
            newLastMacroCallInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
            newLastMacroCallInfo.reExecuteFirstStatement = true;
        }
    }

    private void resetDebuggingMacroInConditionFlag(MacroCallInfo lastMacroCallScopeInfo) {
        XConditionalEvalScope lastMacroCallXConditionalEvalScope = lastMacroCallScopeInfo.xConditionalEvalScope;
        if (lastMacroCallXConditionalEvalScope != null) {
            lastMacroCallXConditionalEvalScope.setDebuggingMacroInCondition(false);
        }
    }

    private boolean handleEnteredMacroCallInComplexCondition(IHidOperator possibleFirstMacroStatement, XConditionalEvalScope conditionalEvalScope, boolean lineHasBreakpoint) {
        if (!this.hasVirtualOffset(possibleFirstMacroStatement)) {
            return false;
        }
        MacroCallInfo lastMacroCallInfo = this.macroCallStackScope.isEmpty() ? null : this.macroCallStackScope.peek();
        XEvalScope lastMacroCallScope = lastMacroCallInfo == null ? null : lastMacroCallInfo.macroCallScope;
        XEvalScope conditionalScopeParent = this.xThread.getParentScope(true);
        if (conditionalScopeParent == null) {
            return false;
        }
        if (lastMacroCallInfo == null || lastMacroCallScope != conditionalScopeParent) {
            boolean shouldReExecuteFirstMacroStatement = lastMacroCallInfo != null && lastMacroCallInfo.reExecuteFirstStatement || lineHasBreakpoint;
            MacroCallInfo macroCallInfo = new MacroCallInfo(possibleFirstMacroStatement, conditionalScopeParent, shouldReExecuteFirstMacroStatement, conditionalEvalScope);
            if (lineHasBreakpoint) {
                macroCallInfo.macroState = MacroSteppingStates.HIT_BP_IN_MACRO_CALL;
            }
            this.macroCallStackScope.push(macroCallInfo);
            conditionalEvalScope.setDebuggingMacroInCondition(true);
            return true;
        }
        if (lastMacroCallScope == conditionalScopeParent) {
            conditionalEvalScope.setDebuggingMacroInCondition(true);
            lastMacroCallInfo.xConditionalEvalScope = conditionalEvalScope;
            return true;
        }
        return false;
    }

    private int caseSteppingInto(IntrpStackFrame stackFrame) {
        int resumeExecutionDetail = 1;
        this.isReturnFromMainFunction = false;
        stackFrame.isSkippedStatement = true;
        this.setState(State.STEPPING_INTO);
        return resumeExecutionDetail;
    }

    private void caseRunning() {
        if (this.debugTarget != null && this.debugTarget.getBreakpoints() != null && this.debugTarget.getBreakpoints().length == 0) {
            this.debugTarget.setHasBreakpoints(false);
        }
        this.setState(State.RUNNING);
    }

    private int caseSteppingReturn(IHidObject statement, IntrpStackFrame stackFrame) {
        int resumeExecutionDetail;
        if (this.xThread.getXThreadDefinition().isFirstStatementOnMainThread(statement)) {
            resumeExecutionDetail = 1;
            this.setState(State.STEPPING_INTO);
        } else {
            IHidObject stepReturnStatement = this.getStepReturnStatement();
            if (stepReturnStatement == null) {
                this.isReturnFromMainFunction = true;
                this.stepOverDetails = null;
            } else {
                this.stepOverDetails = new StepOverDetails(stepReturnStatement, this.xThread.getParentScope(true));
                this.isReturnFromMainFunction = false;
            }
            stackFrame.isSkippedStatement = false;
            resumeExecutionDetail = 4;
            this.setState(State.STEPPING_RETURN);
        }
        return resumeExecutionDetail;
    }

    private int caseSteppingOver(IHidObject statement, XEvalScope xParentEvalScope, IntrpStackFrame stackFrame) {
        int resumeExecutionDetail;
        if (this.xThread.getXThreadDefinition().isFirstStatementOnMainThread(statement)) {
            resumeExecutionDetail = 1;
            this.setState(State.STEPPING_INTO);
        } else {
            this.stepOverDetails = new StepOverDetails(statement, xParentEvalScope);
            resumeExecutionDetail = 2;
            this.isReturnFromMainFunction = false;
            stackFrame.isSkippedStatement = true;
            this.setState(State.STEPPING_OVER);
        }
        return resumeExecutionDetail;
    }

    @Override
    public void preStartEval() {
        if (!this.isSuspended()) {
            return;
        }
        this.resumeExecution(32);
    }

    private void setState(State newState) {
        if (!this.isTerminated()) {
            this.state = newState;
        }
    }

    @Override
    public String getStackPeekString() {
        IntrpStackFrame peekFrame = (IntrpStackFrame)this.peekStackFrame();
        if (peekFrame == null) {
            return "";
        }
        return peekFrame.getSignature();
    }

    public void callbackThreadYield() {
    }

    public boolean isHotSwapPending() {
        return this.isHotSwapPending;
    }

    public IIntrpEvaluator getIntrpEvaluator() {
        return this.intrpEvaluator;
    }

    public void callbackValueAccessed(IRfNamedElement namedElement, boolean isModification) {
        IBreakpointManager breakpointManager;
        IBreakpointManager iBreakpointManager = breakpointManager = DebugPlugin.getDefault() != null ? DebugPlugin.getDefault().getBreakpointManager() : null;
        if (!this.debugTarget.hasWatchpoints() || breakpointManager != null && !breakpointManager.isEnabled()) {
            return;
        }
        if (this.state == State.SUSPENDED) {
            return;
        }
        if (this.lastExecuteStatement == null || this.lastExecuteStatement.xGetLine() < 0) {
            return;
        }
        if (this.isEvaluatingDebugExpression) {
            return;
        }
        try {
            boolean shouldSuspend;
            if (namedElement == null) {
                return;
            }
            IRfDefElement namedElementDeclaration = namedElement.getDeclaration();
            if (namedElementDeclaration == null) {
                return;
            }
            Watchpoint watchpoint = this.debugTarget.getWatchpoint(Integer.toString(BreakpointsUtils.computeWatchpointElementID(namedElement)));
            if (watchpoint == null || !watchpoint.isEnabled()) {
                return;
            }
            XEvalScope xParentEvalScope = this.xThread.getParentScope(false);
            if (xParentEvalScope == null) {
                return;
            }
            Method hasActiveTriggerPointsM = null;
            if (breakpointManager != null) {
                try {
                    hasActiveTriggerPointsM = breakpointManager.getClass().getMethod("hasActiveTriggerPoints", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if (!this.shouldWatchpointHit(watchpoint, isModification) || !this.shouldBreakpointHit(null, watchpoint, breakpointManager, hasActiveTriggerPointsM, xParentEvalScope)) {
                return;
            }
            IntrpStackFrame stackFrame = (IntrpStackFrame)xParentEvalScope.getStackFrame();
            if (stackFrame == null || stackFrame.getLineNumber() < 0) {
                return;
            }
            int lastStatementLine = -1;
            int currStatementLine = -1;
            if (this.prevLastExecuteStatement != null) {
                lastStatementLine = this.prevLastExecuteStatement.xGetLine();
                currStatementLine = this.lastExecuteStatement.xGetLine();
            }
            if (!(shouldSuspend = this.prepareSuspendForBreakpoint(breakpointManager, stackFrame, xParentEvalScope, lastStatementLine, currStatementLine, hasActiveTriggerPointsM, true))) {
                return;
            }
            this.breakpoint = watchpoint;
            this.watchpointField = namedElement.getName();
            this.watchpointSuspendType = isModification ? "modification" : "access";
            IRfScopeElement watchpointFieldEnclosingScope = namedElement.getEnclosingScope();
            this.watchpointEnclosingScope = watchpointFieldEnclosingScope != null ? watchpointFieldEnclosingScope.getName() : "";
            int resumeExecutionDetail = this.handleSuspendStatement(16, xParentEvalScope, stackFrame);
            if (resumeExecutionDetail == -1) {
                return;
            }
            this.requestedState = this.state;
            this.resumeExecution(resumeExecutionDetail);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setEvaluatingDebugExpression(boolean isEvaluatingDebugExpression) {
        this.isEvaluatingDebugExpression = isEvaluatingDebugExpression;
    }

    public boolean isEvaluatingDebugExpression() {
        return this.isEvaluatingDebugExpression;
    }

    public static class MacroCallInfo {
        XEvalScope macroCallScope;
        IHidObject firstStatement;
        boolean reExecuteFirstStatement;
        private MacroSteppingStates macroState;
        XConditionalEvalScope xConditionalEvalScope;

        public MacroCallInfo(IHidObject firstStatement, XEvalScope macroCallScope, boolean reexecuteFirstStatement, XConditionalEvalScope xConditionalEvalScope) {
            this.firstStatement = firstStatement;
            this.macroCallScope = macroCallScope;
            this.reExecuteFirstStatement = reexecuteFirstStatement;
            this.macroState = MacroSteppingStates.INSIDE_MACRO;
            this.xConditionalEvalScope = xConditionalEvalScope;
        }
    }

    private static enum MacroSteppingStates {
        INSIDE_MACRO,
        HIT_BP_IN_MACRO_CALL;

    }

    public static enum State {
        STEPPING_INTO,
        STEPPING_OVER,
        STEPPING_RETURN,
        RUNNING,
        SUSPENDED;

    }

    private static class StepOverDetails {
        public IHidObject stepOverStatement;
        public XEvalScope stepOverScope;

        public StepOverDetails(IHidObject stepOverStatement, XEvalScope stepOverScope) {
            this.stepOverStatement = stepOverStatement;
            this.stepOverScope = stepOverScope;
        }
    }

    private static class TerminateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TerminateException() {
        }
    }

    private static enum YieldingStates {
        YIELDED,
        PREVIOUSLY_YIELDED,
        HAS_YIELDED;

    }
}

