/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class IntrpDebugThreadKindGroup
implements IThread,
IIntrpLabelProvider {
    private IDebugTarget debugTarget;
    private XThreadDefinition.ThreadKind threadKind;
    private int id;
    private List<IThread> threads;

    public IntrpDebugThreadKindGroup(IDebugTarget debugTarget, XThreadDefinition.ThreadKind threadKind, int id) {
        this.debugTarget = debugTarget;
        this.threadKind = threadKind;
        this.id = id;
        this.threads = new ArrayList<IThread>();
    }

    public IDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public int getId() {
        return this.id;
    }

    public void addThread(IThread thread) {
        this.threads.add(thread);
    }

    public List<IThread> getThreads() {
        return this.threads;
    }

    public String getModelIdentifier() {
        return this.debugTarget.getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.debugTarget.getLaunch();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.debugTarget.isTerminated();
    }

    public boolean isTerminated() {
        return this.debugTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        this.debugTarget.terminate();
    }

    public boolean hasStackFrames() throws DebugException {
        return false;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return null;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return null;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    public String getName() throws DebugException {
        String firstThreadId = String.valueOf(this.id);
        IThread lastThread = this.threads.get(this.threads.size() - 1);
        String lastThreadId = lastThread instanceof IntrpDebugThread ? String.valueOf(((IntrpDebugThread)lastThread).getId()) : "N/A";
        return String.valueOf(this.threadKind.toString().toLowerCase()) + " threads [" + firstThreadId + " ... " + lastThreadId + "]";
    }

    @Override
    public String getText() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.THREAD_RUNNING);
    }
}

