/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDropToFrame;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.intrp.model.DVTDebugTooltipUtil;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTStringUtil;

public class IntrpStackFrame
extends IntrpDebugElement
implements IStackFrame,
IDropToFrame,
IIntrpLabelProvider {
    private IThread thread;
    private XEvalScope xEvalScope;
    public int currLine;
    public int prevLine;
    private ParserPath parserPath;
    private ParserPath initialParserPath;
    private IIntrpEvaluator evaluator;
    private IHidEvaluator xValue;
    private IVariable[] variables;
    private String additionalInfo;
    private boolean isInitVariablesFrame;
    public ArrayDeque<IHidEvaluator> stackValues;
    public IHidObject currStatement;
    private boolean isFirstStackFrame;
    public boolean isSkippedStatement;
    private TreePath treePath;

    public static IntrpStackFrame create(IDebugTarget target, IThread thread, XEvalScope xEvalScope, ParserPath parserPath, IIntrpEvaluator evaluator, boolean isFirstStackFrame) {
        int lineNumber = xEvalScope.getLineNumber();
        IHidEvaluator xValue = xEvalScope.getEvaluator();
        String additionalInfo = xEvalScope.getAdditionalInfo();
        boolean isInitVariablesFrame = xEvalScope instanceof XFrameBlockEvalScope && ((XFrameBlockEvalScope)xEvalScope).isInitVariablesFrame();
        return new IntrpStackFrame(target, thread, xEvalScope, lineNumber, parserPath, xValue, additionalInfo, isInitVariablesFrame, evaluator, isFirstStackFrame);
    }

    private IntrpStackFrame(IDebugTarget target, IThread thread, XEvalScope xEvalScope, int lineNumber, ParserPath parserPath, IHidEvaluator xValue, String additionalInfo, boolean isInitVariablesFrame, IIntrpEvaluator evaluator, boolean isFirstStackFrame) {
        super(target);
        this.thread = thread;
        this.xEvalScope = xEvalScope;
        this.prevLine = lineNumber;
        this.currLine = lineNumber;
        this.parserPath = parserPath;
        this.initialParserPath = parserPath;
        this.xValue = xValue;
        this.additionalInfo = additionalInfo;
        this.isInitVariablesFrame = isInitVariablesFrame;
        this.evaluator = evaluator;
        this.isFirstStackFrame = isFirstStackFrame;
        this.stackValues = new ArrayDeque();
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath == null ? this.initialParserPath : parserPath;
    }

    public void setInitialParserPath(ParserPath initialParserPath) {
        this.initialParserPath = initialParserPath;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean canDropToFrame() {
        if (!(this.thread instanceof IntrpDebugThread)) {
            return false;
        }
        return ((IntrpDebugThread)this.thread).canDropToFrame();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public void dropToFrame() throws DebugException {
        if (!(this.thread instanceof IntrpDebugThread)) {
            return;
        }
        ((IntrpDebugThread)this.thread).dropToFrame(this);
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public void localTerminate() {
        this.fireTerminateEvent();
    }

    public String getName() {
        IRfNamedElement namedElement = this.xValue.getNamedElement();
        return namedElement.getName();
    }

    public IThread getThread() {
        return this.thread;
    }

    public XEvalScope getXEvalScope() {
        return this.xEvalScope;
    }

    public IVariable[] getVariables() {
        TreeMap<DVTXVariableInfo, IELParamValue> variables = new TreeMap<DVTXVariableInfo, IELParamValue>((o1, o2) -> {
            DVTXVariableType o2Type;
            if (o1 == null || o2 == null) {
                return 0;
            }
            DVTXVariableType o1Type = o1.getVariableType();
            if (o1Type == (o2Type = o2.getVariableType())) {
                return o1.getVariableName().compareTo(o2.getVariableName());
            }
            return o1Type.compareTo(o2Type);
        });
        Map<DVTXVariableInfo, IELParamValue> myVariables = this.xValue.debuggerGetVariables(this.isFirstStackFrame);
        if (myVariables != null) {
            variables.putAll(myVariables);
        }
        if (!this.stackValues.isEmpty()) {
            Iterator<IHidEvaluator> iter = this.stackValues.descendingIterator();
            while (iter.hasNext()) {
                Map<DVTXVariableInfo, IELParamValue> nextVariables;
                IHidEvaluator next = iter.next();
                if (next == null || next == this.xValue || (nextVariables = next.debuggerGetVariables(this.isFirstStackFrame)) == null) continue;
                variables.putAll(nextVariables);
            }
        }
        IVariable[] newVariables = this.evaluator.getVariables(this.xValue, variables);
        this.variables = this.computeVariables(newVariables);
        return this.variables;
    }

    private IVariable[] computeVariables(IVariable[] newVariables) {
        if (this.variables == null || this.variables.length == 0 || newVariables.length == 0) {
            return newVariables;
        }
        int oldVariablesIterator = 0;
        int newVariablesIterator = 0;
        IVariable[] updatedVariables = new IVariable[newVariables.length];
        while (newVariablesIterator < newVariables.length) {
            IVariable newVariable = newVariables[newVariablesIterator];
            if (oldVariablesIterator < this.variables.length && this.variables[oldVariablesIterator].equals(newVariable)) {
                IVariable oldVariable;
                updatedVariables[newVariablesIterator] = oldVariable = this.variables[oldVariablesIterator];
                if (oldVariable instanceof IntrpVariable && newVariable instanceof IntrpVariable) {
                    ((IntrpVariable)updatedVariables[newVariablesIterator]).setValueChanged(((IntrpVariable)newVariable).hasValueChanged());
                }
                ++newVariablesIterator;
                ++oldVariablesIterator;
                continue;
            }
            updatedVariables[newVariablesIterator] = newVariable;
            ++newVariablesIterator;
        }
        return updatedVariables;
    }

    private int variablesCompare(String variableName1, String variableName2) {
        if (variableName1.startsWith("[repeat index @") && variableName2.startsWith("[repeat index @")) {
            return Integer.parseInt(variableName1.substring("[repeat index @".length(), variableName1.length() - 1)) - Integer.parseInt(variableName2.substring("[repeat index @".length(), variableName2.length() - 1));
        }
        if (variableName2.startsWith("[repeat index @")) {
            return 1;
        }
        if (variableName1.startsWith("[repeat index @")) {
            return -1;
        }
        return variableName1.compareTo(variableName2);
    }

    public boolean hasVariables() {
        Map<DVTXVariableInfo, IELParamValue> variables = this.xValue.debuggerGetVariables(this.isFirstStackFrame);
        if (variables != null && !variables.isEmpty()) {
            return true;
        }
        if (!this.stackValues.isEmpty()) {
            Iterator<IHidEvaluator> iter = this.stackValues.descendingIterator();
            while (iter.hasNext()) {
                Map<DVTXVariableInfo, IELParamValue> nextVariables;
                IHidEvaluator next = iter.next();
                if (next == null || (nextVariables = next.debuggerGetVariables(this.isFirstStackFrame)) == null || nextVariables.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public IVariable getVariable(String name, IRfNamedElementAndScope namedElementAndScope, Map<String, IRfNamedElementAndScope> indexElementMap) {
        if (namedElementAndScope == null) {
            return null;
        }
        IRfNamedElement element = namedElementAndScope.getIRfNamedElement();
        IELParamValue value = null;
        if (!this.stackValues.isEmpty()) {
            Iterator<IHidEvaluator> iter = this.stackValues.descendingIterator();
            while (iter.hasNext()) {
                IHidEvaluator next = iter.next();
                if (next == null || (value = DVTDebugTooltipUtil.isHierarchicalVariable(namedElementAndScope) ? DVTDebugTooltipUtil.getHierarchicalVariableValue(name, namedElementAndScope, next, this.evaluator, indexElementMap) : DVTDebugTooltipUtil.debuggerGetVariable(next, name, element, this.evaluator, indexElementMap)) == null) {
                    continue;
                }
                break;
            }
        } else {
            value = DVTDebugTooltipUtil.isHierarchicalVariable(namedElementAndScope) ? DVTDebugTooltipUtil.getHierarchicalVariableValue(name, namedElementAndScope, this.xValue, this.evaluator, indexElementMap) : DVTDebugTooltipUtil.debuggerGetVariable(this.xValue, name, element, this.evaluator, indexElementMap);
        }
        if (value == null) {
            return null;
        }
        if (element != null && value instanceof ELParamValues.ParamValueNumber && value.getElement() == null && value.getEnumTypeWrapper() == null) {
            value = ELParamValues.ParamValueNumber.of(value.getDVTNumber(), element, null);
        }
        return this.evaluator.getVariable(this.xValue, name, value, DVTXVariableType.NO_TYPE);
    }

    public int getLineNumber() throws DebugException {
        return this.currLine;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    @Override
    public Image getImage() {
        return this.evaluator.getImage(this.xValue);
    }

    @Override
    public String getText() {
        return this.evaluator.getText(this.xValue, this.additionalInfo);
    }

    public IRfNamedElement getRfElement() {
        return this.xValue.getNamedElement();
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public boolean isInitVariablesFrame() {
        return this.isInitVariablesFrame;
    }

    public String getSignature() {
        String text = this.getText();
        String path = this.parserPath == null ? "[N/A]" : this.parserPath.toString();
        return DVTStringUtil.appendString(text, " at line ", this.currLine, " in ", path);
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public int hashCode() {
        return super.hashCode() * this.parserPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntrpStackFrame)) {
            return false;
        }
        return super.equals(obj) && this.parserPath.path.equals(((IntrpStackFrame)obj).parserPath.path);
    }
}

