/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector__structMemberInfo;

public class IntrpValue
extends IntrpDebugElement
implements IValue {
    private static final Pattern HEXA_NUMBER_PATTERN = Pattern.compile("^(\\d{1,2}\\'h[0-9a-fA-FxXzZ?]+)$");
    private static final String ACTUAL_VALUE = "Actual value : ";
    private static final String TWO_SPACES = "  ";
    private static final String NEW_LINE = "\n";
    private static final Map<Integer, String> BASES = new LinkedHashMap<Integer, String>();
    private IntrpVariable variable;
    private String value;
    private IIntrpEvaluator evaluator;
    private IELParamValue xValue;

    static {
        BASES.put(2, "Base  2: ");
        BASES.put(8, "Base  8: ");
        BASES.put(10, "Base 10: ");
        BASES.put(16, "Base 16: ");
    }

    public IntrpValue(IDebugTarget target, IntrpVariable variable, String value, IIntrpEvaluator evaluator, IELParamValue xValue) {
        super(target);
        this.variable = variable;
        this.value = value;
        this.evaluator = evaluator;
        this.xValue = xValue;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.xValue instanceof ELParamValues.ParamValueNumber) {
            return this.variable.getReferenceTypeName();
        }
        return this.evaluator.getActualTypeName(this.xValue);
    }

    public String getValueString() throws DebugException {
        return this.value;
    }

    public boolean isEnumOrPackedStruct() {
        if (this.xValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum) {
            return true;
        }
        return this.xValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element && ((ELParamValues.ParamValueNumber.ParamValueNumber_Element)this.xValue).getDVTNumber() instanceof VlogBitVector__structMemberInfo;
    }

    public String getDetailsValueString() {
        if (this.getDebugTarget() == null || this.getDebugTarget().isTerminated()) {
            return "";
        }
        String valueString = ACTUAL_VALUE + this.value;
        Matcher isNumber = HEXA_NUMBER_PATTERN.matcher(this.value);
        if (!isNumber.matches() && !this.isEnumOrPackedStruct()) {
            return valueString;
        }
        if (this.xValue == null) {
            return valueString;
        }
        BitVectorContext paramContext = BitVectorContext.of(null, false);
        StringBuilder details = new StringBuilder(ACTUAL_VALUE);
        if (this.isEnumOrPackedStruct()) {
            details.append(this.value).append(NEW_LINE);
        } else {
            details = details.append(this.xValue.toNiceString(paramContext, PrefConst.getParamRadix(), false, false)).append(NEW_LINE);
        }
        for (Map.Entry<Integer, String> base : BASES.entrySet()) {
            details.append(TWO_SPACES).append(base.getValue()).append(this.xValue.toNiceString(paramContext, base.getKey(), false, false)).append(NEW_LINE);
        }
        return details.toString();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        LinkedHashMap<DVTXVariableInfo, IELParamValue> variables = new LinkedHashMap<DVTXVariableInfo, IELParamValue>();
        Map<DVTXVariableInfo, IELParamValue> myVariables = this.xValue.debuggerGetVariables(false);
        if (myVariables != null) {
            variables.putAll(myVariables);
        }
        return this.evaluator.getVariables(this.xValue, variables);
    }

    public boolean hasVariables() throws DebugException {
        if (this.xValue == null) {
            return false;
        }
        return this.xValue.debuggerHasVariables(false);
    }

    public int collectionSize() {
        return this.xValue.debuggerCollectionSize();
    }
}

