/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model;

import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpValue;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class IntrpVariable
extends IntrpDebugElement
implements IVariable,
IIntrpLabelProvider {
    private String name;
    private String typeName;
    private IValue value;
    private IELParamValue xValue;
    private IIntrpEvaluator evaluator;
    private boolean isValueChanged;
    private IHidEvaluator xParentHolder;
    private DVTXVariableType variableValueType;

    public IntrpVariable(IDebugTarget target, String name, String typeName, IELParamValue xValue, IHidEvaluator xParentHolder, IIntrpEvaluator evaluator) {
        super(target);
        this.name = name;
        this.typeName = typeName;
        this.xValue = xValue;
        this.xParentHolder = xParentHolder;
        this.evaluator = evaluator;
        this.isValueChanged = false;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public void setValue(String expression) throws DebugException {
        try {
            if (expression != null) {
                expression = expression.trim();
            }
            this.xValue = this.evaluator.setVariableValue(this.xParentHolder, expression, this.name, this.xValue);
            this.isValueChanged = true;
            this.fireChangeEvent(32);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new DebugException((IStatus)new Status(4, "ro.amiq.dvt", "Fail to change variable value"));
        }
    }

    public void setValue(IValue value) {
        this.value = value;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) {
        return true;
    }

    public boolean verifyValue(IValue value) {
        return false;
    }

    public IValue getValue() {
        String valueText = this.xParentHolder != null ? this.xParentHolder.debuggerGetValueString(this.name, this.xValue) : this.xValue.debuggerGetValueString(this.name, this.xValue);
        if (this.xValue instanceof ELParamValues.ParamValueType && this.xValue.getNamedElement() instanceof IRfClassElement && this.xParentHolder instanceof XValueHolder) {
            XValueHolderFactory factory = ((XValueHolder)this.xParentHolder).getFactory();
            XNamedElement xne = XNamedElement.create(this.xValue.getNamedElement(), null);
            XValueHolder holder = factory.getStaticValueHolder(xne);
            this.value = new IntrpValue(this.getDebugTarget(), this, valueText, this.evaluator, holder);
        } else {
            this.value = new IntrpValue(this.getDebugTarget(), this, valueText, this.evaluator, this.xValue);
        }
        return this.value;
    }

    public String getName() {
        if (this.value instanceof IntrpValue && ((IntrpValue)this.value).collectionSize() >= 0) {
            return String.valueOf(this.name) + " [size: " + ((IntrpValue)this.value).collectionSize() + "]";
        }
        return this.name;
    }

    public String getReferenceTypeName() {
        return this.typeName;
    }

    public boolean hasValueChanged() {
        return this.isValueChanged;
    }

    @Override
    public Image getImage() {
        Image image = this.evaluator.getImage(this.xValue);
        if (this.variableValueType == DVTXVariableType.STATIC) {
            image = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(image, DVTImages.VARIABLES_VIEW_STATIC_MEMBERS_DECORATOR, 1));
        }
        if (this.variableValueType == DVTXVariableType.PARENT) {
            image = DVTImages.imageCache.getImage(DVTImages.VARIABLES_VIEW_DESIGN_PARENT);
        }
        return image;
    }

    @Override
    public String getText() {
        return this.getName();
    }

    public void setValueChanged(boolean isValueChanged) {
        this.isValueChanged = isValueChanged;
    }

    public String toString() {
        return this.getText();
    }

    public IELParamValue getxValue() {
        return this.xValue;
    }

    public void setVariableType(DVTXVariableType variableValueType) {
        this.variableValueType = variableValueType;
    }

    public DVTXVariableType getVariableValueType() {
        return this.variableValueType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeName, this.xParentHolder, this.xValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntrpVariable other = (IntrpVariable)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.typeName, other.typeName) && Objects.equals(this.xParentHolder, other.xParentHolder) && Objects.equals(this.xValue, other.xValue);
    }
}

