/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.intrp.model.profiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class IntrpProfilerView
extends AbstractFilteredView {
    public static final String ID = "ro.amiq.dvt.ui.views.IntrpProfilerView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.FIXED_ELEMENT_INFORMATION);
    public static final int MAX_PROFILER_ENTRIES = 100;
    public static final int PROFILER_SAMPLE_PERIOD = 150;
    private Label fInfo;
    private List<ProfilerNode> fElements;
    private TreeViewer fTreeViewer;
    private Tree fTree;
    private ContentProvider fLabelProvider;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        SashForm fSashForm = new SashForm(composite, 2560);
        fSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.fTree = new Tree((Composite)fSashForm, 268438276);
        this.fTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.setHeaderVisible(true);
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fLabelProvider = new ContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fLabelProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTreeViewer.setInput((Object)TemplatesViewUtils.createTemplatesHierarchy());
        TreeColumn nameColumn = new TreeColumn(this.fTree, 16384);
        nameColumn.setText("Function Name");
        nameColumn.setWidth(600);
        TreeColumn projectColumn = new TreeColumn(this.fTree, 16384);
        projectColumn.setText("Number of Samples");
        projectColumn.setWidth(100);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IntrpProfilerView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.installContextMenuAndSelectionListener((Control)this.fTree);
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        super.setInput(dataContainer);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            this.fTreeViewer.setInput(this.fElements);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fInfo = null;
        this.fTreeViewer = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    private ILayersViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ILayersViewContributor.class);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreeItem[] sel = this.getTree(treeId).getSelection();
        if (sel == null || sel.length == 0 || sel[0].getData() == null) {
            return;
        }
        if (!(sel[0].getData() instanceof ProfilerNode)) {
            return;
        }
        ProfilerNode selected = (ProfilerNode)sel[0].getData();
        File file = selected.getFile();
        int line = selected.getLine();
        if (line >= 0 && file != null) {
            DVTFileUtils.getInstance().openEditor(file, line, "ro.amiq.vlogdt.ui.editor.VlogEditor");
        }
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fElements;
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
        this.fTreeViewer.setInput(null);
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo;
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    public void setData(Map<IRfNamedElement, Integer> profilingData) {
        this.updateElements(profilingData);
        this.fTreeViewer.setInput(this.fElements);
    }

    public void updateData(Map<IRfNamedElement, Integer> profilingData) {
        this.updateElements(profilingData);
        this.fTreeViewer.refresh();
    }

    private void updateElements(Map<IRfNamedElement, Integer> profilingData) {
        ArrayList<Map.Entry<IRfNamedElement, Integer>> sortedData = new ArrayList<Map.Entry<IRfNamedElement, Integer>>(profilingData.size());
        sortedData.addAll(profilingData.entrySet());
        Collections.sort(sortedData, (o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        int index = 0;
        this.fElements = new ArrayList<ProfilerNode>(100);
        for (Map.Entry entry : sortedData) {
            if (index == 100) break;
            this.fElements.add(new ProfilerNode(((IRfNamedElement)entry.getKey()).getFullNameLabel(), (Integer)entry.getValue(), ((IRfNamedElement)entry.getKey()).getDeclaration()));
            ++index;
        }
    }

    private class ContentProvider
    implements ITreeContentProvider,
    ITableLabelProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (IntrpProfilerView.this.fElements == null) {
                return new Object[0];
            }
            return IntrpProfilerView.this.fElements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object object, int index) {
            return index == 0 ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION) : null;
        }

        public String getColumnText(Object object, int index) {
            if (index == 0) {
                return ((ProfilerNode)object).fullNameLabel;
            }
            if (index == 1) {
                return Integer.toString(((ProfilerNode)object).samples);
            }
            return "";
        }

        public void dispose() {
        }
    }

    class LayersHistoryAction
    extends HistoryAction {
        LayersHistoryAction() {
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            IProject newProject = Utils.getProject(((UpdateViewEvent)item).getProjectName());
            IntrpProfilerView.this.setInput(new ViewDataContainer(newProject, item));
            IntrpProfilerView.this.update(null);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    private static class ProfilerNode {
        private String fullNameLabel;
        private int samples;
        private IRfDefElement declaration;

        public ProfilerNode(String fullNameLabel, int samples, IRfDefElement declaration) {
            this.fullNameLabel = fullNameLabel;
            this.samples = samples;
            this.declaration = declaration;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fullNameLabel == null ? 0 : this.fullNameLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProfilerNode other = (ProfilerNode)obj;
            return !(this.fullNameLabel == null ? other.fullNameLabel != null : !this.fullNameLabel.equals(other.fullNameLabel));
        }

        public int getLine() {
            return this.declaration == null ? -1 : this.declaration.getStartLine();
        }

        public File getFile() {
            if (this.declaration == null) {
                return null;
            }
            IRfFileDef defFile = this.declaration.getDefFile();
            if (defFile == null) {
                return null;
            }
            ParserPath parserPath = defFile.getParserPath();
            if (parserPath == null) {
                return null;
            }
            return new File(parserPath.path);
        }
    }

    class ShowESubtypeAction
    extends Action {
        ShowESubtypeAction() {
            super("Show Subtype Layers", 8);
            this.setDescription("Show Subtype Layers");
            this.setToolTipText("Show Subtype Layers");
            this.setImageDescriptor(DVTImages.SUB_CO);
            this.setChecked(PrefConst.getLayersViewShowESubtypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESubtypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowESubtypeSupertypeAction
    extends Action {
        ShowESubtypeSupertypeAction() {
            super("Show Subtype && Supertype Layers", 8);
            this.setDescription("Show Subtype && Supertype Layers");
            this.setToolTipText("Show Subtype && Supertype  Layers");
            this.setImageDescriptor(DVTImages.HIERARCHY_CO);
            this.setChecked(PrefConst.getLayersViewShowESubtypeSupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESubtypeSupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowESupertypeAction
    extends Action {
        ShowESupertypeAction() {
            super("Show Supertype Layers", 8);
            this.setDescription("Show Supertype Layers");
            this.setToolTipText("Show Supertype Layers");
            this.setImageDescriptor(DVTImages.SUPER_CO);
            this.setChecked(PrefConst.getLayersViewShowESupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowESupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowETypeAction
    extends Action {
        ShowETypeAction() {
            super("Show Full Type Layers", 8);
            this.setDescription("Show Full Type Layers");
            this.setToolTipText("Show Full Type Layers");
            this.setImageDescriptor(DVTImages.ALL_CO);
            this.setChecked(PrefConst.getLayersViewShowETypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowETypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowVlogSubtypeAction
    extends Action {
        ShowVlogSubtypeAction() {
            super("Show Subtype Layers", 8);
            this.setDescription("Show Subtype Layers");
            this.setToolTipText("Show Subtype Layers");
            this.setImageDescriptor(DVTImages.SUB_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogSubtypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogSubtypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowVlogSupertypeAction
    extends Action {
        ShowVlogSupertypeAction() {
            super("Show Supertype Layers", 8);
            this.setDescription("Show Supertype Layers");
            this.setToolTipText("Show Supertype Layers");
            this.setImageDescriptor(DVTImages.SUPER_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogSupertypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogSupertypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }

    class ShowVlogTypeAction
    extends Action {
        ShowVlogTypeAction() {
            super("Show Full Type Layers", 8);
            this.setDescription("Show Full Type Layers");
            this.setToolTipText("Show Full Type Layers");
            this.setImageDescriptor(DVTImages.HIERARCHY_CO);
            this.setChecked(PrefConst.getLayersViewShowVlogTypeLayers());
        }

        public void run() {
            PrefConst.setLayersViewShowVlogTypeLayers(this.isChecked());
            if (this.isChecked()) {
                IntrpProfilerView.this.update(null);
            }
        }
    }
}

