/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.launching;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.launching.DVTDebugNatureDialog;
import ro.amiq.dvt.debug.core.launching.DebugLaunchUtils;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTSystemVariables;

public class DVTDebugLaunchConfigurationDelegate
extends DVTLaunchConfigurationDelegate {
    private static final Pattern HOST_PATTERN = Pattern.compile("^\\s*host:\\s*(\\S+)");
    private static final Pattern PORT_PATTERN = Pattern.compile("^\\s*port:\\s*(\\d+)");
    private int fSocketFileExistsDialogReturnCode;
    private DebugTarget fDebugTarget;
    private static final String DVT_DEBUG_LAUNCH_TYPE_ID = "ro.amiq.dvt.launch.DVTGenericLaunchConfigurationType";

    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.launch(config, mode, launch, monitor);
        if (this.fDebugTarget != null) {
            this.fDebugTarget.terminateInternal(true);
        }
    }

    @Override
    protected int preProcessExecution(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration) throws CoreException {
        String[] stringArray;
        String[] natures;
        final ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        final String beforeNature = workingCopy.getAttribute("debug target use", "NA");
        final ArrayList<String> naturesToChose = new ArrayList<String>(3);
        if (project != null && project.getDescription() != null && (natures = project.getDescription().getNatureIds()) != null) {
            stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
                    naturesToChose.add(nature);
                } else if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
                    naturesToChose.add(nature);
                } else if (nature.equals("ro.amiq.edt.enature")) {
                    naturesToChose.add(nature);
                } else if (nature.equals("ro.amiq.slndt.slnnature")) {
                    naturesToChose.add(nature);
                } else if (nature.equals("ro.amiq.msdldt.msdlnature")) {
                    naturesToChose.add(nature);
                } else if (nature.equals("ro.amiq.pssdt.pssnature")) {
                    naturesToChose.add(nature);
                }
                ++n2;
            }
        }
        if (naturesToChose.size() == 1) {
            workingCopy.setAttribute("debug target use", (String)naturesToChose.get(0));
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DVTDebugNatureDialog dialog = new DVTDebugNatureDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Chose Debug Target Nature", workingCopy, naturesToChose, beforeNature);
                    dialog.open();
                }
            });
        }
        String afterNature = workingCopy.getAttribute("debug target use", "NA");
        if (!naturesToChose.contains(afterNature)) {
            throw new OperationCanceledException();
        }
        if (!beforeNature.equals(afterNature)) {
            workingCopy.doSave();
        }
        File socketFile = this.getSocketFile(configuration);
        File debuggerLogFile = DVTSystemVariables.getFile("DVT_DEBUGGER_REPLAY_LOG");
        if (debuggerLogFile != null) {
            block38: {
                Throwable throwable = null;
                stringArray = null;
                BufferedWriter out = new BufferedWriter(new FileWriter(socketFile));
                try {
                    out.write("host:127.0.0.1\n");
                    out.write("port:27000\n");
                    if (out == null) break block38;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                out.close();
            }
            return 1;
        }
        if (socketFile != null && socketFile.exists() && socketFile.canWrite()) {
            HostPort hostPort = this.parseSocketFile(socketFile);
            if (hostPort.getHost() == null || hostPort.getPort() == null) {
                socketFile.delete();
                return 0;
            }
            try {
                DebugTarget existingTarget = this.getExistingTarget(launch, hostPort.getHost(), hostPort.getPort());
                if (existingTarget == null || existingTarget.isDisconnected() || existingTarget.isTerminated()) {
                    Socket testSocket = new Socket(hostPort.getHost(), Integer.parseInt(hostPort.getPort()));
                    testSocket.close();
                }
            }
            catch (Exception exception) {
                socketFile.delete();
                return 0;
            }
            if (TestHelper.isTestMode()) {
                return TestHelper.fSocketFileExistsDialogReturnCode;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Found a Socket File!", null, "A socket file was found in the working directory, maybe from an existing simulation.\nWould you like to connect to existing simulation or start a new one?", 3, new String[]{"Connect", "Start New"}, 0);
                    DVTDebugLaunchConfigurationDelegate.this.fSocketFileExistsDialogReturnCode = dialog.open();
                }
            });
            if (this.fSocketFileExistsDialogReturnCode == 0) {
                return 1;
            }
            if (this.fSocketFileExistsDialogReturnCode == 1) {
                socketFile.delete();
                return 0;
            }
            return 2;
        }
        return 0;
    }

    private HostPort parseSocketFile(File socketFile) {
        String host = null;
        String port = null;
        BufferedReader socketFileBR = null;
        try {
            socketFileBR = new BufferedReader(new FileReader(socketFile));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (socketFileBR != null) {
            try {
                String nextLine = null;
                while ((nextLine = socketFileBR.readLine()) != null) {
                    Matcher portMatcher;
                    Matcher hostMatcher;
                    if (host == null && (hostMatcher = HOST_PATTERN.matcher(nextLine)).find()) {
                        host = hostMatcher.group(1);
                    }
                    if (port != null || !(portMatcher = PORT_PATTERN.matcher(nextLine)).find()) continue;
                    port = portMatcher.group(1);
                }
            }
            catch (IOException iOException) {}
            try {
                socketFileBR.close();
            }
            catch (IOException iOException) {}
        }
        return new HostPort(host, port);
    }

    @Override
    public void postProcessExecution(ILaunchConfiguration config, String mode, final ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration, int processState) throws CoreException {
        if (mode.equals("debug")) {
            boolean startDebug;
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            if (launchConfiguration == null) {
                launch.terminate();
                return;
            }
            ILaunchConfigurationType launchConfigurationType = launchConfiguration.getType();
            if (launchConfigurationType == null) {
                launch.terminate();
                return;
            }
            if (!DVT_DEBUG_LAUNCH_TYPE_ID.equals(launchConfigurationType.getIdentifier())) {
                launch.terminate();
                return;
            }
            final File socketFile = this.getSocketFile(configuration);
            if (socketFile == null) {
                launch.terminate();
                return;
            }
            boolean bl = startDebug = processState != 2;
            if (startDebug) {
                Job sendJob = new Job("Connect to Debug Target (simulator)"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus result = DVTDebugLaunchConfigurationDelegate.this.waitForSocketFile(launch, socketFile, monitor);
                        monitor.done();
                        return result;
                    }
                };
                sendJob.setSystem(false);
                sendJob.setUser(true);
                DVTJobsUtils.scheduleAndJoin(sendJob);
                if (sendJob.getResult() != Status.OK_STATUS) {
                    launch.terminate();
                    return;
                }
            }
            if (launch.isTerminated()) {
                launch.terminate();
                return;
            }
            if (!socketFile.exists()) {
                launch.terminate();
                return;
            }
            HostPort hostPort = this.parseSocketFile(socketFile);
            if (startDebug) {
                DebugLaunchUtils.switchToDebugPerspective();
            }
            this.fDebugTarget = this.getExistingTarget(launch, hostPort.getHost(), hostPort.getPort());
            if (this.fDebugTarget != null) {
                this.fDebugTarget.terminateInternal(true);
            }
            this.fDebugTarget = new DebugTarget(launch, hostPort.getHost(), hostPort.getPort(), monitor, startDebug);
            if (!startDebug) {
                this.fDebugTarget.terminateInternal(false);
            }
            launch.addDebugTarget((IDebugTarget)this.fDebugTarget);
            if (this.fDebugTarget.isTerminated() || this.fDebugTarget.isDisconnected()) {
                this.fDebugTarget.fireTerminateEvent();
                launch.terminate();
            }
        }
    }

    private DebugTarget getExistingTarget(ILaunch launch, String host, String port) {
        IDebugTarget[] debugTargets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        if (debugTargets == null || debugTargets.length == 0) {
            return null;
        }
        IDebugTarget[] iDebugTargetArray = debugTargets;
        int n = debugTargets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            if (!debugTarget.isTerminated() && debugTarget instanceof DebugTarget && ((DebugTarget)debugTarget).isSameDebugTargetAs(launch, host, port)) {
                return (DebugTarget)debugTarget;
            }
            ++n2;
        }
        return null;
    }

    private File getSocketFile(ExternalToolsConfiguration configuration) throws CoreException {
        IPath workingDirectoryPath = ExternalToolsUtil.getWorkingDirectory(configuration);
        return workingDirectoryPath.append("dvt_debug.socket").toFile();
    }

    private IStatus waitForSocketFile(ILaunch launch, File file, IProgressMonitor monitor) {
        monitor.beginTask("Scanning for sockets file...", -1);
        while (!(file.exists() || monitor.isCanceled() || launch.isTerminated())) {
            try {
                Thread.sleep(200L);
                monitor.worked(200);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!file.exists() || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    static class HostPort {
        private String fHost;
        private String fPort;

        public HostPort(String host, String port) {
            this.fHost = host;
            this.fPort = port;
        }

        public String getHost() {
            return this.fHost;
        }

        public String getPort() {
            return this.fPort;
        }
    }
}

