/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.launching.DVTDebugNatureDialog;
import ro.amiq.dvt.debug.core.launching.DebugLaunchUtils;
import ro.amiq.dvt.debug.core.model.DebugTarget;

public class LaunchDelegate
extends LaunchConfigurationDelegate {
    protected static final String EMPTY_STRING = "";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = null;
        String projectName = config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", EMPTY_STRING);
        if (projectName != null && projectName.trim().length() != 0) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.trim());
        }
        if (project != null && project.exists() && project.getDescription() != null) {
            final ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
            final String beforeNature = workingCopy.getAttribute("debug target use", "NA");
            final ArrayList<String> naturesToChose = new ArrayList<String>(3);
            String[] natures = project.getDescription().getNatureIds();
            if (natures != null) {
                String[] stringArray = natures;
                int n = natures.length;
                int n2 = 0;
                while (n2 < n) {
                    String nature = stringArray[n2];
                    if (nature.equals("ro.amiq.vlogdt.VlogNature")) {
                        naturesToChose.add(nature);
                    } else if (nature.equals("ro.amiq.vhdldt.VhdlNature")) {
                        naturesToChose.add(nature);
                    } else if (nature.equals("ro.amiq.edt.enature")) {
                        naturesToChose.add(nature);
                    } else if (nature.equals("ro.amiq.slndt.slnnature")) {
                        naturesToChose.add(nature);
                    } else if (nature.equals("ro.amiq.msdldt.msdlnature")) {
                        naturesToChose.add(nature);
                    } else if (nature.equals("ro.amiq.pssdt.pssnature")) {
                        naturesToChose.add(nature);
                    }
                    ++n2;
                }
            }
            if (naturesToChose.size() == 1) {
                workingCopy.setAttribute("debug target use", (String)naturesToChose.get(0));
            } else {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DVTDebugNatureDialog dialog = new DVTDebugNatureDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Chose Debug Target Nature", workingCopy, naturesToChose, beforeNature);
                        dialog.open();
                    }
                });
            }
            String afterNature = workingCopy.getAttribute("debug target use", "NA");
            if (!naturesToChose.contains(afterNature)) {
                throw new OperationCanceledException();
            }
            if (!beforeNature.equals(afterNature)) {
                workingCopy.doSave();
            }
        }
        if (mode.equals("debug")) {
            DebugLaunchUtils.switchToDebugPerspective();
            DebugTarget target = new DebugTarget(launch);
            launch.addDebugTarget((IDebugTarget)target);
        }
    }
}

