/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTMessageDialogWithCopy;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.IDVTSuspendResume;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.model.Threads;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsManager;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.debug.core.model.variables.VariableFactory;
import ro.amiq.dvt.debug.core.model.variables.VariablesSnapshot;
import ro.amiq.dvt.debug.core.util.comm.CommManager;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.debug.ui.connection.DebugConnectionDialog;
import ro.amiq.dvt.launch.DVTDebugConnectionPortValidator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;

public class DebugTarget
extends DebugElement
implements IDVTSuspendResume,
IDebugTarget {
    private ILaunch fLaunch;
    private String fName;
    private CommManager fCommManager;
    private BreakpointsManager fBreakpointManager;
    private VariablesSnapshot fVariablesSnapshot;
    private Threads fThreads;
    private boolean fJustStarted;
    private boolean fSuspended;
    private boolean fTerminated;
    private boolean fDisconnected;
    private boolean fTryToConnect;
    private String fPort;
    private String fHost;
    private int fSyncBreakpointsPolicy;
    private String fTimeout;
    private String fTimeSendDelta;
    private boolean fE;
    private IProgressMonitor fLaunchMonitor;
    private boolean fExpressionsStarted;
    private Map<String, IWatchExpressionResult> fExpressionsMap = new HashMap<String, IWatchExpressionResult>();
    private BlockingQueue<Runnable> fExpressionsQueue = new LinkedBlockingQueue<Runnable>();
    private Job fExpressionsJob = new Job("Expression Evaluate"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                while (!DebugTarget.this.isTerminated()) {
                    DebugTarget.this.fExpressionsQueue.take().run();
                }
            }
            catch (ShutdownException shutdownException) {
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    };

    public DebugTarget(ILaunch launch) throws CoreException {
        this(launch, null, null, (IProgressMonitor)new NullProgressMonitor(), true);
    }

    public DebugTarget(ILaunch launch, String host, String port, IProgressMonitor monitor, boolean startDebug) throws CoreException {
        super(null);
        this.fLaunch = launch;
        this.fTarget = this;
        this.fLaunchMonitor = monitor;
        this.fHost = host != null ? host : launch.getLaunchConfiguration().getAttribute("debug host", "127.0.0.1");
        this.fPort = port != null ? port : launch.getLaunchConfiguration().getAttribute("debug port", "3333");
        this.fSyncBreakpointsPolicy = launch.getLaunchConfiguration().getAttribute("breakpoint use", 1);
        this.fTimeout = launch.getLaunchConfiguration().getAttribute("debug timeout", "3000");
        this.fTimeSendDelta = launch.getLaunchConfiguration().getAttribute("debug timeout delta", "30");
        if (startDebug) {
            this.startDebug();
        }
    }

    private void startDebug() throws CoreException {
        String connStartupFlags = this.getConnStartupFlags();
        if (connStartupFlags == null || !connStartupFlags.endsWith("F73765F6465627567".substring(6))) {
            return;
        }
        this.fE = connStartupFlags.equals("F655F6465627567");
        if (!DVTPlugin.getDefault().collect().cc(connStartupFlags)) {
            this.terminateInternal(true);
            return;
        }
        this.startupExpressionEvaluator();
        this.fTryToConnect = true;
        boolean commEstablished = false;
        String errStatus = "";
        while (this.fTryToConnect && !commEstablished && connStartupFlags.endsWith("F655F6465627567".substring(4))) {
            this.reqConnectionInfo(errStatus);
            if (this.fTryToConnect) {
                try {
                    this.fCommManager = new CommManager(this, Integer.parseInt(this.fTimeout), Integer.parseInt(this.fTimeSendDelta), Integer.parseInt(this.fPort), this.fHost);
                    if (!this.fCommManager.handshake(connStartupFlags, this.fLaunchMonitor)) continue;
                    commEstablished = true;
                }
                catch (Exception e) {
                    if (this.fCommManager != null) {
                        this.fCommManager.terminate();
                        this.fCommManager.closeSockets();
                    }
                    commEstablished = false;
                    errStatus = "CONNECTION FAILED: Host: " + this.fHost + " Port: " + this.fPort + " Error message: " + e.getMessage();
                }
                continue;
            }
            this.terminateInternal(true);
            commEstablished = false;
        }
        if (commEstablished) {
            this.fBreakpointManager = new BreakpointsManager(this.fCommManager, this);
            this.fThreads = new Threads(this);
            this.fVariablesSnapshot = new VariablesSnapshot();
            this.fVariablesSnapshot.takeThreadsSnapshot(this.fThreads);
            this.fVariablesSnapshot.takeExpressionsSnapshot(this.fExpressionsMap.values());
            this.fJustStarted = true;
            this.fSuspended = true;
            this.fTerminated = false;
            this.fDisconnected = false;
            DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
            this.syncBreakpoints(this.fSyncBreakpointsPolicy);
            this.fireCreationEvent();
            ObjectionManager.getInstance().clear(Objection.DEBUGGER_CONNECT);
        } else {
            this.terminateInternal(true);
        }
        ILaunchConfigurationWorkingCopy copy = this.fLaunch.getLaunchConfiguration().getWorkingCopy();
        copy.setAttribute("debug host", this.fHost);
        copy.setAttribute("debug port", this.fPort);
        copy.setAttribute("breakpoint use", this.fSyncBreakpointsPolicy);
        try {
            ILaunchConfiguration original = copy.getOriginal();
            if (original != null) {
                if (original.isReadOnly()) {
                    IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{original.getFile()}, (Object)DVTUiUtils.getActiveWorkbenchShell());
                    if (status.isOK()) {
                        copy.doSave();
                    }
                } else {
                    copy.doSave();
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getConnStartupFlags() {
        String debugTargetNature;
        block5: {
            ILaunchConfiguration launchConfiguration;
            block4: {
                try {
                    launchConfiguration = this.fLaunch.getLaunchConfiguration();
                    if (launchConfiguration != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            debugTargetNature = launchConfiguration.getAttribute("debug target use", "ro.amiq.edt.enature");
            if (debugTargetNature != null) break block5;
            return null;
        }
        return "ro.amiq.edt.enature".equals(debugTargetNature) ? "F655F6465627567" : ("ro.amiq.vlogdt.VlogNature".equals(debugTargetNature) ? "F73765F6465627567" : "F7668646C5F6465627567");
    }

    public void syncBreakpoints(int syncBreakpointsPolicy) {
        if (!this.isDisconnected()) {
            this.fBreakpointManager.syncBreakpoints(syncBreakpointsPolicy);
        }
    }

    private void restartDebug() throws CoreException {
        this.terminateInternal(false);
        this.startDebug();
        this.fireChangeEvent(512);
    }

    public void terminateInternal(boolean sendTerminateEvent) {
        String connStartupFlags = this.getConnStartupFlags();
        if (connStartupFlags != null) {
            DVTPlugin.getDefault().collect().i(connStartupFlags);
        }
        this.shutdownEpressionEvaluator();
        this.fSuspended = false;
        this.fTerminated = true;
        this.fDisconnected = true;
        if (this.fCommManager != null) {
            this.fCommManager.terminate();
        }
        if (this.fBreakpointManager != null) {
            this.fBreakpointManager.disconnect();
        }
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        if (sendTerminateEvent) {
            this.fireTerminateEvent();
        }
    }

    public void handleConnectionFailure(boolean reconnect) {
        try {
            if (!reconnect) {
                this.terminateInternal(true);
            } else {
                this.restartDebug();
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyTargetSimulationState(XMLMessage xmlMessage) {
        if (xmlMessage == null || xmlMessage.getStatus() != 0) {
            return;
        }
        String simulationState = xmlMessage.getValue();
        if ("stopped".equals(simulationState)) {
            this.fSuspended = true;
            String stopFile = xmlMessage.getAttributeValue("src_path");
            int stopLineNo = Integer.parseInt(xmlMessage.getAttributeValue("src_line"));
            int stopThreadId = Integer.parseInt(xmlMessage.getAttributeValue("thread_id"));
            this.fVariablesSnapshot.takeThreadsSnapshot(this.fThreads);
            this.fVariablesSnapshot.takeExpressionsSnapshot(this.fExpressionsMap.values());
            this.fThreads = new Threads(this, this.reqCommGetThreads());
            this.fThreads.setStepping(true);
            IBreakpoint hitBreakpoint = this.fBreakpointManager.getBreakpoint(stopLineNo, stopFile);
            int debugEvent = hitBreakpoint != null ? 16 : 8;
            this.suspended(debugEvent);
            Thread thread = this.fThreads.getThread(stopThreadId);
            if (thread != null) {
                if (hitBreakpoint instanceof ILineBreakpoint) {
                    thread.setBreakpoints(new IBreakpoint[]{hitBreakpoint});
                }
                thread.fireStepEnd(debugEvent);
            }
        } else if ("running".equals(simulationState)) {
            this.resumed(2);
        } else if ("finished".equals(simulationState)) {
            this.terminateInternal(true);
        }
    }

    public void notifyTargetSimulationError(XMLMessage type, XMLMessage initial_command) {
        if (type == null || type.getStatus() != 0) {
            return;
        }
        if (initial_command == null || initial_command.getStatus() != 0) {
            return;
        }
        String error_type = type.getValue();
        if ("finish".equals(error_type)) {
            DebugUtils.simulationFinishedPopup(this);
        } else if ("operation_not_supported".equals(error_type)) {
            Display.getDefault().asyncExec(() -> {
                DVTMessageDialogWithCopy.openError(Display.getDefault().getActiveShell(), "Error", String.valueOf(initial_command.getValue()) + " operation not supported");
                this.syncData(true);
            });
        }
    }

    public void syncData(boolean syncThreads) {
        if (!this.isSyncDataEnable()) {
            return;
        }
        int stopThreadId = this.fThreads.getActiveThread().getThreadId();
        IBreakpoint[] breakpoints = this.fThreads.getActiveThread().getBreakpoints();
        this.resumed(1);
        this.fSuspended = true;
        this.fVariablesSnapshot.takeThreadsSnapshot(this.fThreads);
        this.fVariablesSnapshot.takeExpressionsSnapshot(this.fExpressionsMap.values());
        this.fThreads = new Threads(this, this.reqCommGetThreads());
        this.fThreads.setStepping(true);
        int debugEvent = 16;
        this.suspended(debugEvent);
        Thread thread = this.fThreads.getThread(stopThreadId);
        if (thread != null) {
            thread.fireStepEnd(debugEvent);
            thread.setBreakpoints(breakpoints);
        }
    }

    public boolean isSyncDataEnable() {
        if (this.isDisconnected()) {
            return false;
        }
        return this.fThreads != null && this.fThreads.getActiveThread() != null;
    }

    public boolean isSameDebugTargetAs(ILaunch launch, String host, String port) {
        String otherName;
        if (launch == null || port == null || host == null || this.fLaunch == null || this.fPort == null || this.fHost == null) {
            return false;
        }
        if (!this.fHost.equals(host) || !this.fPort.equals(port)) {
            return false;
        }
        if (this.fLaunch.getLaunchConfiguration() == null || this.fLaunch.getLaunchConfiguration().getName() == null) {
            return false;
        }
        if (launch.getLaunchConfiguration() == null || launch.getLaunchConfiguration().getName() == null) {
            return false;
        }
        String thisName = this.fLaunch.getLaunchConfiguration().getName();
        return thisName.equals(otherName = launch.getLaunchConfiguration().getName());
    }

    @Override
    public DebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = "Debug Target (simulator) " + this.fHost + ":" + this.fPort;
        }
        return this.fName;
    }

    public IProcess getProcess() {
        return null;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.fBreakpointManager.supportsBreakpoint(breakpoint);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length > 0;
    }

    public IThread[] getThreads() throws DebugException {
        if (!this.fTerminated) {
            IThread[] someThreads = this.fThreads.getThreads();
            if (this.fJustStarted) {
                this.suspended(8);
                this.fJustStarted = false;
            }
            return someThreads;
        }
        return new IThread[0];
    }

    public Thread getActiveThread() {
        if (this.fThreads == null) {
            return null;
        }
        return this.fThreads.getActiveThread();
    }

    public Thread getThread(XMLMessage xmlThread) {
        if (this.fThreads == null) {
            return new Thread(this.fTarget, xmlThread);
        }
        int threadID = DebugUtils.parseInt(xmlThread.getAttributeValue("thread_id"));
        Thread existing = this.fThreads.getThread(threadID);
        if (existing == null) {
            return new Thread(this.fTarget, xmlThread);
        }
        existing.setThreadFromXMLMessage(xmlThread);
        return existing;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        this.terminateInternal(true);
        this.reqCommDoExit();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.resume(0);
    }

    @Override
    public void resume(int n) throws DebugException {
        this.reqCommDoResume(n);
        this.resumed(1);
    }

    private void resumed(int detail) {
        this.fireResumeEvent(detail);
        this.fThreads.fireResumeEvent(detail);
        this.fSuspended = false;
    }

    @Override
    public void restart() throws DebugException {
        this.reqCommDoRestart();
        this.resumed(1);
    }

    @Override
    public void finish() throws DebugException {
        this.reqCommDoFinish();
        this.terminateInternal(true);
    }

    public void suspend() throws DebugException {
        this.reqCommDoSuspend();
        this.suspended(32);
    }

    private void suspended(int detail) {
        this.fireSuspendEvent(detail);
        this.fThreads.fireSuspendEvent(detail);
        this.fSuspended = true;
    }

    public BreakpointsManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.isDisconnected()) {
            this.fBreakpointManager.breakpointAdded(breakpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isDisconnected()) {
            this.fBreakpointManager.breakpointRemoved(breakpoint, delta);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isDisconnected()) {
            this.fBreakpointManager.breakpointChanged(breakpoint, delta);
        }
    }

    @Override
    public boolean canDisconnect() {
        return !this.isTerminated() && !this.isDisconnected();
    }

    @Override
    public void disconnect() throws DebugException {
        this.terminateInternal(false);
        this.fTerminated = false;
        this.fireSuspendEvent(32);
    }

    @Override
    public boolean isDisconnected() {
        return this.fDisconnected;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void tSetScope(StackFrame stackFrame) {
        if (stackFrame != null) {
            int stackLevel = stackFrame.getStackLevel();
            Thread thread = stackFrame.getThread();
            if (thread != null && (thread.getCurrentStackFrame() == null || stackLevel != thread.getCurrentStackFrame().getStackLevel())) {
                this.tSetScope(thread.getThreadId(), stackLevel);
                thread.setCurrentStackLevel(stackLevel);
            }
        }
    }

    public void tSetScope(int threadId, int stackLevel) {
        this.reqCommSetScope(threadId, stackLevel);
        this.fThreads.setActiveThread(threadId);
    }

    protected void tStepOver() throws DebugException {
        this.resumed(2);
        this.reqCommDoStepOver();
    }

    protected void tStepInto() throws DebugException {
        this.resumed(1);
        this.reqCommDoStepInto();
    }

    protected void tStepReturn() throws DebugException {
        this.resumed(4);
        this.reqCommDoStepReturn();
    }

    public boolean tChangeValue(IVariable variable, String value) {
        XMLMessage xmlMessage = this.reqCommChangeVariable(variable, value.trim());
        this.fireChangeEvent(512);
        return xmlMessage != null && xmlMessage.getStatus() == 0 && !"fail".equals(xmlMessage.getValue());
    }

    public IWatchExpressionResult tGetWatchExpressionResult(String expression, IDebugElement context) {
        if (this.fTerminated) {
            return null;
        }
        StackFrame stackFrame = null;
        if (context instanceof StackFrame) {
            stackFrame = (StackFrame)context;
        } else if (context instanceof Thread) {
            stackFrame = ((Thread)context).getCurrentStackFrame();
        } else if (context instanceof DebugTarget && ((DebugTarget)context).getActiveThread() != null) {
            stackFrame = ((DebugTarget)context).getActiveThread().getCurrentStackFrame();
        }
        if (stackFrame == null) {
            return null;
        }
        XMLMessage xmlMessage = this.reqCommGetExpression(expression, stackFrame);
        return VariableFactory.createWatchExpressionResultFromXMLMessage(stackFrame, xmlMessage);
    }

    public boolean variableHasChanged(Variable variable) {
        return this.fVariablesSnapshot.hasValueChanged(variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage reqCommGetThreads() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("get all threads");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage reqCommGetFrames(int threadId) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeThreadStackCommand(threadId);
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommSetScope(int threadId, int stackLevel) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeSetScopeCommand(threadId, stackLevel);
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoResume(int n) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeResumeNCommand(n);
            this.fCommManager.sendRequest(command);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoRestart() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("restart");
            this.fCommManager.sendRequest(command);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoFinish() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("finish");
            this.fCommManager.sendRequest(command);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoSuspend() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("suspend");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoExit() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("exit");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoStepOver() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("step over");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoStepInto() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("step into");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommDoStepReturn() {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("step return");
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage reqCommGetVariable(IVariable variable) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeGetVariableCommand(variable);
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage reqCommGetExpression(String expression, StackFrame context) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeGetExpressionCommand(expression, context);
            return this.fCommManager.executeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLMessage reqCommChangeVariable(IVariable variable, String value) {
        DebugTarget debugTarget = this;
        synchronized (debugTarget) {
            XMLMessage command = XMLMessageFactory.getInstance().makeChangeValueCommand(((Variable)variable).getPath(), value);
            return this.fCommManager.executeCommand(command);
        }
    }

    private void reqConnectionInfo(final String errStatus) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DVTDebugConnectionPortValidator validator = new DVTDebugConnectionPortValidator();
                DebugConnectionDialog dialog = new DebugConnectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Connection Startup", DebugTarget.this.fHost, DebugTarget.this.fPort, DebugTarget.this.fSyncBreakpointsPolicy, errStatus, validator);
                if (TestHelper.isTestMode()) {
                    DebugTarget.this.fTryToConnect = true;
                    DebugTarget.this.fSyncBreakpointsPolicy = TestHelper.fSyncBreakpointsPolicy;
                    DebugTarget.this.fPort = DebugTarget.this.fPort;
                    DebugTarget.this.fHost = DebugTarget.this.fHost;
                    TestHelper.delay(500L);
                } else {
                    dialog.open();
                    DebugTarget.this.fTryToConnect = dialog.getReturnCode() == 0;
                    DebugTarget.this.fSyncBreakpointsPolicy = dialog.getSyncBreakpointsPolicy();
                    DebugTarget.this.fPort = dialog.getPort();
                    DebugTarget.this.fHost = dialog.getHost();
                }
            }
        });
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DEBUG_TARGET);
    }

    public void startupExpressionEvaluator() {
        try {
            if (this.fExpressionsStarted) {
                return;
            }
            this.fExpressionsStarted = true;
            this.fExpressionsQueue.clear();
            this.fExpressionsJob.setPriority(10);
            this.fExpressionsJob.setSystem(true);
            this.fExpressionsJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void shutdownEpressionEvaluator() {
        try {
            if (!this.fExpressionsStarted) {
                return;
            }
            this.fExpressionsStarted = false;
            this.fExpressionsQueue.clear();
            this.fExpressionsQueue.add(new Runnable(){

                @Override
                public void run() {
                    throw new ShutdownException();
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void cleanExpressionsLookup() {
        this.fExpressionsMap.clear();
    }

    public void getWatchExpressionResult(final StackFrame stackFrame, final IWatchExpressionListener listener, final String expression) {
        if (this.fExpressionsMap.containsKey(expression)) {
            IWatchExpressionResult watchExpressionResult = this.fExpressionsMap.get(expression);
            listener.watchEvaluationFinished(watchExpressionResult);
            return;
        }
        this.fExpressionsQueue.add(new Runnable(){

            @Override
            public void run() {
                DebugTarget.this.tSetScope(stackFrame);
                IWatchExpressionResult watchExpressionResult = DebugTarget.this.tGetWatchExpressionResult(expression, stackFrame);
                DebugTarget.this.fExpressionsMap.put(expression, watchExpressionResult);
                listener.watchEvaluationFinished(watchExpressionResult);
            }
        });
    }

    public boolean isE() {
        return this.fE;
    }

    private static class ShutdownException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private ShutdownException() {
        }
    }
}

