/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.ui.util.RestartDialog;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTSystemVariables;

public final class DebugUtils {
    public static boolean doSyso() {
        return DVTSystemVariables.isTrue("DVT_SHOW_DBG_MSGS");
    }

    public static void syso(String message) {
        if (DebugUtils.doSyso()) {
            TestHelper.out.println(message);
        }
    }

    public static void printXML(String xmlString) {
        if (!DebugUtils.doSyso()) {
            return;
        }
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = df.newDocumentBuilder();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes());
            Document document = documentBuilder.parse(inputStream);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            serializer.transform(new DOMSource(document), new StreamResult(TestHelper.out));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void printStack() {
        if (!DebugUtils.doSyso()) {
            return;
        }
        try {
            throw new Exception();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
    }

    public static IBreakpoint[] getAllEBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("ro.amiq.dvt.debug");
    }

    public static IFile getWorkspaceFilesFromFilename(String absolutePath) {
        try {
            IProject[] projects;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.vhdldt.VhdlNature") || project.hasNature("ro.amiq.slndt.slnnature")) && (file = DVTFileUtils.getInstance().findProjectFile(project, absolutePath)) != null) {
                    return file;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static String getLine(File file, int line) {
        if (line >= 1) {
            Scanner scanner = null;
            try {
                scanner = new Scanner(file);
            }
            catch (FileNotFoundException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (scanner == null) {
                return "";
            }
            int i = 0;
            String s = null;
            while (scanner.hasNextLine() && i < line) {
                s = scanner.nextLine();
                ++i;
            }
            if (s == null) {
                scanner.close();
                return "";
            }
            s = s.trim();
            scanner.close();
            return s;
        }
        return "";
    }

    public static int parseInt(String value) {
        block3: {
            try {
                if (value != null) break block3;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return Integer.parseInt(value);
    }

    public static void simulationFinishedPopup(DebugTarget debugTarget) {
        Display.getDefault().syncExec(() -> {
            int n = new RestartDialog(debugTarget).open();
        });
    }
}

