/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.IDVTSuspendResume;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.model.variables.Value;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.debug.core.model.variables.VariableFactory;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.utils.DVTStringUtil;

public class StackFrame
extends DebugElement
implements IDVTSuspendResume,
IStackFrame {
    private Thread fThread;
    private String fName;
    private String fSourcePath;
    private int fSourceLine;
    private int fStackLevel;
    private Variable fRootVariable;

    public StackFrame(Thread thread, String name) {
        super((DebugTarget)thread.getDebugTarget());
        this.fThread = thread;
        this.fName = name;
        this.fRootVariable = VariableFactory.createRootVariable(this);
    }

    protected StackFrame(Thread thread, XMLMessage xmlMessage) {
        super((DebugTarget)thread.getDebugTarget());
        boolean isActive;
        this.fThread = thread;
        this.fName = xmlMessage.getAttributeValue("name");
        this.fSourcePath = xmlMessage.getAttributeValue("src_path");
        this.fSourcePath = this.fSourcePath == null ? "N/A" : new Path(this.fSourcePath).toOSString();
        this.fSourceLine = DebugUtils.parseInt(xmlMessage.getAttributeValue("src_line"));
        this.fStackLevel = DebugUtils.parseInt(xmlMessage.getAttributeValue("stack_level"));
        boolean bl = isActive = DebugUtils.parseInt(xmlMessage.getAttributeValue("is_active")) == 1;
        if (isActive) {
            this.fThread.setCurrentStackLevel(this.fStackLevel);
        }
        this.fRootVariable = VariableFactory.createRootVariable(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StackFrame) {
            return this == obj || this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return DVTStringUtil.appendString(this.fName, "@", this.fSourceLine, "@", this.fSourcePath, "@", this.fStackLevel, "@", this.fThread.getThreadId()).hashCode();
    }

    public Thread getThread() {
        return this.fThread;
    }

    public int getStackLevel() {
        return this.fStackLevel;
    }

    public String getName() {
        return this.fName;
    }

    public String getSourceName() {
        return this.fSourcePath;
    }

    public int getSourceLine() {
        return this.fSourceLine;
    }

    public int getLineNumber() throws DebugException {
        ((DebugTarget)this.getDebugTarget()).tSetScope(this);
        return this.fSourceLine;
    }

    public boolean hasVariables() throws DebugException {
        return this.fThread.isSuspended();
    }

    public void setDirty() {
        this.fTarget.cleanExpressionsLookup();
        this.fRootVariable = VariableFactory.createRootVariable(this);
    }

    public Variable[] getVariables() throws DebugException {
        Variable[] variables = ((Value)this.fRootVariable.getValue()).getVariables();
        return variables == null ? new Variable[]{} : variables;
    }

    public Variable getRootVar() {
        return this.fRootVariable;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    @Override
    public void resume(int n) throws DebugException {
        this.getThread().resume(n);
    }

    @Override
    public void restart() throws DebugException {
        this.getThread().restart();
    }

    @Override
    public void finish() throws DebugException {
        this.getThread().finish();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    @Override
    public Image getImage() {
        return null;
    }
}

