/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import java.util.List;
import org.eclipse.debug.core.model.IStackFrame;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;

public class StackFrames
extends DebugElement {
    private final Object fSyncObject = new Object();
    private StackFrame[] fStackFrames;
    private Thread fThread;
    private boolean fIsDirty;

    public StackFrames(DebugTarget target, Thread thread) {
        super(target);
        this.fThread = thread;
        this.fIsDirty = true;
        this.fStackFrames = thread.getStackFrames() != null ? (StackFrame[])thread.getStackFrames() : new StackFrame[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackFrame[] getStackFrames() {
        Object object = this.fSyncObject;
        synchronized (object) {
            if (this.fIsDirty) {
                this.fetchFromTarget();
            }
            return this.fStackFrames;
        }
    }

    public void setDirty() {
        if (this.fStackFrames == null || this.fStackFrames.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.fStackFrames.length) {
            this.fStackFrames[i].setDirty();
            ++i;
        }
    }

    private void fetchFromTarget() {
        XMLMessage xmlMessage = this.fTarget.reqCommGetFrames(this.fThread.getThreadId());
        this.setFramesFromXMLMessage(xmlMessage);
        this.fireChangeEvent(512);
    }

    private void setFramesFromXMLMessage(XMLMessage xmlMessage) {
        this.fIsDirty = false;
        this.fStackFrames = this.createFramesFromXMLMessage(xmlMessage);
    }

    private StackFrame[] createFramesFromXMLMessage(XMLMessage xmlMessage) {
        StackFrame[] result = null;
        if (xmlMessage.getStatus() != 0) {
            result = new StackFrame[]{this.createErrorStackFrame(this.fThread, xmlMessage.getStatus())};
        } else if ("fail".equals(xmlMessage.getValue())) {
            result = new StackFrame[]{this.createErrorStackFrame(this.fThread, 4)};
        } else {
            result = new StackFrame[]{};
            List<XMLMessage> xmlFames = xmlMessage.getChildren("frame");
            if (xmlFames != null) {
                int nofFrames = xmlFames.size();
                result = new StackFrame[nofFrames];
                IStackFrame[] existingStackFrames = this.fThread.getStackFrames();
                int i = 0;
                while (i < nofFrames) {
                    block8: {
                        StackFrame newStackFrame = new StackFrame(this.fThread, xmlFames.get(i));
                        int j = 0;
                        while (j < existingStackFrames.length) {
                            if (existingStackFrames[j] != null && existingStackFrames[j].equals(newStackFrame)) {
                                result[i] = (StackFrame)existingStackFrames[j];
                                break block8;
                            }
                            ++j;
                        }
                        result[i] = newStackFrame;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private StackFrame createErrorStackFrame(Thread thread, int errorKind) {
        if (errorKind == 1) {
            return new StackFrame(thread, "*** ERROR: I/O communication error.");
        }
        if (errorKind == 2) {
            return new StackFrame(thread, "*** ERROR: Message decoding error.");
        }
        if (errorKind == 3) {
            return new StackFrame(thread, "*** ERROR: Connection timeout.");
        }
        if (errorKind == 4) {
            return new StackFrame(thread, "*** ERROR: Target fail.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackFrame[] getExistingStackFrames() {
        Object object = this.fSyncObject;
        synchronized (object) {
            return this.fStackFrames;
        }
    }
}

