/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.IDVTSuspendResume;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.StackFrames;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;

public class Thread
extends DebugElement
implements IDVTSuspendResume,
IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping;
    private boolean fCanStepInto;
    private boolean fCanStepReturn;
    private String fName;
    private int fThreadId;
    private boolean fIsActive;
    private int fCurrentStackLevel;
    private StackFrames fStackFrames;
    private int fSrcLine;
    private String fSrcPath;

    protected Thread(DebugTarget target, String name) {
        super(target);
        this.fStepping = true;
        this.fCanStepInto = true;
        this.fCanStepReturn = true;
        this.fName = name;
        this.fCurrentStackLevel = -1;
        this.fStackFrames = new StackFrames(target, this);
    }

    protected Thread(DebugTarget target, XMLMessage xmlMessage) {
        super(target);
        this.setThreadFromXMLMessage(xmlMessage);
    }

    protected void setThreadFromXMLMessage(XMLMessage xmlMessage) {
        this.fStepping = true;
        this.fCanStepInto = true;
        this.fCanStepReturn = true;
        this.fCurrentStackLevel = -1;
        this.fStackFrames = new StackFrames(this.fTarget, this);
        this.fName = xmlMessage.getAttributeValue("name");
        this.fThreadId = DebugUtils.parseInt(xmlMessage.getAttributeValue("thread_id"));
        this.fIsActive = DebugUtils.parseInt(xmlMessage.getAttributeValue("is_active")) == 1;
        this.fSrcLine = DebugUtils.parseInt(xmlMessage.getAttributeValue("src_line"));
        this.fSrcPath = xmlMessage.getAttributeValue("src_path");
        if (this.fIsActive) {
            this.getStackFrames();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Thread) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.fThreadId;
    }

    @Override
    public void fireStepEnd(int detail) {
        if (this.fStackFrames != null) {
            this.fStackFrames.setDirty();
        }
        super.fireStepEnd(detail);
    }

    public String getName() {
        return String.valueOf(this.fName) + (this.fIsActive ? " [ACTIVE]" : "");
    }

    public int getThreadId() {
        return this.fThreadId;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setActive(boolean active) {
        this.fIsActive = active;
    }

    public IStackFrame[] getStackFrames() {
        if (this.fStackFrames == null) {
            return null;
        }
        if (this.isSuspended() && this.isActive()) {
            return this.fStackFrames.getStackFrames();
        }
        return this.fStackFrames.getExistingStackFrames();
    }

    public StackFrame[] getExistingStackFrames() {
        return this.fStackFrames.getExistingStackFrames();
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended() && this.fIsActive;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.getCurrentStackFrame();
    }

    public void setCurrentStackLevel(int currentStackLevel) {
        this.fCurrentStackLevel = currentStackLevel;
    }

    public StackFrame getCurrentStackFrame() {
        StackFrame[] frames = this.fStackFrames.getExistingStackFrames();
        if (frames != null) {
            if (this.fCurrentStackLevel == -1 && frames.length > 0) {
                return frames[0];
            }
            int i = 0;
            while (i < frames.length) {
                if (frames[i].getStackLevel() == this.fCurrentStackLevel) {
                    return frames[i];
                }
                ++i;
            }
        }
        return null;
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean isTerminated() {
        return this.fTarget.isTerminated();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fTarget.terminate();
    }

    public boolean isSuspended() {
        return this.fTarget.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public void suspend() throws DebugException {
        this.fTarget.suspend();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public void resume() throws DebugException {
        this.fTarget.resume();
    }

    @Override
    public void resume(int n) throws DebugException {
        this.fTarget.resume(n);
    }

    @Override
    public void restart() throws DebugException {
        this.fTarget.restart();
    }

    @Override
    public void finish() throws DebugException {
        this.fTarget.finish();
    }

    public boolean canStepInto() {
        return this.fCanStepInto;
    }

    public boolean canStepOver() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.fCanStepReturn;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    public void stepInto() throws DebugException {
        this.fTarget.tStepInto();
    }

    public void stepOver() throws DebugException {
        this.fTarget.tStepOver();
    }

    public void stepReturn() throws DebugException {
        this.fTarget.tStepReturn();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public int getSrcLine() {
        return this.fSrcLine;
    }

    public String getSrcPath() {
        return this.fSrcPath;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ISourceDisplay.class) {
            return new ISourceDisplay(){

                public void displaySource(Object element, IWorkbenchPage page, boolean force) {
                    SourceLookupFacility.getDefault().displaySource((Object)new StackFrame(Thread.this, "dummy"){

                        @Override
                        public int getLineNumber() throws DebugException {
                            return Thread.this.getSrcLine();
                        }

                        @Override
                        public String getSourceName() {
                            return Thread.this.getSrcPath();
                        }
                    }, page, force);
                }
            };
        }
        return super.getAdapter(adapter);
    }
}

