/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;

public class Threads
extends DebugElement {
    private final Object fSyncObject = new Object();
    private Thread[] fThreads;
    private boolean fIsRunning;
    private boolean fIsDirty;

    public Threads(DebugTarget target) {
        super(target);
        this.fIsDirty = true;
        this.fIsRunning = false;
        this.fThreads = new Thread[0];
    }

    public Threads(DebugTarget target, XMLMessage xmlMessage) {
        super(target);
        this.fIsDirty = false;
        this.fIsRunning = false;
        this.setThreadsFromXMLMessage(xmlMessage);
    }

    public boolean hasThreads() {
        Thread[] threads = this.getThreads();
        return threads != null && threads.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getThreads() {
        Object object = this.fSyncObject;
        synchronized (object) {
            if (this.fIsDirty) {
                this.fetchFromTarget();
            }
            return this.fThreads;
        }
    }

    private void fetchFromTarget() {
        XMLMessage threadsXMLMessage = this.fTarget.reqCommGetThreads();
        this.setThreadsFromXMLMessage(threadsXMLMessage);
        this.fireChangeEvent(512);
    }

    private void setThreadsFromXMLMessage(XMLMessage xmlMessage) {
        this.fIsDirty = false;
        this.fIsRunning = true;
        this.fThreads = this.createThreadsFromXMLMessage(xmlMessage);
    }

    private Thread[] createThreadsFromXMLMessage(XMLMessage xmlMessage) {
        Thread[] result = null;
        if (xmlMessage.getStatus() != 0) {
            result = new Thread[]{this.createErrorThread(this.fTarget, xmlMessage.getStatus())};
        } else if ("fail".equals(xmlMessage.getValue())) {
            result = new Thread[]{this.createErrorThread(this.fTarget, 4)};
        } else {
            result = new Thread[]{};
            List<XMLMessage> xmlThreads = xmlMessage.getChildren("thread");
            if (xmlThreads != null) {
                ArrayList<Thread> threads = new ArrayList<Thread>(xmlThreads.size());
                int i = 0;
                while (i < xmlThreads.size()) {
                    XMLMessage xmlThread = xmlThreads.get(i);
                    Thread newThread = this.fTarget.getThread(xmlThread);
                    if (newThread.isActive()) {
                        threads.add(0, newThread);
                    } else {
                        threads.add(newThread);
                    }
                    ++i;
                }
                result = new Thread[xmlThreads.size()];
                threads.toArray(result);
            }
        }
        return result;
    }

    private Thread createErrorThread(DebugTarget target, int errorKind) {
        if (errorKind == 1) {
            return new Thread(target, "*** ERROR: I/O communication error.");
        }
        if (errorKind == 2) {
            return new Thread(target, "*** ERROR: Message decoding error.");
        }
        if (errorKind == 3) {
            return new Thread(target, "*** ERROR: Connection timeout.");
        }
        if (errorKind == 4) {
            return new Thread(target, "*** ERROR: Target fail.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getExistingThreads() {
        Object object = this.fSyncObject;
        synchronized (object) {
            return this.fThreads;
        }
    }

    public Thread getThread(int threadId) {
        Thread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (threads[i].getThreadId() == threadId) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    public Thread getActiveThread() {
        Thread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (threads[i].isActive()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public void fireSuspendEvent(int detail) {
        Thread[] threads = this.getThreads();
        if (this.fIsRunning) {
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isActive()) {
                    threads[i].fireSuspendEvent(detail);
                }
                threads[i].setStepping(true);
                this.fIsRunning = false;
                ++i;
            }
        }
    }

    @Override
    public void fireResumeEvent(int detail) {
        Thread[] threads = this.getThreads();
        this.fIsRunning = true;
        int i = 0;
        while (i < threads.length) {
            threads[i].setStepping(false);
            if (threads[i].isActive()) {
                threads[i].fireResumeEvent(detail);
            }
            ++i;
        }
    }

    public void setActiveThread(int threadId) {
        Thread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            threads[i].setActive(false);
            if (threads[i].getThreadId() == threadId) {
                threads[i].setActive(true);
            }
            ++i;
        }
    }

    public void setStepping(boolean s) {
        Thread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (threads[i] != null) {
                threads[i].setStepping(s);
            }
            ++i;
        }
    }
}

