/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class BaseBreakpoint
extends LineBreakpoint {
    public static final String BREAKPOINT_MARKER_TYPE_WATCHPOINT = "ro.amiq.dvt.debug.core.watchpointMarkerType";
    public static final String BREAKPOINT_MARKER_TYPE_LINE = "ro.amiq.dvt.debug.core.lineBreakpointMarkerType";
    public static final String BREAKPOINT_MARKER_ATTR_TARGET_FAILED = "target_failed";
    public static final String BREAKPOINT_MARKER_ATTR_TARGET_FAILED_ERR_MSG = "target_failed_err_msg";
    public static final String HIT_COUNT = "hit_count";
    private int currentSessionHitCount = -1;
    public static final String TRIGGERPOINT = "org.eclipse.debug.core.triggerpoint";
    public static final String BREAKPOINT_MARKER_ATTR_COMMAND = "command";
    public static final String BREAKPOINT_MARKER_ATTR_EVALUATE = "evaluate";
    private String fTargetBreakpointID;
    private boolean fTargetEnabled;
    private boolean fTargetFailed;
    private boolean fShouldDelete;

    public String getModelIdentifier() {
        return "ro.amiq.dvt.debug";
    }

    public BaseBreakpoint() {
        this.init();
    }

    public void init() {
        this.fTargetFailed = false;
        this.setTargetBreakpointID(null);
    }

    public String getTargetBreakpointID() {
        return this.fTargetBreakpointID;
    }

    public void setTargetBreakpointID(String targetBreakpointID) {
        this.fTargetBreakpointID = targetBreakpointID;
        IMarker marker = this.getMarker();
        if (marker != null) {
            try {
                marker.setAttribute("bp_id", (Object)this.fTargetBreakpointID);
            }
            catch (CoreException coreException) {}
        }
    }

    public void setTargetEnabled(boolean targetEnabled) {
        this.fTargetEnabled = targetEnabled;
    }

    public boolean getTargetEnabled() {
        return this.fTargetEnabled;
    }

    public void handleBreakpointXMLMessage(XMLMessage breakpointXMLMessage) {
        try {
            String breakpointCommand = breakpointXMLMessage.getAttributeValue(BREAKPOINT_MARKER_ATTR_COMMAND);
            String breakpointID = breakpointXMLMessage.getAttributeValue("bp_id");
            this.setTargetBreakpointID(breakpointID);
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            String breakpointEnabled = breakpointXMLMessage.getAttributeValue("is_enabled");
            if ("1".equals(breakpointEnabled)) {
                this.setTargetEnabled(true);
                if (!this.isEnabled()) {
                    this.setEnabled(true);
                }
            } else {
                this.setTargetEnabled(false);
                if (breakpointManager.isEnabled() && this.isEnabled()) {
                    this.setEnabled(false);
                }
            }
            this.setCommand(breakpointCommand);
            this.setTargetFailed(false, "");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setTargetFailed(boolean targetFailed, String errorMessage) {
        this.fTargetFailed = targetFailed;
        try {
            IMarker marker = this.getMarker();
            if (marker != null) {
                marker.setAttribute(BREAKPOINT_MARKER_ATTR_TARGET_FAILED, targetFailed);
                marker.setAttribute(BREAKPOINT_MARKER_ATTR_TARGET_FAILED_ERR_MSG, (Object)(errorMessage == null ? "" : errorMessage));
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean getTargetFailed() {
        return this.fTargetFailed;
    }

    public String getCommand() {
        if (this.getMarker() != null) {
            return this.getMarker().getAttribute(BREAKPOINT_MARKER_ATTR_COMMAND, "");
        }
        return null;
    }

    public void setCommand(String command) {
        try {
            if (this.getMarker() != null) {
                this.getMarker().setAttribute(BREAKPOINT_MARKER_ATTR_COMMAND, (Object)command);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getEvaluate() {
        if (this.getMarker() != null) {
            return this.getMarker().getAttribute(BREAKPOINT_MARKER_ATTR_EVALUATE, "");
        }
        return null;
    }

    public void setEvaluate(String command) {
        try {
            if (this.getMarker() != null) {
                this.getMarker().setAttribute(BREAKPOINT_MARKER_ATTR_EVALUATE, (Object)command);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void enabled() {
    }

    public void disabled() {
    }

    public void removed() {
    }

    public boolean equals(XMLMessage breakpointXMLMessage) {
        int srcLine;
        block31: {
            IPath fileCandidate;
            block17: {
                String triggerPoint;
                block30: {
                    block29: {
                        String hitCount;
                        block28: {
                            block27: {
                                String conditionSuspendOnTrue;
                                block26: {
                                    block25: {
                                        String conditionEnabled;
                                        block24: {
                                            block23: {
                                                String evaluate;
                                                block22: {
                                                    block21: {
                                                        String condition;
                                                        block20: {
                                                            block19: {
                                                                String command;
                                                                block18: {
                                                                    try {
                                                                        String srcPath = breakpointXMLMessage.getAttributeValue("src_path");
                                                                        srcLine = Integer.parseInt(breakpointXMLMessage.getAttributeValue("src_line"));
                                                                        String kind = breakpointXMLMessage.getAttributeValue("kind");
                                                                        command = breakpointXMLMessage.getAttributeValue(BREAKPOINT_MARKER_ATTR_COMMAND);
                                                                        evaluate = breakpointXMLMessage.getAttributeValue(BREAKPOINT_MARKER_ATTR_EVALUATE);
                                                                        condition = breakpointXMLMessage.getAttributeValue("condition");
                                                                        conditionEnabled = breakpointXMLMessage.getAttributeValue("condition_enabled");
                                                                        conditionSuspendOnTrue = breakpointXMLMessage.getAttributeValue("condition_suspend_on_true");
                                                                        hitCount = breakpointXMLMessage.getAttributeValue(HIT_COUNT);
                                                                        triggerPoint = breakpointXMLMessage.getAttributeValue("triggerpoint");
                                                                        fileCandidate = Path.fromOSString((String)srcPath);
                                                                        if (!fileCandidate.isEmpty() || kind == null || !kind.equals("b_any")) break block17;
                                                                        if (command != null) break block18;
                                                                        return this.getCommand() == null || this.getCommand().isEmpty();
                                                                    }
                                                                    catch (CoreException e) {
                                                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                                                        return false;
                                                                    }
                                                                }
                                                                if (command.equals(this.getCommand())) break block19;
                                                                return false;
                                                            }
                                                            if (condition != null) break block20;
                                                            return this.getCondition() == null || this.getCondition().isEmpty();
                                                        }
                                                        if (condition.equals(this.getCondition())) break block21;
                                                        return false;
                                                    }
                                                    if (evaluate != null) break block22;
                                                    return this.getEvaluate() == null || this.getEvaluate().isEmpty();
                                                }
                                                if (evaluate.equals(this.getEvaluate())) break block23;
                                                return false;
                                            }
                                            if (conditionEnabled != null) break block24;
                                            return !this.isConditionEnabled();
                                        }
                                        if (conditionEnabled.equals(String.valueOf(this.isConditionEnabled()))) break block25;
                                        return false;
                                    }
                                    if (conditionSuspendOnTrue != null) break block26;
                                    return !this.isConditionSuspendOnTrue();
                                }
                                if (conditionSuspendOnTrue.equals(String.valueOf(this.isConditionSuspendOnTrue()))) break block27;
                                return false;
                            }
                            if (hitCount != null) break block28;
                            return this.getHitCount() == -1;
                        }
                        if (hitCount.equals(String.valueOf(this.getHitCount()))) break block29;
                        return false;
                    }
                    if (triggerPoint != null) break block30;
                    return !this.isTriggerPoint();
                }
                return triggerPoint.equals(String.valueOf(this.isTriggerPoint()));
            }
            IPath fileMarker = this.getMarker().getResource().getLocation();
            if (fileCandidate.equals((Object)fileMarker) && this.getMarker().exists()) break block31;
            return false;
        }
        int lineMarker = (Integer)this.getMarker().getAttribute("lineNumber");
        return lineMarker == srcLine;
    }

    public abstract XMLMessage toXMLMessage();

    public abstract Image getImage();

    public String getText() {
        IMarker marker = this.getMarker();
        if (marker != null) {
            String context;
            String result = marker.getAttribute(BREAKPOINT_MARKER_ATTR_COMMAND, "");
            if (result.isEmpty()) {
                result = this.getSpecificText();
            }
            if (this.hasCondition()) {
                result = String.valueOf(result) + " [if " + this.getCondition() + "] ";
            }
            boolean targetFailed = marker.getAttribute(BREAKPOINT_MARKER_ATTR_TARGET_FAILED, false);
            String targetFailedErrMsg = marker.getAttribute(BREAKPOINT_MARKER_ATTR_TARGET_FAILED_ERR_MSG, "");
            if (targetFailed) {
                result = "Failed to set breakpoint: " + targetFailedErrMsg + "! " + result;
            }
            if ((context = this.getSourceContext()) != null && !"".equals(context)) {
                result = String.valueOf(result) + " - " + context;
            }
            return result;
        }
        return "N/A";
    }

    protected String getSpecificText() {
        if (this.getMarker() != null) {
            return this.getMarker().getAttribute("message", "N/A");
        }
        return null;
    }

    protected String getSourceContext() {
        return null;
    }

    public boolean shouldDelete() {
        return this.fShouldDelete;
    }

    public void setShouldDelete() {
        this.fShouldDelete = true;
    }

    public String getCondition() {
        return null;
    }

    public void setConditionEnabled(boolean condition) {
    }

    public boolean isConditionEnabled() throws CoreException {
        return false;
    }

    public boolean hasCondition() {
        return false;
    }

    public int getHitCount() throws DebugException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public boolean handleHitCount() {
        block5: {
            try {
                if (this.currentSessionHitCount < 0) {
                    this.currentSessionHitCount = this.getHitCount();
                }
                if (this.currentSessionHitCount <= 0) break block5;
                --this.currentSessionHitCount;
                if (this.isHitCountDisabled()) {
                    this.setEnabled(false);
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return this.isHitCountDisabled();
    }

    public void setHitCount(int hitCount) {
        try {
            if (hitCount != this.getHitCount()) {
                if (!this.isEnabled() && hitCount > -1) {
                    this.ensureMarker().setAttribute("org.eclipse.debug.core.enabled", true);
                }
                this.ensureMarker().setAttribute(HIT_COUNT, hitCount);
                this.currentSessionHitCount = hitCount;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void restoreHitCount() throws CoreException {
        if (this.isHitCountDisabled()) {
            this.setEnabled(true);
        }
        this.currentSessionHitCount = -1;
    }

    private boolean isHitCountDisabled() {
        return this.currentSessionHitCount == 0;
    }

    public boolean isTriggerPoint() throws DebugException {
        return this.ensureMarker().getAttribute(TRIGGERPOINT, false);
    }

    public void setTriggerPoint(boolean triggerPoint) throws CoreException {
        if (this.isTriggerPoint() != triggerPoint) {
            this.setAttribute(TRIGGERPOINT, triggerPoint);
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            try {
                if (triggerPoint) {
                    Method addTriggerPointM = manager.getClass().getMethod("addTriggerPoint", IBreakpoint.class);
                    addTriggerPointM.invoke((Object)manager, new Object[]{this});
                } else {
                    Method removeTriggerPointM = manager.getClass().getMethod("removeTriggerPoint", IBreakpoint.class);
                    removeTriggerPointM.invoke((Object)manager, new Object[]{this});
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public boolean isConditionSuspendOnTrue() throws DebugException {
        return true;
    }

    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
    }
}

