/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.util.comm.CommManager;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.AccumulatingErrorDialog;
import ro.amiq.dvt.utils.DVTFileUtils;

public class BreakpointsManager
implements IBreakpointListener {
    private CommManager fCommManager;
    private XMLMessageFactory fMessageCreator = XMLMessageFactory.getInstance();
    private DebugTarget fDebugTarget;
    private final Object fSyncAddBreakpoint = new Object();

    public BreakpointsManager(CommManager commManager, DebugTarget debugTarget) {
        this.fCommManager = commManager;
        this.fDebugTarget = debugTarget;
        this.connect();
    }

    public void connect() {
    }

    public void disconnect() {
        this.initEclipseBreakpoints();
    }

    public void syncBreakpoints(int syncBreakpointsPolicy) {
        this.initEclipseBreakpoints();
        this.fDebugTarget.reqCommGetThreads();
        int waitTimeMillis = 1000;
        String envValue = System.getenv("DVT_DEBUG_BPDELAY");
        if (envValue != null) {
            try {
                waitTimeMillis = Integer.parseInt(envValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        TestHelper.delay(waitTimeMillis);
        switch (syncBreakpointsPolicy) {
            case 0: {
                this.useTargetBreakpoints();
                break;
            }
            case 1: {
                this.useEclipseBreakpoints();
                break;
            }
            case 2: {
                this.mergeBreakpoints();
            }
        }
    }

    private void initEclipseBreakpoints() {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugUtils.getAllEBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof BaseBreakpoint) {
                ((BaseBreakpoint)breakpoint).init();
            }
            ++n2;
        }
    }

    private void useTargetBreakpoints() {
        IBreakpoint[] breakpoints = DebugUtils.getAllEBreakpoints();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                breakpoint.delete();
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
        DebugPlugin.getDefault().getBreakpointManager().setEnabled(true);
        XMLMessage breakInfo = this.targetGetAllBreakpoints();
        if (breakInfo == null) {
            return;
        }
        List<XMLMessage> breakpointXMLMessages = breakInfo.getChildren("breakpoint");
        if (breakpointXMLMessages != null) {
            for (XMLMessage breakpointXMLMessage : breakpointXMLMessages) {
                this.createBreakpointFromTarget(breakpointXMLMessage);
            }
        }
    }

    private void useEclipseBreakpoints() {
        this.targetDeleteAllBreakpoints();
        IBreakpoint[] allEclipseBreakpoints = DebugUtils.getAllEBreakpoints();
        this.addBreakpoints(allEclipseBreakpoints);
    }

    private void mergeBreakpoints() {
        IBreakpoint[] allEclipseBreakpoints = DebugUtils.getAllEBreakpoints();
        DebugPlugin.getDefault().getBreakpointManager().setEnabled(true);
        HashSet<IBreakpoint> breakpointsToRemove = new HashSet<IBreakpoint>();
        XMLMessage breakInfo = this.targetGetAllBreakpoints();
        if (breakInfo == null) {
            return;
        }
        List<XMLMessage> breakpointXMLMessages = breakInfo.getChildren("breakpoint");
        if (breakpointXMLMessages != null) {
            for (XMLMessage breakpointXMLMessage : breakpointXMLMessages) {
                this.createBreakpointFromTarget(breakpointXMLMessage);
                IBreakpoint[] iBreakpointArray = allEclipseBreakpoints;
                int n = allEclipseBreakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseBreakpoint breakBase;
                    IBreakpoint breakpoint = iBreakpointArray[n2];
                    if (breakpoint instanceof BaseBreakpoint && (breakBase = (BaseBreakpoint)breakpoint).equals(breakpointXMLMessage)) {
                        breakpointsToRemove.add(breakpoint);
                        try {
                            breakpoint.delete();
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
            }
        }
        IBreakpoint[] iBreakpointArray = allEclipseBreakpoints;
        int n = allEclipseBreakpoints.length;
        int n3 = 0;
        while (n3 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n3];
            if (!breakpointsToRemove.contains(breakpoint)) {
                this.addBreakpoint(breakpoint);
            }
            ++n3;
        }
    }

    private void addBreakpoints(IBreakpoint[] breakpoints) {
        if (breakpoints == null) {
            return;
        }
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            this.addBreakpoint(breakpoint);
            ++n2;
        }
    }

    private void addBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint == null) {
            return;
        }
        if (breakpoint instanceof BaseBreakpoint) {
            BaseBreakpoint breakBase = (BaseBreakpoint)breakpoint;
            this.breakpointAdded((IBreakpoint)breakBase);
            if (breakBase.shouldDelete()) {
                try {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakBase, true);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    private void createBreakpointFromTarget(XMLMessage xmlMessage) {
        if (xmlMessage == null) {
            return;
        }
        String kind = xmlMessage.getAttributeValue("kind");
        String command = xmlMessage.getAttributeValue("command");
        String condition = xmlMessage.getAttributeValue("condition");
        String evaluate = xmlMessage.getAttributeValue("evaluate");
        try {
            LineBreakpoint newBreakpoint = null;
            if ("b_line".equals(kind)) {
                String filePath = xmlMessage.getAttributeValue("src_path");
                String lineNum = xmlMessage.getAttributeValue("src_line");
                IFile file = DebugUtils.getWorkspaceFilesFromFilename(filePath);
                if (filePath != null && file == null) {
                    file = DebugUtils.getWorkspaceFilesFromFilename(new File(filePath).getCanonicalPath());
                }
                int line = Integer.parseInt(lineNum);
                if (file == null) {
                    AccumulatingErrorDialog.popAccumulatingMessage("Problem creating breakpoints", "DVT was unable to create one or more breakpoints due to the following reasons:", "A breakpoint was added in the target on file:\n" + filePath + "\nwhich is not in the workspace. " + "The original breakpoint command was: ' " + xmlMessage.getAttributeValue("command") + " '");
                    return;
                }
                newBreakpoint = new LineBreakpoint((IResource)file, condition, evaluate, line);
            } else {
                newBreakpoint = new LineBreakpoint(command, condition, evaluate);
            }
            if (newBreakpoint.getMarker() != null) {
                newBreakpoint.handleBreakpointXMLMessage(xmlMessage);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)newBreakpoint);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private XMLMessage targetGetAllBreakpoints() {
        XMLMessage command = this.fMessageCreator.createCommandMessage("get all breakpoints");
        return this.fCommManager.executeCommand(command);
    }

    private XMLMessage targetDeleteAllBreakpoints() {
        XMLMessage command = this.fMessageCreator.createCommandMessage("delete all breakpoints");
        return this.fCommManager.executeCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(IBreakpoint breakpoint) {
        BaseBreakpoint breakpointBase;
        if (this.canHandleBreakpoint(breakpoint) && (breakpointBase = (BaseBreakpoint)breakpoint).getTargetBreakpointID() == null) {
            XMLMessage command = XMLMessageFactory.getInstance().makeBreakpointCommand((IBreakpoint)breakpointBase, "add breakpoint");
            Object object = this.fSyncAddBreakpoint;
            synchronized (object) {
                XMLMessage response = this.fCommManager.executeCommand(command);
                if (response.getStatus() == 0) {
                    XMLMessage breakpointXMLMessage = response.getChild("breakpoint");
                    if (breakpointXMLMessage != null) {
                        String responseModule = Path.fromOSString((String)breakpointXMLMessage.getAttributeValue("src_path")).lastSegment();
                        String breakpointModule = breakpoint.getMarker().getResource().getLocation().lastSegment();
                        if (responseModule != null && responseModule.equals(breakpointModule)) {
                            breakpointBase.setShouldDelete();
                            this.createBreakpointFromTarget(breakpointXMLMessage);
                        } else {
                            breakpointBase.setTargetFailed(true, String.valueOf(breakpointModule) + " not loaded in the target");
                        }
                    } else {
                        breakpointBase.setTargetFailed(true, response.getAttributeValue("err_msg"));
                    }
                } else {
                    breakpointBase.setTargetFailed(true, response.getAttributeValue("err_msg"));
                }
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta makerDelta) {
        BaseBreakpoint breakBase;
        if (this.canHandleBreakpoint(breakpoint) && (breakBase = (BaseBreakpoint)breakpoint).getTargetBreakpointID() != null) {
            XMLMessage command = XMLMessageFactory.getInstance().makeBreakpointCommand((IBreakpoint)breakBase, "delete breakpoint");
            this.fCommManager.executeCommand(command);
            breakBase.removed();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta markerDelta) {
        try {
            if (this.canHandleBreakpoint(breakpoint)) {
                if (breakpoint.isEnabled()) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    if (!breakpointManager.isEnabled()) {
                        this.disableBreakpoint((BaseBreakpoint)breakpoint);
                    } else {
                        this.enableBreakpoint((BaseBreakpoint)breakpoint);
                    }
                } else {
                    this.disableBreakpoint((BaseBreakpoint)breakpoint);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void enableBreakpoint(BaseBreakpoint breakpoint) {
        if (breakpoint.getTargetBreakpointID() != null && !breakpoint.getTargetEnabled()) {
            XMLMessage command = XMLMessageFactory.getInstance().makeBreakpointCommand((IBreakpoint)breakpoint, "enable breakpoint");
            this.fCommManager.executeCommand(command);
            breakpoint.setTargetEnabled(true);
        }
        breakpoint.enabled();
    }

    private void disableBreakpoint(BaseBreakpoint breakpoint) {
        if (breakpoint.getTargetBreakpointID() != null && breakpoint.getTargetEnabled()) {
            XMLMessage command = XMLMessageFactory.getInstance().makeBreakpointCommand((IBreakpoint)breakpoint, "disable breakpoint");
            this.fCommManager.executeCommand(command);
            breakpoint.setTargetEnabled(false);
        }
        breakpoint.disabled();
    }

    private boolean canHandleBreakpoint(IBreakpoint breakpoint) {
        return breakpoint != null && this.supportsBreakpoint(breakpoint) && breakpoint instanceof BaseBreakpoint;
    }

    public IBreakpoint getBreakpoint(int lineNumber, String file) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugUtils.getAllEBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint) {
                IPath filePath = Path.fromOSString((String)file);
                if (breakpoint instanceof BaseBreakpoint && breakpoint.getMarker().getResource().getLocation().equals((Object)filePath) && breakpoint.getMarker().getAttribute("lineNumber", -1) == lineNumber) {
                    return breakpoint;
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("ro.amiq.dvt.debug")) {
            block7: {
                String[] fileExtensions;
                IResource resource;
                block9: {
                    block8: {
                        IMarker marker;
                        block6: {
                            marker = breakpoint.getMarker();
                            if (!marker.getResource().equals((Object)ResourcesPlugin.getWorkspace().getRoot())) break block6;
                            return true;
                        }
                        resource = marker.getResource();
                        if (!(resource instanceof IFile)) break block7;
                        fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", false);
                        if (!DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) break block8;
                        return true;
                    }
                    fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
                    if (!DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) break block9;
                    return true;
                }
                try {
                    fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", false);
                    if (!DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) break block7;
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBreakpointAdded(XMLMessage xmlMessage) {
        Object object = this.fSyncAddBreakpoint;
        synchronized (object) {
            if (!this.breakpointExistsInTarget(xmlMessage)) {
                this.createBreakpointFromTarget(xmlMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBreakpointRemoved(XMLMessage xmlMessage) {
        Object object = this.fSyncAddBreakpoint;
        synchronized (object) {
            IBreakpoint breakpoint = this.getEclipseBreakpoint(xmlMessage);
            if (breakpoint != null) {
                try {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    private IBreakpoint getEclipseBreakpoint(XMLMessage xmlMessage) {
        if (xmlMessage != null) {
            String breakpointID = xmlMessage.getAttributeValue("bp_id");
            IBreakpoint[] allEclipseBreakpoints = DebugUtils.getAllEBreakpoints();
            int i = 0;
            while (i < allEclipseBreakpoints.length) {
                if (allEclipseBreakpoints[i] instanceof BaseBreakpoint) {
                    BaseBreakpoint breakpoint = (BaseBreakpoint)allEclipseBreakpoints[i];
                    if (breakpointID != null && breakpointID.equals(breakpoint.getTargetBreakpointID())) {
                        return breakpoint;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private boolean breakpointExistsInTarget(XMLMessage xmlMessage) {
        return this.getEclipseBreakpoint(xmlMessage) != null;
    }
}

