/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.ui.breakpoints.DVTBreakpointMessages;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;

public class BreakpointsUtils {
    private static final String[] PREDEFINED_QUEUE_FUNCTIONS_STRING = new String[]{"push_back", "push_front", "insert"};
    public static final Set<String> PREDEFINED_QUEUE_FUNCTIONS = new HashSet<String>(Arrays.asList(PREDEFINED_QUEUE_FUNCTIONS_STRING));
    private static final Pattern ATTRIBUTES_PATTERN = Pattern.compile("(-{1,2}[^=\\s-]+(?:-(?!-)[^=\\s-]+)*+)(?:\\s*=\\s*(\\S+))?");
    private static final Pattern ATTRIBUTES_SPLIT_PATTERN = Pattern.compile("//");
    private static final Pattern LOG_MESSAGE_PATTERN = Pattern.compile("(\\{[^{}]*\\}|[^{}]+)");

    public static ELParamValueScope evaluateExpression(String expression, IntrpDebugTarget debugTarget, IntrpDebugThread debugThread, IHidEvaluationGuardian guardian) {
        boolean oldIsEvaluatingDebugExpression = debugThread.isEvaluatingDebugExpression();
        try {
            IRfNamedElement contextElement;
            IHidEvaluator lastEvaluator;
            if (debugTarget == null) {
                DVTLogger.INSTANCE.logError(DVTBreakpointMessages.expression_error_incorrect_debug_target);
                return null;
            }
            IRfSingleLangProject rfProject = debugThread.getIntrpEvaluator().getRfProject();
            if (rfProject == null) {
                DVTLogger.INSTANCE.logError(DVTBreakpointMessages.expression_error_missing_project_context);
                return null;
            }
            IProject project = debugTarget.getProject();
            List<Invocation> invocations = BuildConfigManager.getInvocations(project);
            if (invocations == null || invocations.isEmpty()) {
                DVTLogger.INSTANCE.logError(DVTBreakpointMessages.expression_error_missing_project_configuration);
                return null;
            }
            Invocation lastInvocation = invocations.get(invocations.size() - 1);
            String defaultKeywordSet = BuildConfigManager.getDefaultKeywordSet(lastInvocation);
            Map<String, String> extensionKeywordsetMap = BuildConfigManager.getExtensionKeywordSetMap(lastInvocation);
            IBuildConfigParserConstants.ToolCompat toolCompat = lastInvocation.getToolCompat();
            IHidObject patternHidObject = RfMixedLangManager.getInstance().parsePattern(expression, defaultKeywordSet, extensionKeywordsetMap, toolCompat, debugThread.isHotSwapPending(), rfProject);
            if (patternHidObject == null) {
                DVTLogger.INSTANCE.logError(DVTBreakpointMessages.expression_error_condition_parsing_failed);
                return null;
            }
            XEvalScope xParentEvalScope = debugThread.getXThread().getParentScope(false);
            BitVectorContext context = xParentEvalScope.getBvContext();
            IHidEvaluator evaluator = xParentEvalScope.getEvaluator();
            if (!(evaluator instanceof XValueHolder)) {
                DVTLogger.INSTANCE.logError(DVTBreakpointMessages.expression_error_condition_evaluation_failed);
                return null;
            }
            IHidEvaluator closestEvaluator = evaluator;
            IntrpStackFrame peekFrame = (IntrpStackFrame)debugThread.getXThread().getTopStackFrame();
            if (!peekFrame.stackValues.isEmpty() && (lastEvaluator = peekFrame.stackValues.peekFirst()) != null) {
                closestEvaluator = lastEvaluator;
            }
            if ((contextElement = closestEvaluator.getNamedElement()) != null) {
                for (IHid hid : HidUtils.flattenToHids(patternHidObject, HidFlatteningOption.NONE_EXCLUDED)) {
                    Hid ancestorHid;
                    if (!(hid instanceof Hid) || (ancestorHid = ((Hid)hid).getAncestorHid()) == null) continue;
                    ancestorHid.resolveInContext(closestEvaluator, guardian.copy(), hid, false);
                }
            }
            debugThread.setEvaluatingDebugExpression(true);
            ELParamValueScope eLParamValueScope = ELUtils.evaluate(patternHidObject, closestEvaluator, context, guardian.copy());
            return eLParamValueScope;
        }
        finally {
            debugThread.setEvaluatingDebugExpression(oldIsEvaluatingDebugExpression);
        }
    }

    public static int computeWatchpointElementID(IRfNamedElement element) {
        int result = 1;
        IRfDefElement declaration = element.getDeclaration();
        result = 31 * result + declaration.getClass().getName().hashCode();
        IRfScopeElement enclosingScope = declaration.getNamedElement();
        while (enclosingScope != null) {
            result = 31 * result + enclosingScope.getName().hashCode();
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        result = 31 * result + (declaration.getParserPath() == null ? 0 : declaration.getParserPath().hashCode());
        result = 31 * result + (declaration.getName() == null ? 0 : declaration.getName().hashCode());
        return result;
    }

    public static Map<String, String> parseAttributesFromCondition(String condition) {
        if (condition == null) {
            return null;
        }
        String[] conditionAndArgs = ATTRIBUTES_SPLIT_PATTERN.split(condition);
        if (conditionAndArgs.length <= 1) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = ATTRIBUTES_PATTERN.matcher(conditionAndArgs[1]);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            attributes.put(key, value != null ? value : "true");
        }
        return attributes;
    }

    public static String computeExpressionFromLogMessage(String logMessage) {
        StringBuilder expressionSB = new StringBuilder("$display(");
        Matcher matcher = LOG_MESSAGE_PATTERN.matcher(logMessage);
        while (matcher.find()) {
            String logPiece = matcher.group();
            if (logPiece.isEmpty()) continue;
            if (logPiece.startsWith("{") && logPiece.endsWith("}")) {
                expressionSB.append(String.valueOf(logPiece.substring(1, logPiece.length() - 1)) + ", ");
                continue;
            }
            expressionSB.append("\"" + logPiece + "\" ,");
        }
        if (expressionSB.toString().endsWith(",")) {
            expressionSB.deleteCharAt(expressionSB.length() - 1);
        }
        expressionSB.append(")");
        return expressionSB.toString();
    }
}

