/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import org.eclipse.debug.core.model.IDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ConditionalBreakpointHandler {
    public static final int SUSPEND = 1;
    public static final int DONT_SUSPEND = 2;

    public int computNewThreadStateOnConditionHit(IntrpDebugThread thread, LineBreakpoint breakpoint, XEvalScope xParentEvalScope, IHidEvaluationGuardian guardian) {
        ELParamValueScope result;
        IDebugTarget debugTarget;
        block7: {
            String condition = breakpoint.getCondition();
            if (condition == null || condition.trim().isEmpty()) {
                return 1;
            }
            debugTarget = thread.getDebugTarget();
            result = BreakpointsUtils.evaluateExpression(condition, (IntrpDebugTarget)debugTarget, thread, guardian);
            if (result == null) {
                return 1;
            }
            try {
                if (!breakpoint.isConditionSuspendOnTrue()) break block7;
                if (ELUtils.isFalse(result.value)) {
                    return 2;
                }
                return 1;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return 1;
            }
        }
        IELParamValue lastValue = breakpoint.setCurrentConditionValue(debugTarget, result.value.copy());
        if (!result.value.equals(lastValue)) {
            return 1;
        }
        return 2;
    }
}

