/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum DVTBreakpointMarkerChangeListener implements IResourceChangeListener
{
    INSTANCE;


    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        try {
            delta.accept(d -> {
                IResource resource;
                if ((d.getFlags() & 0x100) != 0 && (resource = d.getResource()) instanceof IFile) {
                    IBreakpoint[] breakpoints;
                    boolean shouldUpdateMarker = false;
                    IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int n = breakpoints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint bp = iBreakpointArray[n2];
                        if (bp instanceof ILineBreakpoint && bp.getMarker().getResource().equals((Object)resource) && ((LineBreakpoint)bp).shouldUpdateMarker()) {
                            shouldUpdateMarker = true;
                            break;
                        }
                        ++n2;
                    }
                    if (shouldUpdateMarker) {
                        this.scheduleFileUpdate((IFile)resource);
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void scheduleFileUpdate(final IFile file) {
        Job job = new Job("Update Breakpoint Markers"){

            protected IStatus run(IProgressMonitor monitor) {
                IBreakpoint[] breakpoints;
                IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint bp = iBreakpointArray[n2];
                    if (bp instanceof ILineBreakpoint && bp.getMarker().getResource().equals((Object)file)) {
                        try {
                            ((LineBreakpoint)bp).updateMarker();
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)file.getWorkspace().getRoot());
        job.schedule();
    }
}

