/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTBreakpointMarkerUpdater
implements IMarkerUpdater {
    public String getMarkerType() {
        return "ro.amiq.dvt.debug.core.lineBreakpointMarkerType";
    }

    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        int markerEnd;
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        boolean offsetsChanged = false;
        int markerStart = MarkerUtilities.getCharStart((IMarker)marker);
        if (markerStart == (markerEnd = MarkerUtilities.getCharEnd((IMarker)marker)) && markerEnd == position.getOffset()) {
            return false;
        }
        if (markerStart < 0 || markerEnd < 0) {
            return false;
        }
        int offset = position.getOffset();
        if (markerStart != offset) {
            MarkerUtilities.setCharStart((IMarker)marker, (int)offset);
            offsetsChanged = true;
        }
        if (DVTFileUtils.getInstance().isInCommentSection(document, offset)) {
            return false;
        }
        if (markerEnd != (offset += position.getLength())) {
            MarkerUtilities.setCharEnd((IMarker)marker, (int)offset);
            offsetsChanged = true;
        }
        if (offsetsChanged && MarkerUtilities.getLineNumber((IMarker)marker) != -1) {
            try {
                MarkerUtilities.setLineNumber((IMarker)marker, (int)(document.getLineOfOffset(position.getOffset()) + 1));
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

