/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.MarkerUtilities;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointPropertiesAttributesArgs;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsUtils;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageConstants;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class LineBreakpoint
extends BaseBreakpoint {
    public static final String CONDITION = "condition";
    public static final String CONDITION_ENABLED = "condition_enabled";
    protected static final String CONDITION_SUSPEND_ON_TRUE = "condition_suspend_on_true";
    private Map<IDebugTarget, IELParamValue> fConditionValues = new HashMap<IDebugTarget, IELParamValue>();

    public LineBreakpoint() {
    }

    public LineBreakpoint(IResource resource, String condition, String executeCommand, int lineNumber) throws CoreException {
        this();
        String command = this.getCommandMessage(resource, String.valueOf(lineNumber));
        this.createMarker("ro.amiq.dvt.debug.core.lineBreakpointMarkerType", resource, command, condition, executeCommand, new HashMap<String, Object>(), lineNumber);
    }

    public LineBreakpoint(String command, String condition, String executeCommand) throws CoreException {
        this();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("command", command);
        this.createMarker("ro.amiq.dvt.debug.core.lineBreakpointMarkerType", null, command, condition, executeCommand, attributes, -1);
    }

    protected void createMarker(final String markerType, final IResource resource, final String command, final String condition, final String executeCommand, final Map<String, Object> attributes, int lineNumber) throws CoreException {
        if (lineNumber > 0) {
            IDocument document = DVTFileUtils.getInstance().getOpenDocument((IFile)resource);
            int offset = DVTFileUtils.getInstance().getLineCodeStartOffset((IFile)resource, document, lineNumber - 1);
            int endLineOfsset = DVTFileUtils.getInstance().getLineOffset((IFile)resource, lineNumber) - 1;
            attributes.put("lineNumber", lineNumber);
            attributes.put("charStart", offset);
            attributes.put("charEnd", endLineOfsset);
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = null;
                marker = resource != null ? resource.createMarker(markerType) : ResourcesPlugin.getWorkspace().getRoot().createMarker(markerType);
                if (marker != null) {
                    marker.setAttribute("org.eclipse.debug.core.id", (Object)LineBreakpoint.this.getModelIdentifier());
                    marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                    if (command != null) {
                        marker.setAttribute("message", (Object)command);
                        marker.setAttribute("command", (Object)command);
                    }
                    if (condition != null && !condition.isEmpty()) {
                        marker.setAttribute(LineBreakpoint.CONDITION, (Object)condition);
                    }
                    if (executeCommand != null && !executeCommand.isEmpty()) {
                        marker.setAttribute("evaluate", (Object)executeCommand);
                    }
                    if (attributes != null) {
                        for (Map.Entry entry : attributes.entrySet()) {
                            marker.setAttribute((String)entry.getKey(), entry.getValue());
                        }
                    }
                    LineBreakpoint.this.setMarker(marker);
                }
            }
        };
        this.run(this.getMarkerRule((IResource)(resource != null ? resource : ResourcesPlugin.getWorkspace().getRoot())), runnable);
    }

    @Override
    public XMLMessage toXMLMessage() {
        String enabled;
        IResource resource = this.getMarker().getResource();
        if (resource == null) {
            return null;
        }
        String srcLine = String.valueOf(this.getMarker().getAttribute("lineNumber", -1));
        IPath srcLocation = resource.getLocation();
        if (srcLocation == null) {
            return null;
        }
        String srcPath = srcLocation.toOSString();
        String breakpointID = String.valueOf(this.getMarker().getAttribute("bp_id", ""));
        String fileName = Utils.getFileNameNoExtension(resource.getName());
        String condition = this.getMarker().getAttribute(CONDITION, "");
        String command = this.getMarker().getAttribute("command", "");
        String execute = this.getMarker().getAttribute("evaluate", "");
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            enabled = breakpointManager.isEnabled() && this.isEnabled() ? "1" : "0";
        }
        catch (CoreException coreException) {
            enabled = "0";
        }
        String breakpointEventType = "b_line";
        if ("-1".equals(srcLine)) {
            breakpointEventType = "b_any";
        }
        return XMLMessageFactory.getInstance().createMessage("breakpoint", "", XMLMessageConstants.LINE_BREAKPOINT_ATTRIBUTES, new String[]{breakpointID, enabled, command, breakpointEventType, srcLine, srcPath, fileName, condition, execute});
    }

    public boolean shouldUpdateMarker() {
        IMarker m = this.getMarker();
        if (m == null) {
            return false;
        }
        IRegion newMarkerRegion = this.getUpdatedMarkerRegion(m);
        return newMarkerRegion != null;
    }

    public void updateMarker() throws CoreException {
        IMarker m = this.getMarker();
        if (m == null) {
            return;
        }
        IRegion markerRegion = this.getUpdatedMarkerRegion(m);
        if (markerRegion == null) {
            return;
        }
        if (markerRegion.getOffset() == -1) {
            this.delete();
        }
        int newStartOffset = markerRegion.getOffset();
        int newEndOffset = newStartOffset + markerRegion.getLength();
        MarkerUtilities.setCharStart((IMarker)m, (int)newStartOffset);
        MarkerUtilities.setCharEnd((IMarker)m, (int)newEndOffset);
    }

    private IRegion getUpdatedMarkerRegion(IMarker m) {
        int lineNumber = m.getAttribute("lineNumber", -1);
        if (lineNumber < 0) {
            return null;
        }
        int startOffset = m.getAttribute("charStart", -1);
        if (startOffset < 0) {
            return null;
        }
        IResource resource = m.getResource();
        IDocument document = DVTFileUtils.getInstance().getOpenDocument((IFile)resource);
        if (document == null) {
            return null;
        }
        int newStartOffset = DVTFileUtils.getInstance().getLineCodeStartOffset((IFile)resource, document, lineNumber - 1);
        if (newStartOffset < 0) {
            return new Region(-1, -1);
        }
        int newEndOffset = DVTFileUtils.getInstance().getLineOffset((IFile)resource, lineNumber) - 1;
        if (newEndOffset < 0) {
            return null;
        }
        return new Region(newStartOffset, newEndOffset - newStartOffset);
    }

    public String getTrace() {
        return "";
    }

    @Override
    public Image getImage() {
        try {
            boolean isConditional = this.getMarker().getAttribute(CONDITION_ENABLED, false);
            boolean isTriggerpoint = this.isTriggerPoint();
            boolean isEnabled = this.isEnabled();
            Image bpImage = this.getBreakpointImage(isEnabled);
            if (isConditional) {
                bpImage = isEnabled ? DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(bpImage, DVTImages.OVR_CONDITIONAL, 0)) : DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(bpImage, DVTImages.OVR_CONDITIONAL_DISABLED, 0));
            }
            if (isTriggerpoint) {
                bpImage = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(bpImage, DVTImages.OVR_TRIGGER, 3));
            }
            try {
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                Method hasActiveTriggerPointsM = breakpointManager.getClass().getMethod("hasActiveTriggerPoints", new Class[0]);
                if (((Boolean)hasActiveTriggerPointsM.invoke((Object)breakpointManager, new Object[0])).booleanValue() && !isTriggerpoint) {
                    bpImage = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(bpImage, DVTImages.OVR_SUPPRESSED_TRIGGER, 3));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
            return bpImage;
        }
        catch (CoreException coreException) {
            return DVTImages.imageCache.getImage(ImageDescriptor.getMissingImageDescriptor());
        }
    }

    protected Image getBreakpointImage(boolean isEnabled) {
        boolean isFailed = this.getMarker().getAttribute("target_failed", false);
        if (isEnabled) {
            if (isFailed) {
                return DVTImages.imageCache.getImage(DVTImages.BREAKPOINT_LINE_FAILED);
            }
            return DVTImages.imageCache.getImage(DVTImages.BREAKPOINT_LINE_ENABLED);
        }
        return DVTImages.imageCache.getImage(DVTImages.BREAKPOINT_LINE_DISABLED);
    }

    @Override
    protected String getSourceContext() {
        IResource resource = this.getMarker().getResource();
        if (resource == null) {
            return null;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return DebugUtils.getLine(new File(location.toOSString()), this.getMarker().getAttribute("lineNumber", -1));
    }

    public void updateMarkerMessage() {
        try {
            IMarker marker = this.getMarker();
            if (marker == null) {
                return;
            }
            IResource resource = this.getMarker().getResource();
            if (resource == null) {
                return;
            }
            String currentMarkerCommand = marker.getAttribute("command", "");
            String srcLine = String.valueOf(this.getMarker().getAttribute("lineNumber", -1));
            String command = this.getCommandMessage(this.getMarker().getResource(), srcLine);
            if (command.equals(currentMarkerCommand)) {
                return;
            }
            marker.setAttribute("message", (Object)command);
            marker.setAttribute("command", (Object)command);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected String getCommandMessage(IResource resource, String srcLine) {
        return "break on line " + srcLine + " in @" + resource.getName();
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    @Override
    public void setConditionEnabled(boolean condition) {
        try {
            this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{condition});
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean hasCondition() {
        try {
            String condition = this.getCondition();
            return this.isConditionEnabled() && condition != null && condition.length() > 0;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public String getCondition() {
        try {
            return this.ensureMarker().getAttribute(CONDITION, null);
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void setCondition(String condition) {
        this.fConditionValues.clear();
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        try {
            this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
            if (condition != null) {
                this.addAttributes(BreakpointsUtils.parseAttributesFromCondition(condition));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean isConditionSuspendOnTrue() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    @Override
    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        if (this.isConditionSuspendOnTrue() != suspendOnTrue) {
            this.setAttributes(new String[]{CONDITION_SUSPEND_ON_TRUE}, new Object[]{suspendOnTrue});
            this.fConditionValues.clear();
        }
    }

    public void addAttributes(Map<String, String> attributes) throws CoreException {
        boolean isConditionValueChange;
        boolean isTriggerPoint;
        if (attributes == null) {
            return;
        }
        String hitCountAttribute = attributes.get(BreakpointPropertiesAttributesArgs.HITCOUNT.getName());
        if (hitCountAttribute == null) {
            hitCountAttribute = attributes.get(BreakpointPropertiesAttributesArgs.HITCOUNT_SHORTHAND.getName());
        }
        if (hitCountAttribute != null) {
            this.setHitCount(Integer.parseInt(hitCountAttribute));
        }
        boolean bl = isTriggerPoint = attributes.containsKey(BreakpointPropertiesAttributesArgs.TRIGGERPOINT.getName()) || attributes.containsKey(BreakpointPropertiesAttributesArgs.TRIGGERPOINT_SHORTHAND.getName());
        if (isTriggerPoint) {
            this.setTriggerPoint(true);
        }
        boolean bl2 = isConditionValueChange = attributes.containsKey(BreakpointPropertiesAttributesArgs.CONDITION_VALUE_CHANGE.getName()) || attributes.containsKey(BreakpointPropertiesAttributesArgs.CONDITION_VALUE_CHANGE_SHORTHAND.getName());
        if (isConditionValueChange) {
            this.setConditionSuspendOnTrue(false);
        }
    }

    protected IELParamValue setCurrentConditionValue(IDebugTarget target, IELParamValue value) {
        IELParamValue prev = this.fConditionValues.get(target);
        if (prev == null) {
            this.fConditionValues.clear();
        }
        this.fConditionValues.put(target, value);
        return prev;
    }
}

