/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.breakpoints;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IWatchpoint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class Watchpoint
extends LineBreakpoint
implements IWatchpoint {
    protected static final String ACCESS = "access";
    protected static final String MODIFICATION = "modification";
    protected static final String AUTO_DISABLED = "autoDisabled";
    protected static final String FIELD_IDENTIFIER = "fieldIdentifier";

    public Watchpoint() {
    }

    public Watchpoint(IResource resource, String condition, String executeCommand, int lineNumber, IRfFieldElement field) throws CoreException {
        this();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("lineNumber", lineNumber);
        String command = "watch on line " + lineNumber + " in @" + resource.getName();
        attributes.put(FIELD_IDENTIFIER, Integer.toString(BreakpointsUtils.computeWatchpointElementID(field)));
        this.createMarker("ro.amiq.dvt.debug.core.watchpointMarkerType", resource, command, condition, executeCommand, attributes, lineNumber);
        this.setAccess(true);
        this.setModification(true);
    }

    @Override
    protected String getCommandMessage(IResource resource, String srcLine) {
        return "watch on line " + srcLine + " in @" + this.getMarker().getResource().getName();
    }

    public String getFieldIdentifier() {
        try {
            return this.ensureMarker().getAttribute(FIELD_IDENTIFIER, null);
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public boolean isModification() throws CoreException {
        return this.ensureMarker().getAttribute(MODIFICATION, false);
    }

    public void setModification(boolean modification) throws CoreException {
        if (modification == this.isModification()) {
            return;
        }
        this.setAttribute(MODIFICATION, modification);
        if (modification && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!modification && !this.isAccess()) {
            this.setEnabled(false);
        }
    }

    public boolean isAccess() throws CoreException {
        return this.ensureMarker().getAttribute(ACCESS, false);
    }

    public void setAccess(boolean access) throws CoreException {
        if (access == this.isAccess()) {
            return;
        }
        this.setAttribute(ACCESS, access);
        if (access && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!access && !this.isModification()) {
            this.setEnabled(false);
        }
    }

    public boolean supportsAccess() {
        return true;
    }

    public boolean supportsModification() {
        return true;
    }

    @Override
    protected Image getBreakpointImage(boolean isEnabled) {
        try {
            boolean isAccess = this.isAccess();
            boolean isModification = this.isModification();
            if (isEnabled) {
                if (isAccess && isModification) {
                    return DVTImages.imageCache.getImage(DVTImages.ACCESSMODIF_WATCHPOINT_ENABLED);
                }
                if (isAccess) {
                    return DVTImages.imageCache.getImage(DVTImages.ACCESS_WATCHPOINT_ENABLED);
                }
                if (isModification) {
                    return DVTImages.imageCache.getImage(DVTImages.MODIF_WATCHPOINT_ENABLED);
                }
            }
            if (isAccess == isModification) {
                return DVTImages.imageCache.getImage(DVTImages.ACCESSMODIF_WATCHPOINT_DISABLED);
            }
            if (isAccess) {
                return DVTImages.imageCache.getImage(DVTImages.ACCESS_WATCHPOINT_DISABLED);
            }
            return DVTImages.imageCache.getImage(DVTImages.MODIF_WATCHPOINT_DISABLED);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return DVTImages.imageCache.getImage(ImageDescriptor.getMissingImageDescriptor());
        }
    }
}

