/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;

public class DVTWatchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        TreePath[] paths = ((TreeSelection)selection).getPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.createExpression(path);
            ++n2;
        }
        return null;
    }

    private void showExpressionsView() {
        IWorkbenchPage page = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException partInitException) {}
        } else {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    private void createExpression(Object element) {
        StringBuilder expressionStringBuilder = new StringBuilder();
        if (!(element instanceof TreePath)) {
            return;
        }
        TreePath path = (TreePath)element;
        if (path.getSegmentCount() == 0) {
            return;
        }
        int i = 0;
        while (i < path.getSegmentCount()) {
            Object segment = path.getSegment(i);
            if (segment instanceof IntrpVariable) {
                IntrpVariable intrpVariable = (IntrpVariable)segment;
                String name = intrpVariable.getName();
                if (name.contains("[") && !name.trim().startsWith("[")) {
                    name = name.substring(0, name.indexOf("["));
                }
                expressionStringBuilder.append(expressionStringBuilder.toString().isEmpty() || name.trim().startsWith("[") ? "" : ".").append(name);
            }
            ++i;
        }
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expressionStringBuilder.toString());
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
        this.showExpressionsView();
    }

    static IWatchExpressionFactoryAdapter getFactory(IVariable variable) {
        return (IWatchExpressionFactoryAdapter)variable.getAdapter(IWatchExpressionFactoryAdapter.class);
    }

    static IWatchExpressionFactoryAdapter2 getFactory2(Object element) {
        if (element instanceof IAdaptable) {
            return (IWatchExpressionFactoryAdapter2)((IAdaptable)element).getAdapter(IWatchExpressionFactoryAdapter2.class);
        }
        return null;
    }
}

