/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.variables.DummyVariable;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.debug.core.model.variables.VariableFactory;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Value
extends DebugElement
implements IValue {
    private final Object fSyncObject = new Object();
    private Variable fParentVariable;
    private String fValue;
    private String fRefTypeName;
    private boolean fHasVariables;
    private Variable[] fVariables;
    private boolean fIsDirty;

    public Value(DebugTarget target, Variable variable, String value, String refTypeName, boolean hasVariables) {
        super(target);
        this.fParentVariable = variable;
        this.fIsDirty = true;
        this.fValue = value;
        this.fRefTypeName = refTypeName;
        this.fHasVariables = hasVariables;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            return this == obj || this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return DVTStringUtil.appendString(this.fValue, "@", this.fRefTypeName, "@", this.fHasVariables).hashCode();
    }

    public Variable getParentVariable() {
        return this.fParentVariable;
    }

    public String getReferenceTypeName() {
        return this.fRefTypeName;
    }

    public String getValueString() {
        return this.fValue;
    }

    public boolean isAllocated() {
        return true;
    }

    public boolean hasVariables() {
        return this.fHasVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable[] getVariables() throws DebugException {
        Object object = this.fSyncObject;
        synchronized (object) {
            if (this.fHasVariables && this.fIsDirty) {
                this.fetchFromTarget();
            }
            if (this.fVariables == null) {
                return new Variable[0];
            }
            return this.fVariables;
        }
    }

    private void fetchFromTarget() throws DebugException {
        if (this.fParentVariable == null) {
            return;
        }
        XMLMessage xmlMessage = this.fTarget.reqCommGetVariable(this.fParentVariable);
        this.setVariablesFromXMLMessage(xmlMessage, false);
        this.fireChangeEvent(512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVariablesFromXMLMessage(XMLMessage xmlMessage, boolean updateHasChildren) {
        Object object = this.fSyncObject;
        synchronized (object) {
            this.fIsDirty = false;
            this.fVariables = this.createVariablesFromXMLMessage(xmlMessage);
            if (updateHasChildren) {
                this.fHasVariables = this.fVariables != null && this.fVariables.length > 0;
            }
        }
    }

    public StackFrame getStackFrame() {
        return this.fParentVariable.getStackFrame();
    }

    protected Variable[] createVariablesFromXMLMessage(XMLMessage xmlMessage) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (xmlMessage.getStatus() != 0) {
            Variable variable = VariableFactory.createErrorVariable(this.getStackFrame(), xmlMessage.getStatus());
            result.add(variable);
        } else {
            List<XMLMessage> xmlVariables = xmlMessage.getChildren("variable");
            if (xmlVariables != null && !xmlVariables.isEmpty()) {
                int i = 0;
                while (i < xmlVariables.size()) {
                    Variable variable = VariableFactory.createVariableFromXMLMessage(this.getStackFrame(), xmlVariables.get(i));
                    if (variable instanceof DummyVariable) {
                        result.addAll(Arrays.asList(variable.getExistingValue().getExistingVariables()));
                    } else {
                        result.add(variable);
                    }
                    ++i;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Variable[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariables(Variable[] variables) {
        Object object = this.fSyncObject;
        synchronized (object) {
            this.fIsDirty = false;
            this.fVariables = variables;
            this.fHasVariables = variables != null && variables.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable[] getExistingVariables() {
        Object object = this.fSyncObject;
        synchronized (object) {
            return this.fVariables;
        }
    }

    public void setValue(String value) throws DebugException {
        this.fValue = value;
        this.fIsDirty = true;
        this.fHasVariables = false;
        XMLMessage xmlMessage = this.fTarget.reqCommGetExpression(this.fParentVariable.getPath(), this.getStackFrame());
        if (xmlMessage.getStatus() == 1) {
            this.fValue = "*** ERROR: I/O communication error.";
            return;
        }
        if (xmlMessage.getStatus() == 2) {
            this.fValue = "*** ERROR: Message decoding error.";
            return;
        }
        if (xmlMessage.getStatus() == 3) {
            this.fValue = "*** ERROR: Connection timeout.";
            return;
        }
        XMLMessage xmlVariable = xmlMessage.getChild("variable");
        if (xmlVariable != null) {
            this.fHasVariables = xmlVariable.getAttributeValue("has_children").equals("true");
            this.fValue = xmlVariable.getAttributeValue("value");
        }
        ((DebugTarget)this.getDebugTarget()).syncData(false);
    }

    @Override
    public Image getImage() {
        return null;
    }
}

