/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.variables.ListVariable;
import ro.amiq.dvt.debug.core.model.variables.Value;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageConstants;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.debug.ui.model.variables.VariableEditor;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Variable
extends DebugElement
implements IVariable,
IWatchExpressionFactoryAdapter {
    private StackFrame fStackFrame;
    private String fName;
    private String fPath;
    private String fTypeName;
    private String fTypeKind;
    private Value fValue;

    public Variable(StackFrame stackFrame, String name, String path, String typeName, String typeKind, String value, boolean hasChildren) {
        super((DebugTarget)stackFrame.getDebugTarget());
        this.fStackFrame = stackFrame;
        this.fName = name;
        this.fPath = path;
        this.fTypeName = typeName;
        this.fTypeKind = typeKind;
        this.fValue = new Value(this.fTarget, this, value, typeName, hasChildren);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variable) {
            return this == obj || this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return DVTStringUtil.appendString(this.fName, "@", this.fPath, "@", this.fTypeName, "@", this.fTypeKind).hashCode();
    }

    public int getThreadId() {
        return this.fStackFrame.getThread().getThreadId();
    }

    public StackFrame getStackFrame() {
        return this.fStackFrame;
    }

    public int getStackLevel() {
        return this.fStackFrame.getStackLevel();
    }

    public String getName() {
        return this.fName;
    }

    public String getPath() {
        return this.fPath;
    }

    public String getReferenceTypeName() {
        return this.fTypeName;
    }

    public Value getExistingValue() {
        return this.fValue;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public void setValue(IValue value) throws DebugException {
        if (value instanceof Value) {
            this.fValue = (Value)value;
        } else {
            this.throwDebugException(4, "setValue: unexpected IValue.");
        }
    }

    public void setValue(String expression) throws DebugException {
        if (expression != null) {
            this.fValue.setValue(expression);
        } else {
            this.throwDebugException(4, "setValue: unexpected String.");
        }
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return this.verifyValue(value.getValueString());
    }

    public boolean verifyValue(String expression) throws DebugException {
        if (expression != null) {
            return this.fTarget.tChangeValue(this, expression);
        }
        return false;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean hasValueChanged() throws DebugException {
        return ((DebugTarget)this.getDebugTarget()).variableHasChanged(this);
    }

    public XMLMessage toXMLMessage() {
        String threadId = String.valueOf(this.getStackFrame().getThread().getThreadId());
        String stackLevel = String.valueOf(this.getStackFrame().getStackLevel());
        String startRange = String.valueOf(this.getRangeStart());
        String endRange = String.valueOf(this.getRangeEnd());
        String path = this.getPath();
        String varType = this.getTypeKind();
        String typeName = this.getTypeName();
        String[] attributes = new String[]{path, varType, typeName, threadId, stackLevel, startRange, endRange};
        return XMLMessageFactory.getInstance().createMessage("variable", "", XMLMessageConstants.VARIABLE_ATTRIBUTES, attributes);
    }

    protected String getTypeKind() {
        return this.fTypeKind;
    }

    protected String getTypeName() {
        return this.fTypeName;
    }

    @Override
    public Image getImage() {
        if (this instanceof ListVariable && this.fName.startsWith("[")) {
            return DVTImages.imageCache.getImage(DVTImages.DEBUG_ARRAY_PARTITION);
        }
        if ("vtk_scalar".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
        }
        if ("vtk_struct".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
        }
        if ("vtk_unit".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT);
        }
        if ("vtk_list".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIST);
        }
        if ("vtk_port_simple_in".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_IN);
        }
        if ("vtk_port_simple_out".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_OUT);
        }
        if ("vtk_port_simple_inout".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_SIMPLE_INOUT);
        }
        if ("vtk_port_buffer_in".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_IN);
        }
        if ("vtk_port_buffer_out".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_BUFFER_OUT);
        }
        if ("vtk_port_event_in".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_IN);
        }
        if ("vtk_port_event_out".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_OUT);
        }
        if ("vtk_port_event_inout".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_EVENT_INOUT);
        }
        if ("vtk_port_method_in".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_IN);
        }
        if ("vtk_port_method_out".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.PORT_METHOD_OUT);
        }
        if ("sv_class".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
        }
        if ("sv_scalar".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        }
        if ("sv_type_param".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE_PARAM);
        }
        if ("sv_param".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PARAM);
        }
        if ("sv_wire".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_WIRE);
        }
        if ("sv_interface".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_INSTANCE);
        }
        if ("sv_module".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
        }
        if ("sv_output_port".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_OUTPUT_PORT);
        }
        if ("sv_input_port".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INPUT_PORT);
        }
        if ("sv_inout_port".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
        }
        if ("sv_event".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
        }
        if ("sv_enum".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
        }
        if ("sv_array".equals(this.fTypeKind) || "sv_queue".equals(this.fTypeKind) || "sv_assoc_array".equals(this.fTypeKind) || "sv_dynamic_array".equals(this.fTypeKind)) {
            return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD), DVTImages.OVR_ARRAY, 3));
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IElementEditor.class.equals((Object)adapter)) {
            return VariableEditor.getInstance();
        }
        if (IWatchExpressionFactoryAdapter.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String createWatchExpression(IVariable variable) throws CoreException {
        return this.fPath;
    }

    public int getRangeStart() {
        return -1;
    }

    public int getRangeEnd() {
        return -1;
    }
}

