/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import java.text.MessageFormat;
import java.util.List;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.variables.DummyVariable;
import ro.amiq.dvt.debug.core.model.variables.ListVariable;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.debug.core.model.variables.WatchExpressionResult;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.utils.DVTStringUtil;

public class VariableFactory {
    public static final int ID_DEB_TARGET_CNST_LIST_SPLIT = 100;
    public static final int ID_DEB_TARGET_CNST_SV_ARRAY_SPLIT = 100;
    public static final int ID_DEB_TARGET_BIG_VARIABLE_SPLIT = 100;

    public static Variable createErrorVariable(StackFrame stackFrame, int errorKind) {
        if (errorKind == 1) {
            return new Variable(stackFrame, "*** ERROR: I/O communication error.", "", "N/A", "vtk_scalar", "N/A", false);
        }
        if (errorKind == 2) {
            return new Variable(stackFrame, "*** ERROR: Message decoding error.", "", "N/A", "vtk_scalar", "N/A", false);
        }
        if (errorKind == 3) {
            return new Variable(stackFrame, "*** ERROR: Connection timeout.", "", "N/A", "vtk_scalar", "N/A", false);
        }
        if (errorKind == 4) {
            return new Variable(stackFrame, "*** ERROR: Target fail.", "", "N/A", "vtk_scalar", "N/A", false);
        }
        return null;
    }

    public static Variable createRootVariable(StackFrame stackFrame) {
        return new Variable(stackFrame, "Root", "", "", "", "", true);
    }

    public static Variable createVariableFromXMLMessage(StackFrame stackFrame, XMLMessage xmlMessage) {
        if (xmlMessage == null) {
            return null;
        }
        Variable result = null;
        String name = xmlMessage.getAttributeValue("name");
        String value = xmlMessage.getAttributeValue("value");
        if (value != null && value.startsWith("DVT ERROR:")) {
            value = MessageFormat.format("*** ERROR: Unable to evaluate {0}.", "variable");
        }
        boolean hasChildren = xmlMessage.getAttributeValue("has_children").equals("true");
        String path = xmlMessage.getAttributeValue("path");
        String varType = xmlMessage.getAttributeValue("var_type");
        String typeName = xmlMessage.getAttributeValue("type_name");
        if (value != null && varType != null && varType.equals("vtk_list")) {
            result = new ListVariable(stackFrame, name, value, path, typeName, varType, -1, -1);
            String[] list = value.split("/./");
            list = list[list.length - 1].split("\\[");
            int size = Integer.parseInt(list[1].split("]")[0]);
            Variable[] varSplit = VariableFactory.createBuckets(stackFrame, true, path, varType, typeName, size);
            result.getExistingValue().setVariables(varSplit);
        } else if (value != null && varType != null && VariableFactory.isSvArray(varType)) {
            result = new ListVariable(stackFrame, name, value, path, typeName, varType, -1, -1);
            String nofChildren = xmlMessage.getAttributeValue("nof_children");
            int size = DVTStringUtil.parseInt(nofChildren, 0);
            Variable[] varSplit = VariableFactory.createBuckets(stackFrame, false, path, varType, typeName, size);
            result.getExistingValue().setVariables(varSplit);
        } else if (varType != null && varType.equals("dummy_var")) {
            result = new DummyVariable(stackFrame, name, path, typeName, varType, value, hasChildren);
            String nofChildren = xmlMessage.getAttributeValue("nof_children");
            int size = DVTStringUtil.parseInt(nofChildren, 0);
            Variable[] varSplit = VariableFactory.createBuckets(stackFrame, false, path, varType, typeName, size);
            result.getExistingValue().setVariables(varSplit);
        } else {
            return new Variable(stackFrame, name, path, typeName, varType, value, hasChildren);
        }
        return result;
    }

    private static boolean isSvArray(String varType) {
        return varType.equals("sv_array") || varType.equals("sv_assoc_array") || varType.equals("sv_queue");
    }

    private static Variable[] createBuckets(StackFrame stackFrame, boolean joinPathSplit, String path, String varType, String typeName, int size) {
        int nrSplits = size / 100;
        int lastPartLen = size % 100;
        if (lastPartLen != 0) {
            ++nrSplits;
        } else {
            lastPartLen = 100;
        }
        Variable[] varSplit = new ListVariable[nrSplits];
        int i = 0;
        while (i < nrSplits) {
            String split;
            int rangeEnd;
            int rangeStart = i * 100;
            if (i == nrSplits - 1) {
                rangeEnd = i * 100 + lastPartLen - 1;
                split = DVTStringUtil.appendString("[", rangeStart, "..", rangeEnd, "]");
            } else {
                rangeEnd = (i + 1) * 100 - 1;
                split = DVTStringUtil.appendString("[", rangeStart, "..", rangeEnd, "]");
            }
            varSplit[i] = new ListVariable(stackFrame, split, "", joinPathSplit ? String.valueOf(path) + split : path, typeName, varType, rangeStart, rangeEnd);
            ++i;
        }
        return varSplit;
    }

    public static WatchExpressionResult createWatchExpressionResultFromXMLMessage(StackFrame stackFrame, XMLMessage xmlMessage) {
        String value = null;
        value = xmlMessage.getStatus() == 1 ? "*** ERROR: I/O communication error." : (xmlMessage.getStatus() == 2 ? "*** ERROR: Message decoding error." : (xmlMessage.getStatus() == 3 ? "*** ERROR: Connection timeout." : (xmlMessage.getStatus() == 4 ? "*** ERROR: Target fail." : xmlMessage.getAttributeValue("name"))));
        List<XMLMessage> variableXMLMessages = xmlMessage.getChildren("variable");
        if (variableXMLMessages != null && !variableXMLMessages.isEmpty()) {
            value = variableXMLMessages.get(0).getAttributeValue("value");
        }
        WatchExpressionResult result = new WatchExpressionResult(stackFrame, xmlMessage, value);
        return result;
    }
}

