/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.model.Threads;
import ro.amiq.dvt.debug.core.model.variables.Value;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.utils.DVTStringUtil;

public class VariablesSnapshot {
    private Map<String, Map<String, Variable>> fSnapshot = new HashMap<String, Map<String, Variable>>();

    public boolean hasValueChanged(Variable variable) {
        if (variable == null) {
            return false;
        }
        Variable snapshotVariable = this.getFromSnapshot(variable);
        if (snapshotVariable == null) {
            return false;
        }
        Value value = variable.getExistingValue();
        Value snapshotValue = snapshotVariable.getExistingValue();
        if (value == null || snapshotValue == null) {
            return false;
        }
        String valueString = value.getValueString();
        if (valueString == null) {
            return false;
        }
        return !valueString.equals(snapshotValue.getValueString()) || value.hasVariables() != snapshotValue.hasVariables();
    }

    public void takeThreadsSnapshot(Threads threads) {
        if (threads == null) {
            return;
        }
        Thread[] threadsList = threads.getExistingThreads();
        if (threadsList == null) {
            return;
        }
        int i = 0;
        while (i < threadsList.length) {
            Thread thread = threadsList[i];
            if (thread != null && thread.isActive()) {
                this.removeThreadSnapshot(thread);
                StackFrame[] frames = thread.getExistingStackFrames();
                if (frames != null) {
                    int j = 0;
                    while (j < frames.length) {
                        if (frames[j] != null) {
                            this.takeSnapshot(frames[j].getRootVar());
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void takeExpressionsSnapshot(Collection<IWatchExpressionResult> expressions) {
        for (IWatchExpressionResult expression : expressions) {
            this.takeSnapshot((Value)expression.getValue());
        }
    }

    private void takeSnapshot(Value value) {
        if (value == null) {
            return;
        }
        Variable[] variables = value.getExistingVariables();
        if (variables == null) {
            return;
        }
        int i = 0;
        while (i < variables.length) {
            if (variables[i] != null) {
                this.takeSnapshot(variables[i]);
            }
            ++i;
        }
    }

    private void takeSnapshot(Variable variable) {
        if (variable == null) {
            return;
        }
        this.addToSnapshot(variable);
        Value value = variable.getExistingValue();
        if (value == null) {
            return;
        }
        Variable[] variables = value.getExistingVariables();
        if (variables == null) {
            return;
        }
        int i = 0;
        while (i < variables.length) {
            if (variables[i] != null) {
                this.takeSnapshot(variables[i]);
            }
            ++i;
        }
    }

    private void removeThreadSnapshot(Thread thread) {
        if (thread == null) {
            return;
        }
        this.fSnapshot.remove(thread.getName());
    }

    private void addToSnapshot(Variable variable) {
        if (variable == null) {
            return;
        }
        StackFrame stackFrame = variable.getStackFrame();
        if (stackFrame == null) {
            return;
        }
        Thread thread = stackFrame.getThread();
        if (thread == null) {
            return;
        }
        Map<String, Variable> threadSnapshot = this.fSnapshot.get(thread.getName());
        if (threadSnapshot == null) {
            threadSnapshot = new HashMap<String, Variable>();
            this.fSnapshot.put(thread.getName(), threadSnapshot);
        }
        threadSnapshot.put(this.getKey(variable), variable);
    }

    private Variable getFromSnapshot(Variable variable) {
        if (variable == null) {
            return null;
        }
        StackFrame stackFrame = variable.getStackFrame();
        if (stackFrame == null) {
            return null;
        }
        Thread thread = stackFrame.getThread();
        if (thread == null) {
            return null;
        }
        Map<String, Variable> perThreadSnapshot = this.fSnapshot.get(thread.getName());
        if (perThreadSnapshot != null) {
            return perThreadSnapshot.get(this.getKey(variable));
        }
        return null;
    }

    private String getKey(Variable variable) {
        StackFrame stackFrame = variable.getStackFrame();
        if (stackFrame == null) {
            return variable.getPath();
        }
        Thread thread = stackFrame.getThread();
        if (thread == null) {
            return variable.getPath();
        }
        return DVTStringUtil.appendString(thread.getName(), ".", stackFrame.getName(), ".", variable.getPath());
    }
}

