/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpEvaluator;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugElement;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.intrp.model.IntrpValue;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.Thread;
import ro.amiq.dvt.debug.core.model.breakpoints.BreakpointsUtils;
import ro.amiq.dvt.debug.core.model.variables.DVTWatchExpressionResult;
import ro.amiq.dvt.debug.core.model.variables.WatchExpressionErrorValue;
import ro.amiq.dvt.debug.core.model.variables.WatchExpressionGuardian;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.utils.XGlobalCache;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        StackFrame frame = null;
        if (context instanceof StackFrame) {
            frame = (StackFrame)context;
        } else if (context instanceof Thread) {
            frame = ((Thread)context).getCurrentStackFrame();
        } else if (context instanceof IntrpStackFrame) {
            this.handleSimVariables((IntrpStackFrame)context, expression, listener);
            return;
        }
        if (frame != null) {
            ((DebugTarget)frame.getDebugTarget()).getWatchExpressionResult(frame, listener, expression);
        }
    }

    private void handleSimVariables(IntrpStackFrame intrpFrame, String expression, IWatchExpressionListener listener) {
        IDebugTarget debugTarget = intrpFrame.getDebugTarget();
        if (!(debugTarget instanceof IntrpDebugTarget)) {
            return;
        }
        IThread thread = intrpFrame.getThread();
        if (!(thread instanceof IntrpDebugThread)) {
            return;
        }
        IntrpDebugThread debugThread = (IntrpDebugThread)thread;
        IIntrpEvaluator intrpEvaluator = debugThread.getIntrpEvaluator();
        IRfSingleLangProject rfProject = intrpEvaluator.getRfProject();
        if (rfProject == null) {
            return;
        }
        IProject project = rfProject.getProject();
        IXSim xSim = XGlobalCache.INSTANCE.getXSim(project);
        if (xSim == null) {
            return;
        }
        WatchExpressionGuardian watchExpressionGuardian = new WatchExpressionGuardian(xSim);
        ELParamValueScope result = BreakpointsUtils.evaluateExpression(expression, (IntrpDebugTarget)debugTarget, debugThread, watchExpressionGuardian);
        IntrpDebugElement value = null;
        if (result == null || result == IELParamValue.UNDEFINED_VALUE || result.value == null || result.value == IELParamValue.UNDEFINED_VALUE) {
            value = new WatchExpressionErrorValue((IntrpDebugTarget)debugTarget, watchExpressionGuardian.getErrorMessages());
        } else {
            IELParamValue eLParamValue = result.value;
            String stringValue = null;
            stringValue = eLParamValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum ? this.getEnumValue(eLParamValue) : eLParamValue.debuggerGetValueString(expression, eLParamValue);
            String associatedTypeName = "";
            IRfNamedElement element = result.getElement();
            if (element instanceof IRfAssociatedTypeElement) {
                associatedTypeName = ((IRfAssociatedTypeElement)element).getAssociatedTypeName();
            }
            IntrpVariable variable = new IntrpVariable(debugTarget, expression, associatedTypeName, result.value, result.scope, intrpEvaluator);
            value = new IntrpValue(debugTarget, variable, stringValue, debugThread.getIntrpEvaluator(), result.value);
        }
        listener.watchEvaluationFinished((IWatchExpressionResult)new DVTWatchExpressionResult((IValue)value));
    }

    private String getEnumValue(IELParamValue eLParamValue) {
        ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum enumValueElement = (ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum)eLParamValue;
        ELEnumTypeWrapper enumTypeValueHolder = enumValueElement.getEnumTypeWrapper();
        if (enumTypeValueHolder == null) {
            return "";
        }
        IELParamValue enumStringValue = enumTypeValueHolder.getItemValue(eLParamValue.toNiceString(null, 2, false, false));
        if (enumStringValue == null) {
            return "";
        }
        return enumStringValue.toNiceString(null, -2, false, false);
    }
}

