/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.model.variables;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvaluationGuardianCacheImpl;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalPartSelectIndexException;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalRangeException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsAggregateException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.ReversedPartSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.utils.LazyString;

public class WatchExpressionGuardian
extends HidEvaluationGuardianCacheImpl {
    private IXSim xSim;
    private List<String> errorMessages = new ArrayList<String>();

    public WatchExpressionGuardian(IXSim xSim) {
        this.xSim = xSim;
    }

    @Override
    public IXSim.XSimMode simulatorMode() {
        return this.xSim.simulatorMode();
    }

    @Override
    public void report(UnknownEvaluationException ex) {
    }

    @Override
    public void report(IllegalRangeException evalEx) {
        IHidObject causeObject = evalEx.getCauseObject();
        if (HidUtils.isHidAccess(causeObject)) {
            causeObject = ((HidAccess)causeObject).getParentHid();
        }
        if (evalEx instanceof OutOfBoundsAggregateException) {
            OutOfBoundsAggregateException boundsEx = (OutOfBoundsAggregateException)evalEx;
            this.logError(MessageFormat.format("OUT_OF_BOUNDS_VALUE_IN_AGGREGATE: ''{0}'' is not in the range ''{1}''", boundsEx.getOutsideValue(), boundsEx.getCauseMessage()), true);
        } else if (evalEx instanceof ReversedPartSelectException) {
            this.logError(MessageFormat.format("REVERSED_PART_SELECT: Part-select ''{0}'' indices must be reversed", HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false)), true);
        } else if (evalEx instanceof IllegalPartSelectIndexException) {
            boolean isIndexPartSelect;
            boolean bl = isIndexPartSelect = causeObject instanceof HidOperator && (((IHidOperator)causeObject).isPlusIndexPartSelect() || ((IHidOperator)causeObject).isMinusIndexPartSelect());
            if (isIndexPartSelect) {
                this.logError(MessageFormat.format("ILLEGAL_INDEXED_PART_SELECT: Indexed part-select ''{0}'' width cannot evaluate to ''x' or ''z'", HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false)), true);
            } else {
                this.logError(MessageFormat.format("ILLEGAL_PART_SELECT: Part-select ''{0}'' indices cannot evaluate to ''x' or ''z'", HidUtils.toStringBuilder(causeObject, true, true, false, true, true, false)), true);
            }
        } else if (evalEx instanceof OutOfBoundsSelectException) {
            String[] outsideValues;
            OutOfBoundsSelectException boundsEx = (OutOfBoundsSelectException)evalEx;
            String dimension = boundsEx.getPackedDimension();
            String[] stringArray = outsideValues = boundsEx.getOutsideValues();
            int n = outsideValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.logError(MessageFormat.format("OUT_OF_BOUNDS_SELECT: Index ''{0}'' of part-select is out of ''{1}'' bounds", value, dimension), true);
                ++n2;
            }
        }
    }

    @Override
    public boolean isVlogSystemCallExecuted(String name) {
        return this.xSim.getFactory().isVlogSystemCallExecuted(name);
    }

    @Override
    public void incrementStepCount(int count) {
    }

    @Override
    public void checkEvaluationStepLimit(IHidObject hidObject) {
    }

    @Override
    public void resetStepCount() {
    }

    @Override
    public void checkBuildCanceled() {
    }

    @Override
    public boolean shouldSkip(IHidObject obj) {
        return false;
    }

    @Override
    public XValueHolderFactory getFactory() {
        return this.xSim.getFactory();
    }

    @Override
    public boolean isInterpreter() {
        return true;
    }

    @Override
    public void logError(LazyString message) {
        this.errorMessages.add(message.toString());
    }

    @Override
    public void logError(String message, boolean printStackTrace) {
        this.errorMessages.add(message);
    }

    @Override
    public void logError(String message) {
        this.errorMessages.add(message);
    }

    @Override
    public void logError(String message, IRfDefElement declaration) {
        this.errorMessages.add(message);
    }

    @Override
    public void logMessage(String message) {
    }

    @Override
    public void logStatement(String message) {
    }

    @Override
    public void logWarning(String message) {
    }

    @Override
    public void logWarning(String message, boolean printStackTrace) {
    }

    @Override
    public void logWarning(String message, IRfDefElement declaration) {
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

