/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.sourcelookup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import ro.amiq.dvt.utils.DVTFileUtils;

public class CompiledSourcesContainer
extends AbstractSourceContainer {
    public static final String SEPARATOR = ";";

    public Object[] findSourceElements(String name) throws CoreException {
        IFile candidate;
        IProject project = null;
        if (name.contains(SEPARATOR)) {
            String[] split = name.split(SEPARATOR);
            if (split.length != 2) {
                return new IFile[0];
            }
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(split[0]);
            name = split[1];
        }
        if (project != null && project.exists() && (candidate = DVTFileUtils.getInstance().findProjectFile(project, name)) != null) {
            return new Object[]{candidate};
        }
        Object[] workspaceFiles = DVTFileUtils.getInstance().getWorkspaceFiles(null, name);
        return workspaceFiles;
    }

    public String getName() {
        return "DVT Project Compiled Files";
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType("ro.amiq.dvt.debug.core.sourcelookup.CompiledSourcesContainerType");
    }
}

