/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.comm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.util.comm.CommEnter;
import ro.amiq.dvt.debug.core.util.comm.CommReplay;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageParser;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTSystemVariables;

public class CommManager {
    private static final int WAIT_CONSTANT = 100;
    private DebugTarget fDebugTarget;
    private int fTimeout;
    private int fTimeSendDelta;
    private Socket fCommSocket;
    private BufferedWriter fWriter;
    private BufferedReader fReader;
    private List<XMLMessage> fResponses;
    private ResponsesPollingJob fResponsesPollingJob;
    private EventsPollingJob fEventsPollingJob;
    private boolean fTerminated;
    private boolean fCommFailure;
    private long fSentTimestamp;
    private int fLastTimeoutID;
    private CommEnter fEnter = new CommEnter("adf6b465a8b61446df37d92fb4691bd0");
    private ShutDownListener fShutdownListener;
    private CommReplay fCommReplay;

    public CommManager(DebugTarget target, int port) throws UnknownHostException, IOException {
        this(target, 3000, 30, port, "127.0.0.1");
    }

    public CommManager(DebugTarget target, int timeout, int timeSendDelta, int port, String address) throws UnknownHostException, IOException {
        this.fDebugTarget = target;
        this.fTimeout = timeout;
        this.fTimeSendDelta = timeSendDelta;
        this.fTerminated = false;
        this.fResponses = new ArrayList<XMLMessage>();
        this.fLastTimeoutID = -1;
        this.createSockets(port, address);
        this.fResponsesPollingJob = new ResponsesPollingJob();
        this.fResponsesPollingJob.schedule();
        this.fEventsPollingJob = new EventsPollingJob();
        this.fEventsPollingJob.schedule();
        this.fShutdownListener = new ShutDownListener();
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this.fShutdownListener);
    }

    private void createSockets(int port, String address) throws UnknownHostException, IOException {
        this.closeSockets();
        this.fCommFailure = false;
        this.fCommReplay = null;
        File debuggerLogFile = DVTSystemVariables.getFile("DVT_DEBUGGER_REPLAY_LOG");
        if (debuggerLogFile != null) {
            this.fCommReplay = new CommReplay(debuggerLogFile);
            return;
        }
        this.fCommSocket = new Socket(address, port);
        this.fReader = new BufferedReader(new InputStreamReader(this.fCommSocket.getInputStream()));
        this.fWriter = new BufferedWriter(new OutputStreamWriter(this.fCommSocket.getOutputStream()));
    }

    private boolean readerIsReady() throws IOException {
        if (this.fCommReplay == null) {
            return this.fReader.ready();
        }
        return this.fCommReplay.ready();
    }

    private String readLine() throws IOException {
        if (this.fCommReplay == null) {
            String readLine = this.fReader.readLine();
            DebugUtils.syso("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            DebugUtils.syso("DVT response:" + readLine);
            if (readLine != null) {
                DebugUtils.printXML(readLine);
            }
            DebugUtils.syso("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            return this.fEnter.d(readLine);
        }
        return this.fCommReplay.readLine();
    }

    private void writeLine(String command) {
        if (this.fCommReplay == null) {
            try {
                String e = this.fEnter.e(String.valueOf(command.trim()) + "\n");
                DebugUtils.syso(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                DebugUtils.syso("DVT command:" + e);
                DebugUtils.syso(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                this.fWriter.write(e);
                this.fWriter.flush();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void closeSockets() {
        try {
            if (this.fCommSocket != null) {
                this.fCommSocket.close();
            }
            if (this.fResponses != null) {
                this.fResponses.clear();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int getMessageID(XMLMessage xmlMessage) {
        try {
            String idText = xmlMessage.getAttributeValue("id");
            return DVTStringUtil.parseInt(idText, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    private XMLMessage fetchNextResponse() {
        block4: {
            try {
                if (this.readerIsReady()) break block4;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        String response = this.readLine();
        if (response != null) {
            return XMLMessageParser.getInstance().scan(response);
        }
        return null;
    }

    public XMLMessage executeCommand(XMLMessage command) {
        this.sendRequest(command);
        return this.waitForResponse(command, true);
    }

    public void sendRequest(XMLMessage request) {
        String command = request.createXMLString();
        if (this.isTerminated()) {
            return;
        }
        long delta = System.currentTimeMillis() - this.fSentTimestamp;
        if (delta < (long)this.fTimeSendDelta) {
            try {
                Thread.sleep((long)this.fTimeSendDelta - delta);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fSentTimestamp = System.currentTimeMillis();
        if (this.isTerminated()) {
            return;
        }
        this.writeLine(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMessage waitForResponse(XMLMessage xmlMessage, boolean handleCommunicationFailure) {
        XMLMessage response = null;
        if (this.fCommFailure) {
            response = new XMLMessage(3);
            return response;
        }
        try {
            long timestamp = System.currentTimeMillis();
            while (!this.isTerminated()) {
                List<XMLMessage> list = this.fResponses;
                synchronized (list) {
                    response = this.getResponseForCommand(xmlMessage);
                    if (response != null) {
                        break;
                    }
                    this.fResponses.wait(100L);
                    if (System.currentTimeMillis() - timestamp > (long)this.fTimeout) {
                        break;
                    }
                }
            }
            if (response == null) {
                this.fLastTimeoutID = this.getMessageID(xmlMessage);
                response = new XMLMessage(3);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!this.isTerminated() && handleCommunicationFailure && response == null) {
            this.handleCommunicationFailure(xmlMessage);
        }
        if (!this.isTerminated() && handleCommunicationFailure && response != null && response.getStatus() == 1) {
            this.handleCommunicationFailure(xmlMessage);
        }
        return response;
    }

    private XMLMessage getResponseForCommand(XMLMessage command) {
        int i = 0;
        while (i < this.fResponses.size()) {
            XMLMessage response = this.fResponses.get(i);
            if ("sn_resp".equals(response.getName())) {
                String responseCommand = response.getAttributeValue("cmd");
                if (command.getAttributeValue("id").equals(response.getAttributeValue("id")) && responseCommand != null && responseCommand.equals(command.getAttributeValue("cmd"))) {
                    return this.fResponses.remove(i);
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private XMLMessage waitForEvent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private XMLMessage getNextEvent() {
        int i = 0;
        while (i < this.fResponses.size()) {
            XMLMessage response = this.fResponses.get(i);
            if (response.getName().equals("sn_notif")) {
                return this.fResponses.remove(i);
            }
            ++i;
        }
        return null;
    }

    private boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() {
        try {
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this.fShutdownListener);
            this.closeSockets();
            this.fTerminated = true;
            this.fCommFailure = false;
            this.fResponsesPollingJob.cancel();
            this.fEventsPollingJob.cancel();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean handshake(String connStartupFlags, IProgressMonitor launchMonitor) {
        this.fEnter = new CommEnter(connStartupFlags);
        this.fEnter.enter2(null);
        XMLMessage command = XMLMessageFactory.getInstance().createCommandMessage("ping");
        this.sendRequest(command);
        int i = 0;
        while (i < 20) {
            if (launchMonitor.isCanceled()) {
                return false;
            }
            XMLMessage response = this.waitForResponse(command, false);
            if (response != null) {
                int rspPort = this.fEnter.enter(response, this.fCommSocket.getPort());
                if (rspPort == this.fCommSocket.getPort()) {
                    this.fEnter.enter2(null);
                } else {
                    this.fEnter.enter2("1");
                }
                return true;
            }
            ++i;
        }
        this.fEnter.enter2("2");
        return false;
    }

    private void handleCommunicationFailure(final XMLMessage command) {
        if (this.fCommFailure) {
            return;
        }
        this.fCommFailure = true;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Communication Failure", null, "[" + command.getAttributeValue("id") + "] Do you want to reconnect?", 3, new String[]{"Terminate", "Reconnect"}, 0);
                CommManager.this.fDebugTarget.handleConnectionFailure(dialog.open() != 0);
            }
        });
    }

    class EventsPollingJob
    extends Job {
        public EventsPollingJob() {
            super("DVT Debugger - Events Polling Job");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!CommManager.this.isTerminated()) {
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                XMLMessage xmlMessage = CommManager.this.waitForEvent();
                if (xmlMessage == null) continue;
                String command = xmlMessage.getAttributeValue("command");
                if ("suspend".equals(command)) {
                    CommManager.this.fDebugTarget.notifyTargetSimulationState(xmlMessage.getChild("simutation_state"));
                    continue;
                }
                if ("finish".equals(command)) {
                    CommManager.this.fDebugTarget.notifyTargetSimulationState(xmlMessage.getChild("simutation_state"));
                    continue;
                }
                if ("add_breakpoint".equals(command)) {
                    CommManager.this.fDebugTarget.getBreakpointManager().notifyBreakpointAdded(xmlMessage.getChild("breakpoint"));
                    continue;
                }
                if ("del_breakpoint".equals(command)) {
                    CommManager.this.fDebugTarget.getBreakpointManager().notifyBreakpointRemoved(xmlMessage.getChild("breakpoint"));
                    continue;
                }
                if (!"error".equals(command)) continue;
                CommManager.this.fDebugTarget.notifyTargetSimulationError(xmlMessage.getChild("type"), xmlMessage.getChild("initial_command"));
            }
            return Status.OK_STATUS;
        }
    }

    class ResponsesPollingJob
    extends Job {
        public ResponsesPollingJob() {
            super("DVT Debugger - Response Polling Job");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!CommManager.this.isTerminated()) {
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                XMLMessage xmlMessage = CommManager.this.fetchNextResponse();
                if (xmlMessage != null) {
                    int messageID = CommManager.this.getMessageID(xmlMessage);
                    if (messageID != -1 && messageID <= CommManager.this.fLastTimeoutID && !"sn_notif".equals(xmlMessage.getName())) continue;
                    List<XMLMessage> list = CommManager.this.fResponses;
                    synchronized (list) {
                        CommManager.this.fResponses.add(xmlMessage);
                        CommManager.this.fResponses.notifyAll();
                        continue;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return Status.OK_STATUS;
        }
    }

    class ShutDownListener
    implements IWorkbenchListener {
        ShutDownListener() {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            CommManager.this.terminate();
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
            CommManager.this.terminate();
        }
    }
}

