/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.comm;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageFactory;
import ro.amiq.dvt.startup.core.DVTLogger;

public class CommReplay {
    private static final Pattern ID_PATTERN = Pattern.compile(".*id=\"(\\d+)\".*");
    private List<String> fLogResponses;
    private int fLogIndex;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommReplay(File debuggerLogFile) {
        int firstResponseId;
        block17: {
            if (debuggerLogFile == null) {
                return;
            }
            this.fLogResponses = new ArrayList<String>();
            this.fLogIndex = 0;
            firstResponseId = -1;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(debuggerLogFile));
                    try {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                            String strLine;
                            while ((strLine = br.readLine()) != null) {
                                if (!strLine.startsWith("DVT response:")) continue;
                                this.fLogResponses.add(strLine.substring("DVT response:".length()));
                                Matcher matcher = ID_PATTERN.matcher("");
                                if (firstResponseId != -1 || !matcher.reset(strLine).matches()) continue;
                                firstResponseId = Integer.parseInt(matcher.group(1));
                            }
                        }
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    ((InputStream)is).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (firstResponseId == -1) return;
        XMLMessageFactory.getInstance().setIncrementCommandCounter(firstResponseId);
    }

    public boolean ready() {
        return this.fLogIndex < this.fLogResponses.size();
    }

    public String readLine() {
        if (this.fLogIndex < this.fLogResponses.size()) {
            String result = this.fLogResponses.get(this.fLogIndex);
            ++this.fLogIndex;
            return result;
        }
        return null;
    }
}

