/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.comm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class WordMap {
    private static final String DVT_PREFIX = "dvt_";
    private HashMap<String, String> map = new LinkedHashMap<String, String>();
    private HashMap<String, String> reverseMap = new LinkedHashMap<String, String>();
    private Set<String> bans = new HashSet<String>();
    private int next;

    public void ban(String globalVarObfuscatedName) {
        this.bans.add(globalVarObfuscatedName);
    }

    public void clear() {
        this.next = 0;
        this.map.clear();
        this.reverseMap.clear();
        this.bans.clear();
    }

    public String makeReplacement(String original) {
        String result = this.map.get(original);
        if (result == null) {
            this.genNextString();
            result = DVT_PREFIX + this.next;
            this.map.put(original, result);
            if (this.map.containsKey(result)) {
                throw new IllegalArgumentException();
            }
            this.reverseMap.put(result, original);
        }
        return result;
    }

    private void genNextString() {
        ++this.next;
        if (this.bans.contains(DVT_PREFIX + this.next)) {
            this.genNextString();
        }
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public Map<String, String> getReverseMap() {
        return this.reverseMap;
    }
}

