/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XMLMessage {
    protected String fName;
    protected String fValue;
    protected List<XMLMessage> fChildren;
    protected AttributesImpl fAttributes;
    protected int fStatus;

    private XMLMessage(String name, String value, String[] attrNames, String[] attrValues) {
        this.fName = name;
        this.fValue = value;
        this.fAttributes = new AttributesImpl();
        int i = 0;
        while (i < attrNames.length) {
            this.fAttributes.addAttribute(null, name, attrNames[i], "String", attrValues[i]);
            ++i;
        }
        this.fChildren = null;
    }

    public static XMLMessage createXMLMessage(String name, String value, String[] attrNames, String[] attrValues) {
        if (attrNames.length != attrValues.length) {
            return null;
        }
        return new XMLMessage(name, value, attrNames, attrValues);
    }

    public XMLMessage(String name, String value, Attributes attributes) {
        this.fName = name;
        this.fValue = value;
        this.fAttributes = new AttributesImpl();
        this.fAttributes.setAttributes(attributes);
        this.fChildren = null;
        this.fStatus = 0;
    }

    public XMLMessage(int status) {
        this.fStatus = status;
    }

    public void setStatus(int status) {
        this.fStatus = status;
    }

    public int getStatus() {
        return this.fStatus;
    }

    public void addAttribute(String name, String value) {
        this.fAttributes.addAttribute(null, this.fName, name, "String", value);
    }

    public void addChild(XMLMessage child) {
        if (child == null) {
            return;
        }
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<XMLMessage>();
        }
        this.fChildren.add(child);
    }

    public void setValue(String value) {
        if ("fail".equals(value)) {
            this.fStatus = 4;
        }
        this.fValue = value;
    }

    public String getName() {
        return this.fName;
    }

    public String getValue() {
        return this.fValue;
    }

    public boolean hasValue() {
        return this.fValue != null;
    }

    public String getAttributeValue(String name) {
        if (this.fAttributes != null) {
            return this.fAttributes.getValue(name);
        }
        return null;
    }

    public XMLMessage getChild(String name) {
        if (this.fChildren == null) {
            return null;
        }
        for (XMLMessage child : this.fChildren) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public List<XMLMessage> getChildren() {
        return this.fChildren;
    }

    public List<XMLMessage> getChildren(String name) {
        if (name == null) {
            return null;
        }
        if (this.fChildren == null) {
            return null;
        }
        ArrayList<XMLMessage> result = null;
        for (XMLMessage child : this.fChildren) {
            if (!name.equals(child.getName())) continue;
            if (result == null) {
                result = new ArrayList<XMLMessage>();
            }
            result.add(child);
        }
        return result;
    }

    public String createXMLString() {
        String result = "<" + this.fName;
        int i = 0;
        while (i < this.fAttributes.getLength()) {
            result = String.valueOf(result) + " " + this.fAttributes.getQName(i) + "=\\\"" + this.toXML(this.fAttributes.getValue(i)) + "\\\"";
            ++i;
        }
        result = String.valueOf(result) + ">";
        if (this.fChildren != null) {
            for (XMLMessage child : this.fChildren) {
                result = String.valueOf(result) + child.createXMLString();
            }
        }
        result = String.valueOf(result) + this.fValue;
        result = String.valueOf(result) + "</" + this.fName + ">";
        return result;
    }

    private String toXML(String value) {
        return value.replaceAll("[\r\n]+", " ").replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;").replace("\"", "&quot;").trim();
    }
}

