/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.xml;

import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IVariable;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.variables.Variable;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;
import ro.amiq.dvt.debug.core.util.xml.XMLMessageConstants;

public final class XMLMessageFactory {
    private static volatile XMLMessageFactory fInstance;
    private static final Object fSyncInstance;
    private int fCommandCounter = 0;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLMessageFactory getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new XMLMessageFactory();
            }
        }
        return fInstance;
    }

    public void setIncrementCommandCounter(int newCommandCounter) {
        this.fCommandCounter = newCommandCounter;
    }

    private int getAndIncrementCommandCounter() {
        return this.fCommandCounter++;
    }

    private XMLMessageFactory() {
    }

    public XMLMessage createMessage(String name, String value, String[] attrNames, String[] attrValues) {
        return XMLMessage.createXMLMessage(name, value, attrNames, attrValues);
    }

    public XMLMessage createCommandMessage(String command) {
        return this.createMessage("dvt", "", XMLMessageConstants.DVT_ATTRIBUTES, new String[]{String.valueOf(this.getAndIncrementCommandCounter()), command, "1"});
    }

    private XMLMessage createCommandMessage(String command, String[] attrNames, String[] attrValues) {
        assert (attrNames.length == attrValues.length);
        XMLMessage resultXMLMessage = this.createCommandMessage(command);
        int i = 0;
        while (i < attrNames.length) {
            resultXMLMessage.addAttribute(attrNames[i], attrValues[i]);
            ++i;
        }
        return resultXMLMessage;
    }

    public XMLMessage makeResumeNCommand(int period) {
        return this.createCommandMessage("resume", XMLMessageConstants.COMMAND_RESUME_ATTRIBUTES, new String[]{String.valueOf(period)});
    }

    public XMLMessage makeBreakpointCommand(IBreakpoint breakpoint, String command) {
        XMLMessage xmlMessage;
        XMLMessage resultXMLMessage = this.createCommandMessage(command);
        if (breakpoint instanceof BaseBreakpoint && (xmlMessage = ((BaseBreakpoint)breakpoint).toXMLMessage()) != null) {
            resultXMLMessage.addChild(xmlMessage);
        }
        return resultXMLMessage;
    }

    public XMLMessage makeThreadStackCommand(int threadId) {
        return this.createCommandMessage("get thread stack", XMLMessageConstants.COMMAND_GET_THREAD_STACK_ATTRIBUTES, new String[]{String.valueOf(threadId)});
    }

    public XMLMessage makeChangeValueCommand(String path, String value) {
        return this.createCommandMessage("change value", XMLMessageConstants.COMMAND_CHANGE_VALUE_ATTRIBUTES, new String[]{path, value});
    }

    public XMLMessage makeGetVariableCommand(IVariable variable) {
        XMLMessage resultXMLMessage = this.createCommandMessage("get variables");
        if (variable instanceof Variable) {
            resultXMLMessage.addChild(((Variable)variable).toXMLMessage());
            return resultXMLMessage;
        }
        return null;
    }

    public XMLMessage makeGetExpressionCommand(String expression, StackFrame context) {
        XMLMessage resultXMLMessage = this.createCommandMessage("get expression");
        String threadId = String.valueOf(context.getThread().getThreadId());
        String stackLevel = String.valueOf(context.getStackLevel());
        resultXMLMessage.addChild(this.createMessage("expression", "", XMLMessageConstants.EXPRESSION_ATTRIBUTES, new String[]{expression, threadId, stackLevel}));
        return resultXMLMessage;
    }

    public XMLMessage makeSetScopeCommand(int threadId, int stackLevel) {
        XMLMessage resultXMLMessage = this.createCommandMessage("set scope");
        resultXMLMessage.addChild(this.createMessage("scope", "", XMLMessageConstants.SCOPE_ATTRIBUTES, new String[]{String.valueOf(threadId), String.valueOf(stackLevel)}));
        return resultXMLMessage;
    }
}

