/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.core.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import ro.amiq.dvt.debug.core.util.xml.XMLMessage;

public class XMLMessageParser
extends DefaultHandler {
    private static volatile XMLMessageParser fInstance;
    private static final Object fSyncInstance;
    private int fCurrentLevel = 0;
    private XMLMessage fDataHolder;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLMessageParser getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new XMLMessageParser();
            }
        }
        return fInstance;
    }

    public XMLMessage scan(String message) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBytes());
        return this.scan(new InputSource(inputStream));
    }

    public XMLMessage scan(InputSource inputSource) {
        block4: {
            this.fDataHolder = null;
            this.fCurrentLevel = 0;
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(this);
                reader.setErrorHandler(this);
                reader.parse(inputSource);
            }
            catch (IOException iOException) {
                if (this.fDataHolder != null) {
                    this.fDataHolder.setStatus(1);
                }
            }
            catch (SAXException sAXException) {
                if (this.fDataHolder == null) break block4;
                this.fDataHolder.setStatus(2);
            }
        }
        return this.fDataHolder;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        if (this.fDataHolder == null) {
            this.fDataHolder = new XMLMessage(name, null, attributes);
        } else {
            XMLMessage dataHolder = this.getLastEntry(this.fCurrentLevel);
            XMLMessage childDataHolder = new XMLMessage(name, null, attributes);
            dataHolder.addChild(childDataHolder);
        }
        ++this.fCurrentLevel;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        --this.fCurrentLevel;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        XMLMessage dataHolder = this.getLastEntry(this.fCurrentLevel);
        char[] value = new char[length];
        int i = 0;
        while (i < length) {
            value[i] = ch[start + i];
            ++i;
        }
        dataHolder.setValue(String.valueOf(value));
    }

    protected XMLMessage getLastEntry(int level) {
        XMLMessage dataHolder = this.fDataHolder;
        int i = 0;
        while (i < level - 1) {
            if (dataHolder.fChildren == null) break;
            int childNo = dataHolder.fChildren.size() - 1;
            dataHolder = dataHolder.fChildren.get(childNo);
            ++i;
        }
        return dataHolder;
    }
}

