/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.model.IDVTSuspendResume;
import ro.amiq.dvt.debug.ui.util.ResumePopupDialog;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.BaseLRUCache;

public enum DynamicResumeDebuggerButtonContribution implements ISelectionListener,
IWindowListener,
IResourceChangeListener,
IPerspectiveListener
{
    INSTANCE;

    private static final String TOOLBAR_ID = "ro.amiq.dvt.dvtdebugger";
    private static final BaseLRUCache<Integer, Integer> CACHE;
    private static final String CUSTOM = "custom";
    private Set<IWorkbenchWindow> fWindows = new HashSet<IWorkbenchWindow>();
    private Action fTimedRun;
    private ActionContributionItem fTimedRunItem;

    static {
        CACHE = new BaseLRUCache(5);
    }

    public void init() {
        this.populateToolbar();
        this.addListeners();
        this.refresh();
    }

    private void populateToolbar() {
        IWorkbenchWindow window = DVTUiUtils.getActiveWorkbenchWindow();
        if (this.fWindows.contains(window)) {
            return;
        }
        this.fWindows.add(window);
        IToolBarManager toolbarManager = DVTUiUtils.getToolbarManager((String)TOOLBAR_ID);
        if (toolbarManager == null) {
            return;
        }
        this.addTimedRunAction(toolbarManager);
    }

    private void addListeners() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    private void addTimedRunAction(IToolBarManager toolbarManager) {
        this.fTimedRun = new Action(){

            public void run() {
                if (DynamicResumeDebuggerButtonContribution.this.fTimedRun.getText().isEmpty()) {
                    new ResumePopupDialog().open();
                } else {
                    DynamicResumeDebuggerButtonContribution.runCustomValue(DynamicResumeDebuggerButtonContribution.this.fTimedRun.getText());
                }
            }
        };
        this.fTimedRun.setMenuCreator(new IMenuCreator(){
            Menu menu;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                this.menu = new Menu(parent);
                this.menu.setVisible(true);
                ArrayList<Integer> timedRuns = new ArrayList<Integer>(CACHE.values());
                Collections.reverse(timedRuns);
                for (Integer timedRunPeriod : timedRuns) {
                    DynamicResumeDebuggerButtonContribution.this.addMenuItem(this.menu, timedRunPeriod.toString());
                }
                DynamicResumeDebuggerButtonContribution.this.addMenuItem(this.menu, DynamicResumeDebuggerButtonContribution.CUSTOM);
                return this.menu;
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                }
            }
        });
        this.setButtonInfo();
        this.fTimedRun.setImageDescriptor(DVTImages.RESUME_SIMULATION);
        this.fTimedRun.setEnabled(false);
        this.fTimedRunItem = new ActionContributionItem((IAction)this.fTimedRun);
        this.fTimedRunItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbarManager.add((IContributionItem)this.fTimedRunItem);
    }

    private void addMenuItem(Menu menu, String itemText) {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(itemText);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (menuItem.getText().equals(DynamicResumeDebuggerButtonContribution.CUSTOM)) {
                    new ResumePopupDialog().open();
                } else {
                    DynamicResumeDebuggerButtonContribution.runCustomValue(menuItem.getText());
                    DynamicResumeDebuggerButtonContribution.this.asyncRefresh();
                }
            }
        });
    }

    private void setEnablement() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (!(context instanceof IDVTSuspendResume)) {
            return;
        }
        this.fTimedRun.setEnabled(((IDVTSuspendResume)context).canResume());
    }

    private void refresh() {
        IPerspectiveDescriptor perspective;
        this.setEnablement();
        this.setButtonInfo();
        this.fTimedRunItem.setVisible(false);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage != null && (perspective = activePage.getPerspective()) != null) {
            String perspectiveID = perspective.getId();
            this.fTimedRunItem.setVisible(perspectiveID.equals("ro.amiq.dvt.debug.ui.perspectives.DebugPerspective"));
        }
        DVTUiUtils.redrawToolbarInCoolbar((String)TOOLBAR_ID);
    }

    private void asyncRefresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.refresh());
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.populateToolbar();
        this.asyncRefresh();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.refresh();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId != null && !changeId.equals("editorClose")) {
            this.refresh();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void windowClosed(IWorkbenchWindow arg0) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection) {
            return;
        }
        this.refresh();
    }

    public static void runCustomValue(String text) {
        IAdaptable context = DebugUITools.getDebugContext();
        if (!(context instanceof IDVTSuspendResume)) {
            return;
        }
        try {
            ((IDVTSuspendResume)context).resume(Integer.parseInt(text));
        }
        catch (NumberFormatException | DebugException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        CACHE.put(Integer.parseInt(text), Integer.parseInt(text));
    }

    private void setButtonInfo() {
        String buttonText = CUSTOM;
        if (!CACHE.isEmpty()) {
            buttonText = CACHE.getMostRecentlyUsedEntry().getKey().toString();
        }
        this.fTimedRun.setToolTipText("Resume Simulation (" + buttonText + ")");
        this.fTimedRun.setText(buttonText.equals(CUSTOM) ? "" : buttonText);
    }
}

