/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum DVTBreakpointUtils {
    INSTANCE;

    final HashSet<String> UVM_MESSAGE_MACROS = new HashSet<String>(Arrays.asList("uvm_info", "uvm_warning", "uvm_error", "uvm_fatal", "uvm_info_context", "uvm_warning_context", "uvm_error_context", "uvm_fatal_context"));

    public HashSet<String> getUvmMessageMacros() {
        return this.UVM_MESSAGE_MACROS;
    }

    public String sanitizeTraceText(String text) {
        if (text == null || text.isEmpty()) {
            text = "\"\"";
        }
        String[] textLines = DVTStringUtil.NEW_LINE.split(text);
        return Stream.of(textLines).map(String::trim).collect(Collectors.joining(" "));
    }
}

