/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.debug.ui.breakpoints.BreakpointDetailPane;
import ro.amiq.dvt.debug.ui.breakpoints.WatchpointDetailPane;

public class DVTDefaultPaneFactory
implements IDetailPaneFactory {
    public static final String ID = "DVTDefaultPaneFactory";
    private Map<String, String> fNameMap;

    public Set<String> getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            Object firstElementObject = selection.getFirstElement();
            if (!(firstElementObject instanceof LineBreakpoint)) {
                set.add(DefaultDetailPane.ID);
                return set;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)firstElementObject);
            if (lineBreakpoint instanceof Watchpoint) {
                set.add("DVT_DETAIL_PANE_WATCHPOINT");
            } else {
                set.add("DVT_DETAIL_PANE_BREAKPOINT");
            }
            return set;
        }
        return set;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IBreakpoint firstElement = (IBreakpoint)selection.getFirstElement();
            if (!(firstElement instanceof LineBreakpoint)) {
                return DefaultDetailPane.ID;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)firstElement;
            if (lineBreakpoint instanceof Watchpoint) {
                return "DVT_DETAIL_PANE_WATCHPOINT";
            }
            return "DVT_DETAIL_PANE_BREAKPOINT";
        }
        return DefaultDetailPane.ID;
    }

    public IDetailPane createDetailPane(String paneID) {
        switch (paneID) {
            case "DVT_DETAIL_PANE_BREAKPOINT": {
                return new BreakpointDetailPane();
            }
            case "DVT_DETAIL_PANE_WATCHPOINT": {
                return new WatchpointDetailPane();
            }
        }
        return new DefaultDetailPane();
    }

    public String getDetailPaneName(String paneID) {
        return this.getNameMap().get(paneID);
    }

    public String getDetailPaneDescription(String paneID) {
        return this.getNameMap().get(paneID);
    }

    private Map<String, String> getNameMap() {
        if (this.fNameMap == null) {
            this.fNameMap = new HashMap<String, String>();
            this.fNameMap.put("DVT_DETAIL_PANE_WATCHPOINT", "Watchpoint Pane");
        }
        return this.fNameMap;
    }
}

