/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.debug.core.model.DebugUtils;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.debug.ui.breakpoints.TracepointsUtils;
import ro.amiq.dvt.debug.ui.breakpoints.WatchpointsUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public class ToggleLineBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public LineBreakpoint toggleTrace(LineBreakpoint breakpoint, IResource resource, int breakpointLineNumber) {
        String traceText = RfMixedLangManager.getInstance().computeTraceTextAtLine(resource, breakpointLineNumber);
        breakpoint.setConditionEnabled(true);
        breakpoint.setCondition(traceText);
        return breakpoint;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ISelection sel = this.computeSelection(part, selection);
        if (!(sel instanceof StructuredSelection)) {
            this.toggleLineBreakpoints(part, selection);
        } else {
            this.toggleWatchpoints(part, selection);
        }
    }

    private ISelection computeSelection(IWorkbenchPart part, ISelection selection) throws CoreException {
        DVTEditor textEditor = this.getEditor(part);
        IEditorInput editorInput = textEditor.getEditorInput();
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        ISelection sel = WatchpointsUtils.INSTANCE.translateToFields(textEditor, selection, document);
        return sel;
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    protected DVTEditor getEditor(IWorkbenchPart part) {
        if (!(part instanceof DVTEditor)) {
            return null;
        }
        DVTEditor editorPart = (DVTEditor)part;
        IResource resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        if (!(resource instanceof IFile)) {
            return null;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", false);
        if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
            return editorPart;
        }
        fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
        if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
            return editorPart;
        }
        fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", false);
        if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
            return editorPart;
        }
        fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.pssdt.PSSSource", false);
        if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
            return editorPart;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        try {
            boolean shouldSetTracepoint = TracepointsUtils.shouldSetTracepoint();
            TracepointsUtils.setUnsetTracepoints(false);
            DVTEditor textEditor = this.getEditor(part);
            if (textEditor != null) {
                IBreakpoint[] breakpoints;
                IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
                ITextSelection ts = (ITextSelection)selection;
                int lineNumber = ts.getStartLine();
                IBreakpoint[] iBreakpointArray = breakpoints = DebugUtils.getAllEBreakpoints();
                int n = breakpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IBreakpoint breakpoint = iBreakpointArray[n2];
                    if (breakpoint instanceof Watchpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                        breakpoint.delete();
                        return;
                    }
                    ++n2;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    selection = this.computeSelection(part, selection);
                }
                IRfFieldElement field = (IRfFieldElement)((StructuredSelection)selection).getFirstElement();
                Watchpoint watchpoint = new Watchpoint(resource, null, null, lineNumber + 1, field);
                if (shouldSetTracepoint) {
                    watchpoint = (Watchpoint)this.toggleTrace(watchpoint, resource, lineNumber);
                    TracepointsUtils.setUnsetTracepoints(false);
                }
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)watchpoint);
                if (watchpoint.shouldDelete()) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)watchpoint, true);
                }
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        boolean shouldSetTracepoint = TracepointsUtils.shouldSetTracepoint();
        TracepointsUtils.setUnsetTracepoints(false);
        DVTEditor textEditor = this.getEditor(part);
        if (textEditor == null) {
            return;
        }
        IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
        if (resource == null) {
            return;
        }
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int breakpointLineNumber = textSelection.getStartLine() + 1;
        if (this.deleteBreakpoint(resource, breakpointLineNumber)) {
            return;
        }
        int actualLine = this.computeActualLineNumber(textEditor, resource, breakpointLineNumber);
        if (actualLine == -1) {
            return;
        }
        int initialLineNumber = breakpointLineNumber;
        if (initialLineNumber != (breakpointLineNumber = actualLine) && this.deleteBreakpoint(resource, breakpointLineNumber)) {
            return;
        }
        LineBreakpoint breakpoint = new LineBreakpoint(resource, null, null, breakpointLineNumber);
        if (shouldSetTracepoint) {
            breakpoint = this.toggleTrace(breakpoint, resource, breakpointLineNumber);
            TracepointsUtils.setUnsetTracepoints(false);
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
        if (breakpoint.shouldDelete()) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
        }
    }

    private int computeActualLineNumber(DVTEditor textEditor, IResource resource, int selectionLineNumber) {
        RfMixedLangManager rfMixedLangManagerInstance = RfMixedLangManager.getInstance();
        IDocument document = textEditor.getDocument();
        int offset = DVTFileUtils.getInstance().getLineCodeStartOffset((IFile)resource, document, selectionLineNumber - 1);
        if (offset == -1) {
            return -1;
        }
        IRfNamedElementAndScope namedElementAndScope = rfMixedLangManagerInstance.getRfElement((IFile)resource, document, offset);
        if (namedElementAndScope == null) {
            return -1;
        }
        IRfScopeElement scopeElement = namedElementAndScope.getScope();
        if (!(scopeElement instanceof IRfDefElement)) {
            return -1;
        }
        IRfDefElement scopeDef = (IRfDefElement)((Object)scopeElement);
        return rfMixedLangManagerInstance.getStatementLine((IFile)resource, textEditor, namedElementAndScope.getIRfNamedElement(), scopeDef, selectionLineNumber, offset);
    }

    private boolean deleteBreakpoint(IResource resource, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugUtils.getAllEBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                breakpoint.delete();
                return true;
            }
            ++n2;
        }
        return false;
    }
}

